/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.nomad.NomadCloud;

@Extension
public class NomadProvisioningStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(NomadProvisioningStrategy.class.getName());

    @Nonnull
    public NodeProvisioner.StrategyDecision apply(@Nonnull NodeProvisioner.StrategyState strategyState) {
        Label label = strategyState.getLabel();
        LoadStatistics.LoadStatisticsSnapshot snapshot = strategyState.getSnapshot();
        for (Cloud nomadCloud : Jenkins.get().clouds) {
            if (!(nomadCloud instanceof NomadCloud)) continue;
            LOGGER.log(Level.FINE, "Available executors={0} connecting executors={1} AdditionalPlannedCapacity={2} pending ={3}", new Object[]{snapshot.getAvailableExecutors(), snapshot.getConnectingExecutors(), strategyState.getAdditionalPlannedCapacity(), ((NomadCloud)nomadCloud).getPending()});
            int availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + strategyState.getAdditionalPlannedCapacity() + ((NomadCloud)nomadCloud).getPending();
            int currentDemand = snapshot.getQueueLength();
            LOGGER.log(Level.FINE, "Available capacity=" + availableCapacity + " currentDemand=" + currentDemand);
            if (availableCapacity < currentDemand) {
                Collection plannedNodes = nomadCloud.provision(label, currentDemand - availableCapacity);
                LOGGER.log(Level.FINE, "Planned " + plannedNodes.size() + " new nodes");
                strategyState.recordPendingLaunches(plannedNodes);
                LOGGER.log(Level.FINE, "After provisioning, available capacity=" + (availableCapacity += plannedNodes.size()) + " currentDemand=" + currentDemand);
            }
            if (availableCapacity >= currentDemand) {
                LOGGER.log(Level.FINE, "Provisioning completed");
                return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
            }
            LOGGER.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
            return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }
        LOGGER.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }
}

