/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.nomad.Api.JobInfo;
import org.jenkinsci.plugins.nomad.NomadApi;
import org.jenkinsci.plugins.nomad.NomadComputer;
import org.jenkinsci.plugins.nomad.NomadRetentionStrategy;
import org.jenkinsci.plugins.nomad.NomadWorker;
import org.jenkinsci.plugins.nomad.NomadWorkerTemplate;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NomadCloud
extends AbstractCloudImpl {
    private static final Logger LOGGER = Logger.getLogger(NomadCloud.class.getName());
    private final List<? extends NomadWorkerTemplate> templates;
    private final String nomadUrl;
    private final String nomadACLCredentialsId;
    private final Boolean prune;
    private String jenkinsUrl;
    private String jenkinsTunnel;
    private String workerUrl;
    private int workerTimeout = 1;
    private NomadApi nomad;
    private int pending = 0;

    @DataBoundConstructor
    public NomadCloud(String name, String nomadUrl, String jenkinsUrl, String jenkinsTunnel, String workerUrl, String workerTimeout, String nomadACLCredentialsId, Boolean prune, List<? extends NomadWorkerTemplate> templates) {
        super(name, null);
        this.nomadACLCredentialsId = nomadACLCredentialsId;
        this.nomadUrl = nomadUrl;
        this.jenkinsUrl = jenkinsUrl;
        this.jenkinsTunnel = jenkinsTunnel;
        this.workerUrl = workerUrl;
        this.setWorkerTimeout(workerTimeout);
        this.prune = prune;
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.readResolve();
    }

    private static String secretFor(String credentialsId) {
        List creds = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)credentialsId)));
        if (creds.size() > 0) {
            return ((StringCredentials)creds.get(0)).getSecret().getPlainText();
        }
        return null;
    }

    private Object readResolve() {
        this.nomad = new NomadApi(this.nomadUrl);
        if (this.jenkinsUrl.equals("")) {
            this.jenkinsUrl = Jenkins.get().getRootUrl();
        }
        if (this.workerUrl.equals("")) {
            this.workerUrl = this.jenkinsUrl + "jnlpJars/slave.jar";
        }
        return this;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        ArrayList<NodeProvisioner.PlannedNode> nodes = new ArrayList<NodeProvisioner.PlannedNode>();
        NomadWorkerTemplate template = this.getTemplate(label);
        if (template != null) {
            if (this.getPrune().booleanValue()) {
                this.pruneOrphanedWorkers(template);
            }
            try {
                while (excessWorkload > 0) {
                    LOGGER.log(Level.INFO, "Excess workload of " + excessWorkload + ", provisioning new Jenkins worker on Nomad cluster");
                    String workerName = template.createWorkerName();
                    nodes.add(new NodeProvisioner.PlannedNode(workerName, NomadComputer.threadPoolForRemoting.submit(new ProvisioningCallback(workerName, template, this)), template.getNumExecutors()));
                    excessWorkload -= template.getNumExecutors();
                    this.pending += template.getNumExecutors();
                }
                return nodes;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to schedule new Jenkins worker on Nomad cluster, message: " + e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private void pruneOrphanedWorkers(NomadWorkerTemplate template) {
        JobInfo[] nomadWorkers;
        for (JobInfo worker : nomadWorkers = this.nomad.getRunningWorkers(template.getPrefix(), this.getNomadACL())) {
            if (!worker.getStatus().equalsIgnoreCase("running")) continue;
            LOGGER.log(Level.FINE, "Found worker: " + worker.getName() + " - " + worker.getID());
            Node node = Jenkins.get().getNode(worker.getName());
            if (node != null) continue;
            LOGGER.log(Level.FINE, "Found Orphaned Node: " + worker.getID());
            this.nomad.stopWorker(worker.getID(), this.getNomadACL());
        }
    }

    public NomadWorkerTemplate getTemplate(Label label) {
        for (NomadWorkerTemplate nomadWorkerTemplate : this.templates) {
            if (label == null && !nomadWorkerTemplate.getLabelSet().isEmpty() || (label != null || !nomadWorkerTemplate.getLabelSet().isEmpty()) && (label == null || !label.matches(nomadWorkerTemplate.getLabelSet()))) continue;
            return nomadWorkerTemplate;
        }
        return null;
    }

    public boolean canProvision(Label label) {
        return Optional.ofNullable(this.getTemplate(label)).isPresent();
    }

    public String getName() {
        return this.name;
    }

    public String getNomadUrl() {
        return this.nomadUrl;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    public String getWorkerUrl() {
        return this.workerUrl;
    }

    public void setWorkerUrl(String workerUrl) {
        this.workerUrl = workerUrl;
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(String workerTimeout) {
        try {
            this.workerTimeout = Integer.parseInt(workerTimeout);
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, "Failed to parse timeout defaulting to current value (default: 1 minute): " + workerTimeout + " minutes");
        }
    }

    public String getNomadACLCredentialsId() {
        return this.nomadACLCredentialsId;
    }

    public String getNomadACL() {
        return NomadCloud.secretFor(this.getNomadACLCredentialsId());
    }

    public Boolean getPrune() {
        if (this.prune == null) {
            return false;
        }
        return this.prune;
    }

    public void setNomad(NomadApi nomad) {
        this.nomad = nomad;
    }

    public int getPending() {
        return this.pending;
    }

    public String getJenkinsTunnel() {
        return this.jenkinsTunnel;
    }

    public void setJenkinsTunnel(String jenkinsTunnel) {
        this.jenkinsTunnel = jenkinsTunnel;
    }

    public List<NomadWorkerTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public NomadApi nomad() {
        return this.nomad;
    }

    private class ProvisioningCallback
    implements Callable<Node> {
        String workerName;
        NomadWorkerTemplate template;
        NomadCloud cloud;

        public ProvisioningCallback(String workerName, NomadWorkerTemplate template, NomadCloud cloud) {
            this.workerName = workerName;
            this.template = template;
            this.cloud = cloud;
        }

        @Override
        public Node call() throws Exception {
            NomadWorker worker = new NomadWorker(this.workerName, NomadCloud.this.name, this.template, this.template.getLabels(), new NomadRetentionStrategy(this.template.getIdleTerminationInMinutes()), Collections.emptyList());
            Jenkins.get().addNode((Node)worker);
            String jnlpSecret = "";
            if (Jenkins.get().isUseSecurity()) {
                jnlpSecret = JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(this.workerName);
            }
            LOGGER.log(Level.INFO, "Asking Nomad to schedule new Jenkins worker");
            NomadCloud.this.nomad.startWorker(this.cloud, this.workerName, NomadCloud.this.getNomadACL(), jnlpSecret, this.template);
            Callable<Boolean> callableTask = () -> {
                try {
                    LOGGER.log(Level.INFO, "Worker scheduled, waiting for connection");
                    Objects.requireNonNull(worker.toComputer()).waitUntilOnline();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Waiting for connection was interrupted");
                    return false;
                }
                return true;
            };
            ExecutorService executorService = Executors.newCachedThreadPool();
            Future<Boolean> future = executorService.submit(callableTask);
            try {
                future.get(this.cloud.workerTimeout, TimeUnit.MINUTES);
                LOGGER.log(Level.INFO, "Connection established");
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Worker computer did not come online within " + NomadCloud.this.workerTimeout + " minutes, terminating worker" + (Object)((Object)worker));
                worker.terminate();
                throw new RuntimeException("Timed out waiting for agent to start up. Timeout: " + NomadCloud.this.workerTimeout + " minutes.");
            }
            finally {
                future.cancel(true);
                executorService.shutdown();
                NomadCloud.this.pending = NomadCloud.this.pending - this.template.getNumExecutors();
            }
            return worker;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Nomad";
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="nomadUrl") String nomadUrl) {
            Objects.requireNonNull(Jenkins.get()).checkPermission(Jenkins.ADMINISTER);
            try {
                Request request = new Request.Builder().url(nomadUrl + "/v1/agent/self").build();
                OkHttpClient client = new OkHttpClient();
                ResponseBody response = client.newCall(request).execute().body();
                if (response != null) {
                    response.close();
                }
                return FormValidation.ok((String)"Nomad API request succeeded.");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @POST
        public FormValidation doCheckName(@QueryParameter String name) {
            Objects.requireNonNull(Jenkins.get()).checkPermission(Jenkins.ADMINISTER);
            if (Strings.isNullOrEmpty((String)name)) {
                return FormValidation.error((String)"Name must be set");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillNomadACLCredentialsIdItems(@QueryParameter(value="nomadACLCredentialsId") String credentialsId) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }
    }
}

