/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jenkinsci.plugins.nomad.NomadApi;
import org.jenkinsci.plugins.nomad.NomadComputer;
import org.jenkinsci.plugins.nomad.NomadRetentionStrategy;
import org.jenkinsci.plugins.nomad.NomadSlave;
import org.jenkinsci.plugins.nomad.NomadSlaveTemplate;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NomadCloud
extends AbstractCloudImpl {
    private static final Logger LOGGER = Logger.getLogger(NomadCloud.class.getName());
    private final List<? extends NomadSlaveTemplate> templates;
    private final String name;
    private final String nomadUrl;
    private String jenkinsUrl;
    private String slaveUrl;
    private NomadApi nomad;
    private int pending = 0;

    @DataBoundConstructor
    public NomadCloud(String name, String nomadUrl, String jenkinsUrl, String slaveUrl, List<? extends NomadSlaveTemplate> templates) {
        super(name, null);
        this.name = name;
        this.nomadUrl = nomadUrl;
        this.jenkinsUrl = jenkinsUrl;
        this.slaveUrl = slaveUrl;
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.readResolve();
    }

    protected Object readResolve() {
        for (NomadSlaveTemplate nomadSlaveTemplate : this.templates) {
            nomadSlaveTemplate.setCloud(this);
        }
        this.nomad = new NomadApi(this.nomadUrl);
        if (this.jenkinsUrl.equals("")) {
            this.jenkinsUrl = Jenkins.getInstance().getRootUrl();
        }
        if (this.slaveUrl.equals("")) {
            this.slaveUrl = this.jenkinsUrl + "jnlpJars/slave.jar";
        }
        return this;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        ArrayList<NodeProvisioner.PlannedNode> nodes = new ArrayList<NodeProvisioner.PlannedNode>();
        NomadSlaveTemplate template = this.getTemplate(label);
        if (template != null) {
            try {
                while (excessWorkload > 0) {
                    LOGGER.log(Level.INFO, "Excess workload of " + excessWorkload + ", provisioning new Jenkins slave on Nomad cluster");
                    String slaveName = template.createSlaveName();
                    nodes.add(new NodeProvisioner.PlannedNode(slaveName, NomadComputer.threadPoolForRemoting.submit(new ProvisioningCallback(slaveName, template, this)), template.getNumExecutors()));
                    excessWorkload -= template.getNumExecutors();
                    this.pending += template.getNumExecutors();
                }
                return nodes;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to schedule new Jenkins slave on Nomad cluster, message: " + e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    public NomadSlaveTemplate getTemplate(Label label) {
        for (NomadSlaveTemplate nomadSlaveTemplate : this.templates) {
            if (label == null && !nomadSlaveTemplate.getLabelSet().isEmpty() || (label != null || !nomadSlaveTemplate.getLabelSet().isEmpty()) && (label == null || !label.matches(nomadSlaveTemplate.getLabelSet()))) continue;
            return nomadSlaveTemplate;
        }
        return null;
    }

    public boolean canProvision(Label label) {
        return Optional.fromNullable((Object)this.getTemplate(label)).isPresent();
    }

    public String getName() {
        return this.name;
    }

    public String getNomadUrl() {
        return this.nomadUrl;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public String getSlaveUrl() {
        return this.slaveUrl;
    }

    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    public void setSlaveUrl(String slaveUrl) {
        this.slaveUrl = slaveUrl;
    }

    public void setNomad(NomadApi nomad) {
        this.nomad = nomad;
    }

    public int getPending() {
        return this.pending;
    }

    public List<NomadSlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public NomadApi Nomad() {
        return this.nomad;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Nomad";
        }

        public FormValidation doTestConnection(@QueryParameter(value="nomadUrl") String nomadUrl) {
            try {
                Request request = new Request.Builder().url(nomadUrl + "/v1/agent/self").build();
                OkHttpClient client = new OkHttpClient();
                client.newCall(request).execute().body().close();
                return FormValidation.ok((String)"Nomad API request succeeded.");
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                return FormValidation.error((String)"Name must be set");
            }
            return FormValidation.ok();
        }
    }

    private class ProvisioningCallback
    implements Callable<Node> {
        String slaveName;
        NomadSlaveTemplate template;
        NomadCloud cloud;

        public ProvisioningCallback(String slaveName, NomadSlaveTemplate template, NomadCloud cloud) {
            this.slaveName = slaveName;
            this.template = template;
            this.cloud = cloud;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node call() throws Exception {
            final NomadSlave slave = new NomadSlave(this.cloud, this.slaveName, "Nomad Jenkins Slave", this.template, this.template.getLabels(), (RetentionStrategy)new NomadRetentionStrategy(this.template.getIdleTerminationInMinutes()), Collections.emptyList());
            Jenkins.getInstance().addNode((Node)slave);
            String jnlpSecret = "";
            if (Jenkins.getInstance().isUseSecurity()) {
                jnlpSecret = JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(this.slaveName);
            }
            LOGGER.log(Level.INFO, "Asking Nomad to schedule new Jenkins slave");
            NomadCloud.this.nomad.startSlave(this.slaveName, jnlpSecret, this.template);
            Callable<Boolean> callableTask = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        LOGGER.log(Level.INFO, "Slave scheduled, waiting for connection");
                        slave.toComputer().waitUntilOnline();
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.SEVERE, "Waiting for connection was interrupted");
                        return false;
                    }
                    return true;
                }
            };
            ExecutorService executorService = Executors.newCachedThreadPool();
            Future<Boolean> future = executorService.submit(callableTask);
            try {
                future.get(1L, TimeUnit.MINUTES);
                LOGGER.log(Level.INFO, "Connection established");
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Slave computer did not come online within one minutes, terminating slave");
                slave.terminate();
            }
            finally {
                future.cancel(true);
                executorService.shutdown();
            }
            NomadCloud.this.pending = NomadCloud.this.pending - this.template.getNumExecutors();
            return slave;
        }
    }
}

