// CHECKSTYLE:OFF

package org.jvnet.jenkins.plugins.nodelabelparameter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Build on every online node
     * 
     */
    public static String AllNodesBuildParameterFactory_displayName() {
        return holder.format("AllNodesBuildParameterFactory.displayName");
    }

    /**
     * Build on every online node
     * 
     */
    public static Localizable _AllNodesBuildParameterFactory_displayName() {
        return new Localizable(holder, "AllNodesBuildParameterFactory.displayName");
    }

    /**
     * Run with label [{0}]
     * 
     */
    public static String LabelBadgeAction_label_tooltip(Object arg1) {
        return holder.format("LabelBadgeAction.label_tooltip", arg1);
    }

    /**
     * Run with label [{0}]
     * 
     */
    public static Localizable _LabelBadgeAction_label_tooltip(Object arg1) {
        return new Localizable(holder, "LabelBadgeAction.label_tooltip", arg1);
    }

    /**
     * The label expression "{0}" does not match any node
     * 
     */
    public static String NodeLabelParameterDefinition_noNodeMatched(Object arg1) {
        return holder.format("NodeLabelParameterDefinition.noNodeMatched", arg1);
    }

    /**
     * The label expression "{0}" does not match any node
     * 
     */
    public static Localizable _NodeLabelParameterDefinition_noNodeMatched(Object arg1) {
        return new Localizable(holder, "NodeLabelParameterDefinition.noNodeMatched", arg1);
    }

    /**
     * The label expression "{0}" is not valid : {1}
     * 
     */
    public static String NodeLabelParameterDefinition_labelExpressionNotValid(Object arg1, Object arg2) {
        return holder.format("NodeLabelParameterDefinition.labelExpressionNotValid", arg1, arg2);
    }

    /**
     * The label expression "{0}" is not valid : {1}
     * 
     */
    public static Localizable _NodeLabelParameterDefinition_labelExpressionNotValid(Object arg1, Object arg2) {
        return new Localizable(holder, "NodeLabelParameterDefinition.labelExpressionNotValid", arg1, arg2);
    }

    /**
     * Ignore Offline Nodes
     * 
     */
    public static String NodeEligibility_ignoreOffline() {
        return holder.format("NodeEligibility.ignoreOffline");
    }

    /**
     * Ignore Offline Nodes
     * 
     */
    public static Localizable _NodeEligibility_ignoreOffline() {
        return new Localizable(holder, "NodeEligibility.ignoreOffline");
    }

    /**
     * Run with label [{0}] (node: {1})
     * 
     */
    public static String LabelBadgeAction_label_tooltip_node(Object arg1, Object arg2) {
        return holder.format("LabelBadgeAction.label_tooltip_node", arg1, arg2);
    }

    /**
     * Run with label [{0}] (node: {1})
     * 
     */
    public static Localizable _LabelBadgeAction_label_tooltip_node(Object arg1, Object arg2) {
        return new Localizable(holder, "LabelBadgeAction.label_tooltip_node", arg1, arg2);
    }

    /**
     * No online node for label [{0}] found, triggering with original label... 
     * 
     */
    public static String NodeListBuildParameterFactory_noOnlineNodeFound(Object arg1) {
        return holder.format("NodeListBuildParameterFactory.noOnlineNodeFound", arg1);
    }

    /**
     * No online node for label [{0}] found, triggering with original label... 
     * 
     */
    public static Localizable _NodeListBuildParameterFactory_noOnlineNodeFound(Object arg1) {
        return new Localizable(holder, "NodeListBuildParameterFactory.noOnlineNodeFound", arg1);
    }

    /**
     * Node-List Factory
     * 
     */
    public static String NodeListBuildParameterFactory_displayName() {
        return holder.format("NodeListBuildParameterFactory.displayName");
    }

    /**
     * Node-List Factory
     * 
     */
    public static Localizable _NodeListBuildParameterFactory_displayName() {
        return new Localizable(holder, "NodeListBuildParameterFactory.displayName");
    }

    /**
     * Run on node: {0}
     * 
     */
    public static String LabelBadgeAction_node_tooltip(Object arg1) {
        return holder.format("LabelBadgeAction.node_tooltip", arg1);
    }

    /**
     * Run on node: {0}
     * 
     */
    public static Localizable _LabelBadgeAction_node_tooltip(Object arg1) {
        return new Localizable(holder, "LabelBadgeAction.node_tooltip", arg1);
    }

    /**
     * The project is configured to run builds concurrent, but the node parameter [{0}] is configured to trigger new builds depending on the state of the last build only!
     * 
     */
    public static String BuildWrapper_param_not_concurrent(Object arg1) {
        return holder.format("BuildWrapper.param_not_concurrent", arg1);
    }

    /**
     * The project is configured to run builds concurrent, but the node parameter [{0}] is configured to trigger new builds depending on the state of the last build only!
     * 
     */
    public static Localizable _BuildWrapper_param_not_concurrent(Object arg1) {
        return new Localizable(holder, "BuildWrapper.param_not_concurrent", arg1);
    }

    /**
     * Trigger builds on selected nodes
     * 
     */
    public static String NextNodeBuildNotifier_displayName() {
        return holder.format("NextNodeBuildNotifier.displayName");
    }

    /**
     * Trigger builds on selected nodes
     * 
     */
    public static Localizable _NextNodeBuildNotifier_displayName() {
        return new Localizable(holder, "NextNodeBuildNotifier.displayName");
    }

    /**
     * All Nodes for Label Factory
     * 
     */
    public static String AllNodesForLabelBuildParameterFactory_displayName() {
        return holder.format("AllNodesForLabelBuildParameterFactory.displayName");
    }

    /**
     * All Nodes for Label Factory
     * 
     */
    public static Localizable _AllNodesForLabelBuildParameterFactory_displayName() {
        return new Localizable(holder, "AllNodesForLabelBuildParameterFactory.displayName");
    }

    /**
     * Please define a node where the job should be triggered on
     * 
     */
    public static String NodeListBuildParameterFactory_nodeNotDefined() {
        return holder.format("NodeListBuildParameterFactory.nodeNotDefined");
    }

    /**
     * Please define a node where the job should be triggered on
     * 
     */
    public static Localizable _NodeListBuildParameterFactory_nodeNotDefined() {
        return new Localizable(holder, "NodeListBuildParameterFactory.nodeNotDefined");
    }

    /**
     * All Nodes
     * 
     */
    public static String NodeEligibility_allNodes() {
        return holder.format("NodeEligibility.allNodes");
    }

    /**
     * All Nodes
     * 
     */
    public static Localizable _NodeEligibility_allNodes() {
        return new Localizable(holder, "NodeEligibility.allNodes");
    }

    /**
     * A build with label/node [{0}] was requested
     * 
     */
    public static String NextLabelCause_description(Object arg1) {
        return holder.format("NextLabelCause.description", arg1);
    }

    /**
     * A build with label/node [{0}] was requested
     * 
     */
    public static Localizable _NextLabelCause_description(Object arg1) {
        return new Localizable(holder, "NextLabelCause.description", arg1);
    }

    /**
     * NodeLabel plugin info
     * 
     */
    public static String NodeLabelNodeProperty_displayName() {
        return holder.format("NodeLabelNodeProperty.displayName");
    }

    /**
     * NodeLabel plugin info
     * 
     */
    public static Localizable _NodeLabelNodeProperty_displayName() {
        return new Localizable(holder, "NodeLabelNodeProperty.displayName");
    }

    /**
     * Skipping execution on offline node [{0}]
     * 
     */
    public static String NodeListBuildParameterFactory_skippOfflineNode(Object arg1) {
        return holder.format("NodeListBuildParameterFactory.skippOfflineNode", arg1);
    }

    /**
     * Skipping execution on offline node [{0}]
     * 
     */
    public static Localizable _NodeListBuildParameterFactory_skippOfflineNode(Object arg1) {
        return new Localizable(holder, "NodeListBuildParameterFactory.skippOfflineNode", arg1);
    }

    /**
     * Ignore Temp Offline Nodes
     * 
     */
    public static String NodeEligibility_ignoreTmpOffline() {
        return holder.format("NodeEligibility.ignoreTmpOffline");
    }

    /**
     * Ignore Temp Offline Nodes
     * 
     */
    public static Localizable _NodeEligibility_ignoreTmpOffline() {
        return new Localizable(holder, "NodeEligibility.ignoreTmpOffline");
    }

    /**
     * The project is configured to NOT run builds concurrent, but the node parameter [{0}] is configured to trigger new builds concurrent!
     * 
     */
    public static String BuildWrapper_project_not_concurrent(Object arg1) {
        return holder.format("BuildWrapper.project_not_concurrent", arg1);
    }

    /**
     * The project is configured to NOT run builds concurrent, but the node parameter [{0}] is configured to trigger new builds concurrent!
     * 
     */
    public static Localizable _BuildWrapper_project_not_concurrent(Object arg1) {
        return new Localizable(holder, "BuildWrapper.project_not_concurrent", arg1);
    }

    /**
     * a label is required
     * 
     */
    public static String LabelParameterDefinition_labelRequired() {
        return holder.format("LabelParameterDefinition.labelRequired");
    }

    /**
     * a label is required
     * 
     */
    public static Localizable _LabelParameterDefinition_labelRequired() {
        return new Localizable(holder, "LabelParameterDefinition.labelRequired");
    }

    /**
     * Job triggered without a valid online node, given where: {0}
     * 
     */
    public static String LabelParameterValue_triggerWithoutValidOnlineNode(Object arg1) {
        return holder.format("LabelParameterValue.triggerWithoutValidOnlineNode", arg1);
    }

    /**
     * Job triggered without a valid online node, given where: {0}
     * 
     */
    public static Localizable _LabelParameterValue_triggerWithoutValidOnlineNode(Object arg1) {
        return new Localizable(holder, "LabelParameterValue.triggerWithoutValidOnlineNode", arg1);
    }

    /**
     * Matching nodes:
     * 
     */
    public static String LabelParameterDefinition_matchingNodes() {
        return holder.format("LabelParameterDefinition.matchingNodes");
    }

    /**
     * Matching nodes:
     * 
     */
    public static Localizable _LabelParameterDefinition_matchingNodes() {
        return new Localizable(holder, "LabelParameterDefinition.matchingNodes");
    }

    /**
     * A node with the name {0} could not be found.
     * 
     */
    public static String NodeListBuildParameterFactory_nodeNotFound(Object arg1) {
        return holder.format("NodeListBuildParameterFactory.nodeNotFound", arg1);
    }

    /**
     * A node with the name {0} could not be found.
     * 
     */
    public static Localizable _NodeListBuildParameterFactory_nodeNotFound(Object arg1) {
        return new Localizable(holder, "NodeListBuildParameterFactory.nodeNotFound", arg1);
    }

}
