/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLabelBuildParameter
extends AbstractBuildParameters {
    public final String name;
    public final String nodeLabel;

    @DataBoundConstructor
    public NodeLabelBuildParameter(String name, String nodeLabel) {
        this.name = name;
        this.nodeLabel = nodeLabel;
    }

    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String labelExpanded = this.nodeLabel;
        try {
            labelExpanded = TokenMacro.expandAll(build, (TaskListener)listener, (String)labelExpanded);
        }
        catch (MacroEvaluationException e) {
            labelExpanded = this.nodeLabel;
            e.printStackTrace(listener.getLogger());
        }
        LabelParameterValue parameterValue = new LabelParameterValue(this.name, labelExpanded);
        listener.getLogger().println("define: " + (Object)((Object)parameterValue));
        return new ParametersAction(new ParameterValue[]{parameterValue});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "NodeLabel parameter";
        }
    }
}

