/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.Extension;
import hudson.model.ComputerSet;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterValue;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeParameterDefinition
extends SimpleParameterDefinition {
    private static final long serialVersionUID = 1L;
    public static final String ALL_NODES = "ALL (no restriction)";
    public final List<String> allowedSlaves;
    private List<String> defaultSlaves;
    @Deprecated
    public transient String defaultValue;
    private String triggerIfResult;
    private boolean allowMultiNodeSelection;
    private boolean triggerConcurrentBuilds;
    private boolean ignoreOfflineNodes;

    @DataBoundConstructor
    public NodeParameterDefinition(String name, String description, List<String> defaultSlaves, List<String> allowedSlaves, String triggerIfResult, boolean ignoreOfflineNodes) {
        super(name, description);
        this.allowedSlaves = allowedSlaves;
        this.defaultSlaves = defaultSlaves;
        if ("multiSelectionDisallowed".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = false;
            this.triggerConcurrentBuilds = false;
        } else if ("allowMultiSelectionForConcurrentBuilds".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = true;
        } else {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = false;
        }
        this.triggerIfResult = triggerIfResult;
        this.ignoreOfflineNodes = ignoreOfflineNodes;
    }

    @Deprecated
    public NodeParameterDefinition(String name, String description, String defaultValue, List<String> allowedSlaves, String triggerIfResult) {
        super(name, description);
        this.allowedSlaves = allowedSlaves;
        if (this.allowedSlaves != null && this.allowedSlaves.contains(defaultValue)) {
            this.allowedSlaves.remove(defaultValue);
            this.allowedSlaves.add(0, defaultValue);
        }
        if ("multiSelectionDisallowed".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = false;
            this.triggerConcurrentBuilds = false;
        } else if ("allowMultiSelectionForConcurrentBuilds".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = true;
        } else {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = false;
        }
        this.triggerIfResult = triggerIfResult;
        this.ignoreOfflineNodes = false;
    }

    public List<String> getDefaultSlaves() {
        return this.defaultSlaves;
    }

    public boolean isIgnoreOfflineNodes() {
        return this.ignoreOfflineNodes;
    }

    public NodeParameterValue getDefaultParameterValue() {
        return new NodeParameterValue(this.getName(), this.getDefaultSlaves(), this.isIgnoreOfflineNodes());
    }

    public ParameterValue createValue(String value) {
        return new NodeParameterValue(this.getName(), this.getDescription(), value);
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        return this;
    }

    public List<String> getAllowedNodesOrAll() {
        List<String> slaves = this.allowedSlaves == null || this.allowedSlaves.isEmpty() || this.allowedSlaves.contains(ALL_NODES) ? NodeParameterDefinition.getSlaveNames() : this.allowedSlaves;
        Collections.sort(slaves, NodeNameComparator.INSTANCE);
        return slaves;
    }

    public String getTriggerIfResult() {
        return this.triggerIfResult;
    }

    public static List<String> getSlaveNamesForSelection() {
        List<String> slaveNames = NodeParameterDefinition.getSlaveNames();
        Collections.sort(slaveNames, NodeNameComparator.INSTANCE);
        slaveNames.add(0, ALL_NODES);
        return slaveNames;
    }

    public static List<String> getSlaveNames() {
        ComputerSet computers = Hudson.getInstance().getComputer();
        List slaveNames = computers.get_slaveNames();
        ArrayList<String> test = new ArrayList<String>();
        test.addAll(slaveNames);
        if (!test.contains("master")) {
            test.add(0, "master");
        }
        return test;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        String name = jo.getString("name");
        Object joValue = jo.get("value") == null ? jo.get("labels") : jo.get("value");
        ArrayList<String> nodes = new ArrayList<String>();
        if (joValue instanceof String) {
            nodes.add((String)joValue);
        } else if (joValue instanceof JSONArray) {
            JSONArray ja = (JSONArray)joValue;
            for (Object strObj : ja) {
                nodes.add((String)strObj);
            }
        }
        NodeParameterValue value = new NodeParameterValue(name, nodes, this.isIgnoreOfflineNodes());
        value.setDescription(this.getDescription());
        return value;
    }

    public boolean getAllowMultiNodeSelection() {
        return this.allowMultiNodeSelection;
    }

    public boolean isTriggerConcurrentBuilds() {
        return this.triggerConcurrentBuilds;
    }

    public Object readResolve() {
        if (this.defaultValue != null) {
            if (this.defaultSlaves == null) {
                this.defaultSlaves = new ArrayList<String>();
            }
            this.defaultSlaves.add(this.defaultValue);
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Node";
        }

        public String getHelpFile() {
            return "/plugin/nodelabelparameter/nodeparam.html";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NodeNameComparator
    implements Comparator<String> {
        public static final NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if ("master".endsWith(o1)) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

