// CHECKSTYLE:OFF

package org.jvnet.jenkins.plugins.nodelabelparameter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code NodeEligibility.ignoreTmpOffline}: {@code Ignore Temp
     * Offline Nodes}.
     * 
     * @return
     *     {@code Ignore Temp Offline Nodes}
     */
    public static String NodeEligibility_ignoreTmpOffline() {
        return holder.format("NodeEligibility.ignoreTmpOffline");
    }

    /**
     * Key {@code NodeEligibility.ignoreTmpOffline}: {@code Ignore Temp
     * Offline Nodes}.
     * 
     * @return
     *     {@code Ignore Temp Offline Nodes}
     */
    public static Localizable _NodeEligibility_ignoreTmpOffline() {
        return new Localizable(holder, "NodeEligibility.ignoreTmpOffline");
    }

    /**
     * Key {@code LabelBadgeAction.label_tooltip_node}: {@code Run with label
     * [{0}] (node: {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run with label [{0}] (node: {1})}
     */
    public static String LabelBadgeAction_label_tooltip_node(Object arg0, Object arg1) {
        return holder.format("LabelBadgeAction.label_tooltip_node", arg0, arg1);
    }

    /**
     * Key {@code LabelBadgeAction.label_tooltip_node}: {@code Run with label
     * [{0}] (node: {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run with label [{0}] (node: {1})}
     */
    public static Localizable _LabelBadgeAction_label_tooltip_node(Object arg0, Object arg1) {
        return new Localizable(holder, "LabelBadgeAction.label_tooltip_node", arg0, arg1);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.nodeNotDefined}: {@code
     * Please define a node where the job should be triggered on}.
     * 
     * @return
     *     {@code Please define a node where the job should be triggered on}
     */
    public static String NodeListBuildParameterFactory_nodeNotDefined() {
        return holder.format("NodeListBuildParameterFactory.nodeNotDefined");
    }

    /**
     * Key {@code NodeListBuildParameterFactory.nodeNotDefined}: {@code
     * Please define a node where the job should be triggered on}.
     * 
     * @return
     *     {@code Please define a node where the job should be triggered on}
     */
    public static Localizable _NodeListBuildParameterFactory_nodeNotDefined() {
        return new Localizable(holder, "NodeListBuildParameterFactory.nodeNotDefined");
    }

    /**
     * Key {@code LabelParameterDefinition.matchingNodes}: {@code Matching
     * nodes:}.
     * 
     * @return
     *     {@code Matching nodes:}
     */
    public static String LabelParameterDefinition_matchingNodes() {
        return holder.format("LabelParameterDefinition.matchingNodes");
    }

    /**
     * Key {@code LabelParameterDefinition.matchingNodes}: {@code Matching
     * nodes:}.
     * 
     * @return
     *     {@code Matching nodes:}
     */
    public static Localizable _LabelParameterDefinition_matchingNodes() {
        return new Localizable(holder, "LabelParameterDefinition.matchingNodes");
    }

    /**
     * Key {@code NextLabelCause.description}: {@code A build with label/node
     * [{0}] was requested}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A build with label/node [{0}] was requested}
     */
    public static String NextLabelCause_description(Object arg0) {
        return holder.format("NextLabelCause.description", arg0);
    }

    /**
     * Key {@code NextLabelCause.description}: {@code A build with label/node
     * [{0}] was requested}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A build with label/node [{0}] was requested}
     */
    public static Localizable _NextLabelCause_description(Object arg0) {
        return new Localizable(holder, "NextLabelCause.description", arg0);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.noOnlineNodeFound}: {@code No
     * online node for label [{0}] found, triggering with original label...
     * }.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No online node for label [{0}] found, triggering with original
     *     label... }
     */
    public static String NodeListBuildParameterFactory_noOnlineNodeFound(Object arg0) {
        return holder.format("NodeListBuildParameterFactory.noOnlineNodeFound", arg0);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.noOnlineNodeFound}: {@code No
     * online node for label [{0}] found, triggering with original label...
     * }.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No online node for label [{0}] found, triggering with original
     *     label... }
     */
    public static Localizable _NodeListBuildParameterFactory_noOnlineNodeFound(Object arg0) {
        return new Localizable(holder, "NodeListBuildParameterFactory.noOnlineNodeFound", arg0);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.displayName}: {@code
     * Node-List Factory}.
     * 
     * @return
     *     {@code Node-List Factory}
     */
    public static String NodeListBuildParameterFactory_displayName() {
        return holder.format("NodeListBuildParameterFactory.displayName");
    }

    /**
     * Key {@code NodeListBuildParameterFactory.displayName}: {@code
     * Node-List Factory}.
     * 
     * @return
     *     {@code Node-List Factory}
     */
    public static Localizable _NodeListBuildParameterFactory_displayName() {
        return new Localizable(holder, "NodeListBuildParameterFactory.displayName");
    }

    /**
     * Key {@code LabelBadgeAction.node_tooltip}: {@code Run on node: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run on node: {0}}
     */
    public static String LabelBadgeAction_node_tooltip(Object arg0) {
        return holder.format("LabelBadgeAction.node_tooltip", arg0);
    }

    /**
     * Key {@code LabelBadgeAction.node_tooltip}: {@code Run on node: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run on node: {0}}
     */
    public static Localizable _LabelBadgeAction_node_tooltip(Object arg0) {
        return new Localizable(holder, "LabelBadgeAction.node_tooltip", arg0);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.nodeNotFound}: {@code A node
     * with the name {0} could not be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A node with the name {0} could not be found.}
     */
    public static String NodeListBuildParameterFactory_nodeNotFound(Object arg0) {
        return holder.format("NodeListBuildParameterFactory.nodeNotFound", arg0);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.nodeNotFound}: {@code A node
     * with the name {0} could not be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A node with the name {0} could not be found.}
     */
    public static Localizable _NodeListBuildParameterFactory_nodeNotFound(Object arg0) {
        return new Localizable(holder, "NodeListBuildParameterFactory.nodeNotFound", arg0);
    }

    /**
     * Key {@code NodeLabelNodeProperty.displayName}: {@code NodeLabel plugin
     * info}.
     * 
     * @return
     *     {@code NodeLabel plugin info}
     */
    public static String NodeLabelNodeProperty_displayName() {
        return holder.format("NodeLabelNodeProperty.displayName");
    }

    /**
     * Key {@code NodeLabelNodeProperty.displayName}: {@code NodeLabel plugin
     * info}.
     * 
     * @return
     *     {@code NodeLabel plugin info}
     */
    public static Localizable _NodeLabelNodeProperty_displayName() {
        return new Localizable(holder, "NodeLabelNodeProperty.displayName");
    }

    /**
     * Key {@code LabelBadgeAction.label_tooltip}: {@code Run with label
     * [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run with label [{0}]}
     */
    public static String LabelBadgeAction_label_tooltip(Object arg0) {
        return holder.format("LabelBadgeAction.label_tooltip", arg0);
    }

    /**
     * Key {@code LabelBadgeAction.label_tooltip}: {@code Run with label
     * [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Run with label [{0}]}
     */
    public static Localizable _LabelBadgeAction_label_tooltip(Object arg0) {
        return new Localizable(holder, "LabelBadgeAction.label_tooltip", arg0);
    }

    /**
     * Key {@code NextNodeBuildNotifier.displayName}: {@code Trigger builds
     * on selected nodes}.
     * 
     * @return
     *     {@code Trigger builds on selected nodes}
     */
    public static String NextNodeBuildNotifier_displayName() {
        return holder.format("NextNodeBuildNotifier.displayName");
    }

    /**
     * Key {@code NextNodeBuildNotifier.displayName}: {@code Trigger builds
     * on selected nodes}.
     * 
     * @return
     *     {@code Trigger builds on selected nodes}
     */
    public static Localizable _NextNodeBuildNotifier_displayName() {
        return new Localizable(holder, "NextNodeBuildNotifier.displayName");
    }

    /**
     * Key {@code NodeLabelParameterDefinition.noNodeMatched}: {@code The
     * label expression "{0}" does not match any node}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The label expression "{0}" does not match any node}
     */
    public static String NodeLabelParameterDefinition_noNodeMatched(Object arg0) {
        return holder.format("NodeLabelParameterDefinition.noNodeMatched", arg0);
    }

    /**
     * Key {@code NodeLabelParameterDefinition.noNodeMatched}: {@code The
     * label expression "{0}" does not match any node}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The label expression "{0}" does not match any node}
     */
    public static Localizable _NodeLabelParameterDefinition_noNodeMatched(Object arg0) {
        return new Localizable(holder, "NodeLabelParameterDefinition.noNodeMatched", arg0);
    }

    /**
     * Key {@code BuildWrapper.param_not_concurrent}: {@code The project is
     * configured to run builds concurrent, but the node parameter [{0}] is
     * configured to trigger new builds depending on the state of the last
     * build only!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The project is configured to run builds concurrent, but the
     *     node parameter [{0}] is configured to trigger new builds depending on
     *     the state of the last build only!}
     */
    public static String BuildWrapper_param_not_concurrent(Object arg0) {
        return holder.format("BuildWrapper.param_not_concurrent", arg0);
    }

    /**
     * Key {@code BuildWrapper.param_not_concurrent}: {@code The project is
     * configured to run builds concurrent, but the node parameter [{0}] is
     * configured to trigger new builds depending on the state of the last
     * build only!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The project is configured to run builds concurrent, but the
     *     node parameter [{0}] is configured to trigger new builds depending on
     *     the state of the last build only!}
     */
    public static Localizable _BuildWrapper_param_not_concurrent(Object arg0) {
        return new Localizable(holder, "BuildWrapper.param_not_concurrent", arg0);
    }

    /**
     * Key {@code NodeLabelParameterDefinition.labelExpressionNotValid}:
     * {@code The label expression "{0}" is not valid : {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The label expression "{0}" is not valid : {1}}
     */
    public static String NodeLabelParameterDefinition_labelExpressionNotValid(Object arg0, Object arg1) {
        return holder.format("NodeLabelParameterDefinition.labelExpressionNotValid", arg0, arg1);
    }

    /**
     * Key {@code NodeLabelParameterDefinition.labelExpressionNotValid}:
     * {@code The label expression "{0}" is not valid : {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The label expression "{0}" is not valid : {1}}
     */
    public static Localizable _NodeLabelParameterDefinition_labelExpressionNotValid(Object arg0, Object arg1) {
        return new Localizable(holder, "NodeLabelParameterDefinition.labelExpressionNotValid", arg0, arg1);
    }

    /**
     * Key {@code LabelParameterValue.triggerWithoutValidOnlineNode}: {@code
     * Job triggered without a valid online node, given where: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Job triggered without a valid online node, given where: {0}}
     */
    public static String LabelParameterValue_triggerWithoutValidOnlineNode(Object arg0) {
        return holder.format("LabelParameterValue.triggerWithoutValidOnlineNode", arg0);
    }

    /**
     * Key {@code LabelParameterValue.triggerWithoutValidOnlineNode}: {@code
     * Job triggered without a valid online node, given where: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Job triggered without a valid online node, given where: {0}}
     */
    public static Localizable _LabelParameterValue_triggerWithoutValidOnlineNode(Object arg0) {
        return new Localizable(holder, "LabelParameterValue.triggerWithoutValidOnlineNode", arg0);
    }

    /**
     * Key {@code NodeEligibility.ignoreOffline}: {@code Ignore Offline
     * Nodes}.
     * 
     * @return
     *     {@code Ignore Offline Nodes}
     */
    public static String NodeEligibility_ignoreOffline() {
        return holder.format("NodeEligibility.ignoreOffline");
    }

    /**
     * Key {@code NodeEligibility.ignoreOffline}: {@code Ignore Offline
     * Nodes}.
     * 
     * @return
     *     {@code Ignore Offline Nodes}
     */
    public static Localizable _NodeEligibility_ignoreOffline() {
        return new Localizable(holder, "NodeEligibility.ignoreOffline");
    }

    /**
     * Key {@code AllNodesForLabelBuildParameterFactory.displayName}: {@code
     * All Nodes for Label Factory}.
     * 
     * @return
     *     {@code All Nodes for Label Factory}
     */
    public static String AllNodesForLabelBuildParameterFactory_displayName() {
        return holder.format("AllNodesForLabelBuildParameterFactory.displayName");
    }

    /**
     * Key {@code AllNodesForLabelBuildParameterFactory.displayName}: {@code
     * All Nodes for Label Factory}.
     * 
     * @return
     *     {@code All Nodes for Label Factory}
     */
    public static Localizable _AllNodesForLabelBuildParameterFactory_displayName() {
        return new Localizable(holder, "AllNodesForLabelBuildParameterFactory.displayName");
    }

    /**
     * Key {@code BuildWrapper.project_not_concurrent}: {@code The project is
     * configured to NOT run builds concurrent, but the node parameter [{0}]
     * is configured to trigger new builds concurrent!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The project is configured to NOT run builds concurrent, but the
     *     node parameter [{0}] is configured to trigger new builds concurrent!}
     */
    public static String BuildWrapper_project_not_concurrent(Object arg0) {
        return holder.format("BuildWrapper.project_not_concurrent", arg0);
    }

    /**
     * Key {@code BuildWrapper.project_not_concurrent}: {@code The project is
     * configured to NOT run builds concurrent, but the node parameter [{0}]
     * is configured to trigger new builds concurrent!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The project is configured to NOT run builds concurrent, but the
     *     node parameter [{0}] is configured to trigger new builds concurrent!}
     */
    public static Localizable _BuildWrapper_project_not_concurrent(Object arg0) {
        return new Localizable(holder, "BuildWrapper.project_not_concurrent", arg0);
    }

    /**
     * Key {@code LabelParameterDefinition.labelRequired}: {@code a label is
     * required}.
     * 
     * @return
     *     {@code a label is required}
     */
    public static String LabelParameterDefinition_labelRequired() {
        return holder.format("LabelParameterDefinition.labelRequired");
    }

    /**
     * Key {@code LabelParameterDefinition.labelRequired}: {@code a label is
     * required}.
     * 
     * @return
     *     {@code a label is required}
     */
    public static Localizable _LabelParameterDefinition_labelRequired() {
        return new Localizable(holder, "LabelParameterDefinition.labelRequired");
    }

    /**
     * Key {@code NodeListBuildParameterFactory.skippOfflineNode}: {@code
     * Skipping execution on offline node [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Skipping execution on offline node [{0}]}
     */
    public static String NodeListBuildParameterFactory_skippOfflineNode(Object arg0) {
        return holder.format("NodeListBuildParameterFactory.skippOfflineNode", arg0);
    }

    /**
     * Key {@code NodeListBuildParameterFactory.skippOfflineNode}: {@code
     * Skipping execution on offline node [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Skipping execution on offline node [{0}]}
     */
    public static Localizable _NodeListBuildParameterFactory_skippOfflineNode(Object arg0) {
        return new Localizable(holder, "NodeListBuildParameterFactory.skippOfflineNode", arg0);
    }

    /**
     * Key {@code AllNodesBuildParameterFactory.displayName}: {@code Build on
     * every online node}.
     * 
     * @return
     *     {@code Build on every online node}
     */
    public static String AllNodesBuildParameterFactory_displayName() {
        return holder.format("AllNodesBuildParameterFactory.displayName");
    }

    /**
     * Key {@code AllNodesBuildParameterFactory.displayName}: {@code Build on
     * every online node}.
     * 
     * @return
     *     {@code Build on every online node}
     */
    public static Localizable _AllNodesBuildParameterFactory_displayName() {
        return new Localizable(holder, "AllNodesBuildParameterFactory.displayName");
    }

    /**
     * Key {@code NodeEligibility.allNodes}: {@code All Nodes}.
     * 
     * @return
     *     {@code All Nodes}
     */
    public static String NodeEligibility_allNodes() {
        return holder.format("NodeEligibility.allNodes");
    }

    /**
     * Key {@code NodeEligibility.allNodes}: {@code All Nodes}.
     * 
     * @return
     *     {@code All Nodes}
     */
    public static Localizable _NodeEligibility_allNodes() {
        return new Localizable(holder, "NodeEligibility.allNodes");
    }

}
