/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import net.sf.json.JSONObject;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class LabelParameterDefinition
extends SimpleParameterDefinition {
    public final String defaultValue;

    @DataBoundConstructor
    public LabelParameterDefinition(String name, String description, String defaultValue) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        if (defaultValueObj instanceof LabelParameterValue) {
            LabelParameterValue value = (LabelParameterValue)defaultValueObj;
            return new LabelParameterDefinition(this.getName(), this.getDescription(), value.label);
        }
        return this;
    }

    public LabelParameterValue getDefaultParameterValue() {
        LabelParameterValue v = new LabelParameterValue(this.getName(), this.getDescription(), this.defaultValue);
        return v;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        LabelParameterValue value = (LabelParameterValue)((Object)req.bindJSON(LabelParameterValue.class, jo));
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterValue createValue(String value) {
        return new LabelParameterValue(this.getName(), this.getDescription(), value);
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Label";
        }

        public String getHelpFile() {
            return "/plugin/nodelabelparameter/labelparam.html";
        }
    }
}

