/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.configfiles.NPMRegistry;
import jenkins.plugins.nodejs.configfiles.RegistryHelper;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NPMConfig
extends Config {
    private static final long serialVersionUID = 1L;
    private final List<NPMRegistry> registries;
    private boolean npm9Format = false;

    @DataBoundConstructor
    public NPMConfig(@NonNull String id, String name, String comment, String content, List<NPMRegistry> registries) {
        super(id, Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)comment), Util.fixEmptyAndTrim((String)content));
        this.registries = registries == null ? new ArrayList(3) : registries;
    }

    public List<NPMRegistry> getRegistries() {
        return this.registries;
    }

    public void doVerify() throws VerifyConfigProviderException {
        NPMRegistry globalRegistry = null;
        for (NPMRegistry registry : this.registries) {
            registry.doVerify();
            if (registry.isHasScopes()) continue;
            if (globalRegistry != null) {
                throw new VerifyConfigProviderException(Messages.NPMConfig_verifyTooGlobalRegistry());
            }
            globalRegistry = registry;
        }
    }

    public boolean isNpm9Format() {
        return this.npm9Format;
    }

    @DataBoundSetter
    public void setNpm9Format(boolean npm9Format) {
        this.npm9Format = npm9Format;
    }

    @Extension
    public static class NPMConfigProvider
    extends AbstractConfigProviderImpl {
        public NPMConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return null;
        }

        public String getDisplayName() {
            return Messages.NPMConfig_displayName();
        }

        public Config newConfig(@NonNull String configId) {
            return new NPMConfig(configId, "MyNpmrcConfig", "user config", this.loadTemplateContent(), null);
        }

        protected String loadTemplateContent() {
            String string;
            block8: {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("template.npmrc");
                try {
                    string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                is.close();
            }
            return string;
        }

        public String supplyContent(Config configFile, Run<?, ?> build, FilePath workDir, TaskListener listener, List<String> tempFiles) throws IOException {
            String fileContent = configFile.content;
            if (configFile instanceof NPMConfig) {
                NPMConfig config = (NPMConfig)configFile;
                List<NPMRegistry> registries = config.getRegistries();
                RegistryHelper helper = new RegistryHelper(registries);
                if (!registries.isEmpty()) {
                    listener.getLogger().println("Adding all registry entries");
                    Map<String, StandardCredentials> registry2Credentials = helper.resolveCredentials(build);
                    fileContent = helper.fillRegistry(fileContent, registry2Credentials, config.npm9Format);
                }
                try {
                    if (StringUtils.isNotBlank((String)fileContent)) {
                        config.doVerify();
                    }
                }
                catch (VerifyConfigProviderException e) {
                    throw new AbortException("Invalid user config: " + e.getMessage());
                }
            }
            return fileContent;
        }
    }
}

