/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.NodeJSDescriptorUtils;
import jenkins.plugins.nodejs.NodeJSUtils;
import jenkins.plugins.nodejs.cache.CacheLocationLocator;
import jenkins.plugins.nodejs.cache.DefaultCacheLocationLocator;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.ConfigFile;
import org.jenkinsci.lib.configprovider.model.ConfigFileManager;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class NodeJSBuildWrapper
extends SimpleBuildWrapper {
    private final String nodeJSInstallationName;
    private String configId;
    private CacheLocationLocator cacheLocationStrategy;

    @DataBoundConstructor
    public NodeJSBuildWrapper(String nodeJSInstallationName) {
        this(nodeJSInstallationName, null);
    }

    public NodeJSBuildWrapper(String nodeJSInstallationName, String configId) {
        this.nodeJSInstallationName = Util.fixEmpty((String)nodeJSInstallationName);
        this.configId = Util.fixEmpty((String)configId);
        this.cacheLocationStrategy = new DefaultCacheLocationLocator();
    }

    public NodeJSInstallation getNodeJS() {
        return NodeJSUtils.getNodeJS(this.nodeJSInstallationName);
    }

    public String getNodeJSInstallationName() {
        return this.nodeJSInstallationName;
    }

    public String getConfigId() {
        return this.configId;
    }

    @DataBoundSetter
    public void setConfigId(String configId) {
        this.configId = Util.fixEmpty((String)configId);
    }

    public CacheLocationLocator getCacheLocationStrategy() {
        return this.cacheLocationStrategy;
    }

    @DataBoundSetter
    public void setCacheLocationStrategy(CacheLocationLocator cacheLocationStrategy) {
        this.cacheLocationStrategy = cacheLocationStrategy == null ? new DefaultCacheLocationLocator() : cacheLocationStrategy;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        NodeJSInstallation ni = this.getNodeJS();
        if (ni == null) {
            throw new IOException(Messages.NodeJSBuilders_noInstallationFound(this.nodeJSInstallationName));
        }
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new AbortException(Messages.NodeJSBuilders_nodeOffline());
        }
        Node node = computer.getNode();
        if (node == null) {
            throw new AbortException(Messages.NodeJSBuilders_nodeOffline());
        }
        ni = ni.forNode(node, listener);
        String exec = (ni = ni.forEnvironment(initialEnvironment)).getExecutable(launcher);
        if (exec == null) {
            throw new AbortException(Messages.NodeJSBuilders_noExecutableFound(ni.getHome()));
        }
        ni.buildEnvVars(new EnvVarsAdapter(context));
        EnvVars env = initialEnvironment.overrideAll(context.getEnv());
        FilePath cacheLocation = this.cacheLocationStrategy.locate(workspace);
        if (cacheLocation != null) {
            context.env("npm_config_cache", cacheLocation.getRemote());
        }
        if (this.configId != null) {
            ConfigFile cf = new ConfigFile(this.configId, null, true);
            FilePath configFile = ConfigFileManager.provisionConfigFile((ConfigFile)cf, (EnvVars)env, build, (FilePath)workspace, (TaskListener)listener, new ArrayList());
            context.env("npm_config_userconfig", configFile.getRemote());
            context.setDisposer((SimpleBuildWrapper.Disposer)new TempFileCleaner(Arrays.asList(configFile.getRemote())));
        }
    }

    private Object readResolve() {
        this.setCacheLocationStrategy(this.cacheLocationStrategy);
        return this;
    }

    private static class EnvVarsAdapter
    extends EnvVars {
        private static final long serialVersionUID = 1L;
        private final transient SimpleBuildWrapper.Context context;

        public EnvVarsAdapter(@NonNull SimpleBuildWrapper.Context context) {
            this.context = context;
        }

        public String put(String key, String value) {
            this.context.env(key, value);
            return null;
        }

        public void override(String key, String value) {
            this.put(key, value);
        }
    }

    private static class TempFileCleaner
    extends SimpleBuildWrapper.Disposer {
        private static final Logger LOGGER = Logger.getLogger(TempFileCleaner.class.getName());
        private static final long serialVersionUID = 1L;
        private final List<String> tempFiles;

        TempFileCleaner(List<String> tempFiles) {
            this.tempFiles = tempFiles;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            listener.getLogger().println("Deleting " + this.tempFiles.size() + " temporary files");
            for (String tempFile : this.tempFiles) {
                LOGGER.log(Level.FINE, "Delete: {0}", new Object[]{tempFile});
                new FilePath(workspace, tempFile).delete();
            }
        }
    }

    @Symbol(value={"nodejs"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NodeJSBuildWrapper_displayName();
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSUtils.getInstallations();
        }

        public ListBoxModel doFillConfigIdItems(@AncestorInPath ItemGroup<?> context) {
            return NodeJSDescriptorUtils.getConfigs(context);
        }

        public FormValidation doCheckConfigId(@AncestorInPath @Nullable ItemGroup<?> context, @QueryParameter @CheckForNull String configId) {
            return NodeJSDescriptorUtils.checkConfig(context, configId);
        }
    }
}

