/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class Npmrc {
    private static final String UTF_8 = "UTF-8";
    private Map<Object, String> properties = new LinkedHashMap<Object, String>();

    public static Npmrc load(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("file " + file + " does not exists or is not file");
        }
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        String content = new String(Files.readAllBytes(path), UTF_8);
        Npmrc config = new Npmrc();
        config.from(content);
        return config;
    }

    public void from(String content) {
        if (content == null) {
            return;
        }
        LineIterator iterator = IOUtils.lineIterator((Reader)new StringReader(content));
        while (iterator.hasNext()) {
            String line = iterator.nextLine();
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith(";")) {
                this.addComment(line.substring(1));
                continue;
            }
            int eqIndex = line.indexOf(61);
            if (eqIndex != -1) {
                String key = line.substring(0, eqIndex).trim();
                String value = line.substring(eqIndex + 1).trim();
                this.set(key, value);
                continue;
            }
            this.addComment(line);
        }
    }

    public void addComment(String comment) {
        this.properties.put(new Comment(){}, comment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, String> entry : this.properties.entrySet()) {
            String line = entry.getKey() instanceof Comment ? ';' + entry.getValue() : entry.getKey() + " = " + entry.getValue();
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public void save(File file) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)this.toString(), (String)UTF_8);
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public String set(String key, String value) {
        return this.properties.put(key, value);
    }

    public boolean set(String key, boolean value) {
        return Boolean.parseBoolean(this.properties.put(key, Boolean.toString(value)));
    }

    public Boolean getAsBoolean(String key) {
        Boolean result = null;
        if (this.contains(key)) {
            result = Boolean.valueOf(this.properties.get(key));
        }
        return result;
    }

    public Integer getAsNumber(String key) {
        Integer result = null;
        if (this.contains(key)) {
            result = Integer.valueOf(this.properties.get(key));
        }
        return result;
    }

    private static interface Comment {
    }
}

