/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NPMRegistry
extends AbstractDescribableImpl<NPMRegistry>
implements Serializable {
    private static final long serialVersionUID = -5199710867477461372L;
    private final String url;
    private final String scopes;
    private final String credentialsId;

    public NPMRegistry(@Nonnull String url, String credentialsId, String scopes) {
        this.url = Util.fixEmpty((String)url);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.scopes = this.fixScope(Util.fixEmpty((String)scopes));
    }

    @DataBoundConstructor
    public NPMRegistry(@Nonnull String url, String credentialsId, boolean hasScopes, String scopes) {
        this.url = Util.fixEmpty((String)url);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.scopes = hasScopes ? this.fixScope(Util.fixEmpty((String)scopes)) : null;
    }

    @Nullable
    private String fixScope(@Nullable String scope) {
        if (scope != null && scope.startsWith("@")) {
            return scope.substring(1);
        }
        return scope;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public String getScopes() {
        return this.scopes;
    }

    public boolean isHasScopes() {
        return this.scopes != null;
    }

    public List<String> getScopesAsList() {
        List<String> result = Collections.emptyList();
        if (this.isHasScopes()) {
            result = Arrays.asList(StringUtils.split((String)this.scopes));
        }
        return result;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void doVerify() throws VerifyConfigProviderException {
        DescriptorImpl descriptor = new DescriptorImpl();
        this.throwException(descriptor.doCheckUrl(this.getUrl()));
        this.throwException(descriptor.doCheckScopes(this.isHasScopes(), this.getScopes()));
    }

    private void throwException(FormValidation form) throws VerifyConfigProviderException {
        if (form.kind == FormValidation.Kind.ERROR) {
            throw new VerifyConfigProviderException(form.getLocalizedMessage());
        }
    }

    public String toString() {
        return "url: " + this.url + (this.scopes != null ? " scopes: [" + this.scopes + "]" : "") + (this.credentialsId != null ? " credentialId: " + this.credentialsId : "");
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NPMRegistry> {
        public FormValidation doCheckScopes(@CheckForNull @QueryParameter boolean hasScopes, @CheckForNull @QueryParameter String scopes) {
            scopes = Util.fixEmptyAndTrim((String)scopes);
            if (hasScopes) {
                if (scopes == null) {
                    return FormValidation.error((String)"Scopes is empty");
                }
                StringTokenizer st = new StringTokenizer(scopes);
                while (st.hasMoreTokens()) {
                    String aScope = st.nextToken();
                    if (!aScope.startsWith("@")) continue;
                    if (aScope.length() == 1) {
                        return FormValidation.error((String)"Invalid scope");
                    }
                    return FormValidation.warning((String)"Remove the '@' character from scope");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@CheckForNull @QueryParameter String url) {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"Empty URL");
            }
            if (url.indexOf(36) == -1 && DescriptorImpl.toURL(url) == null) {
                return FormValidation.error((String)"Invalid URL, should start with https://");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup<?> context, @Nonnull @QueryParameter String credentialsId, @Nonnull @QueryParameter String url) {
            if (!this.hasPermission(context)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            URL registryURL = DescriptorImpl.toURL(url);
            List<Object> domainRequirements = registryURL != null ? Collections.singletonList(new HostnameRequirement(registryURL.getHost())) : Collections.emptyList();
            return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM, context, StandardUsernameCredentials.class, domainRequirements, CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        private boolean hasPermission(ItemGroup<?> context) {
            Jenkins controller = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            return controller != null && controller.hasPermission(Computer.CONFIGURE);
        }

        public String getDisplayName() {
            return "";
        }

        private static URL toURL(String url) {
            URL result = null;
            String fixedURL = Util.fixEmptyAndTrim((String)url);
            if (fixedURL != null) {
                try {
                    return new URL(fixedURL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

