/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.NodeJSUtils;
import jenkins.plugins.nodejs.configfiles.NPMConfig;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ConfigFile;
import org.jenkinsci.lib.configprovider.model.ConfigFileManager;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NodeJSBuildWrapper
extends SimpleBuildWrapper {
    private final String nodeJSInstallationName;
    private final String configId;

    @DataBoundConstructor
    public NodeJSBuildWrapper(String nodeJSInstallationName, String configId) {
        this.nodeJSInstallationName = Util.fixEmpty((String)nodeJSInstallationName);
        this.configId = Util.fixEmpty((String)configId);
    }

    public NodeJSInstallation getNodeJS() {
        return NodeJSUtils.getNodeJS(this.nodeJSInstallationName);
    }

    public String getNodeJSInstallationName() {
        return this.nodeJSInstallationName;
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        NodeJSInstallation ni = this.getNodeJS();
        if (ni == null) {
            throw new IOException(Messages.NodeJSBuilders_noInstallationFound(this.nodeJSInstallationName));
        }
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new AbortException(Messages.NodeJSBuilders_nodeOffline());
        }
        Node node = computer.getNode();
        if (node == null) {
            throw new AbortException(Messages.NodeJSBuilders_nodeOffline());
        }
        ni = ni.forNode(node, listener);
        ni = ni.forEnvironment(initialEnvironment);
        ni.buildEnvVars(new EnvVarsAdapter(context));
        EnvVars env = initialEnvironment.overrideAll(context.getEnv());
        if (this.configId != null) {
            ConfigFile cf = new ConfigFile(this.configId, null, true);
            FilePath configFile = ConfigFileManager.provisionConfigFile((ConfigFile)cf, (EnvVars)env, build, (FilePath)workspace, (TaskListener)listener, new ArrayList());
            context.env("npm_config_userconfig", configFile.getRemote());
            build.addAction((Action)new CleanTempFilesAction(configFile.getRemote()));
        }
    }

    @Symbol(value={"nodejs"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NodeJSBuildWrapper_displayName();
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSUtils.getInstallations();
        }

        public Collection<Config> getConfigs() {
            return GlobalConfigFiles.get().getConfigs(NPMConfig.NPMConfigProvider.class);
        }

        public FormValidation doCheckConfigId(@CheckForNull @QueryParameter String configId) {
            NPMConfig config = (NPMConfig)GlobalConfigFiles.get().getById(configId);
            if (config != null) {
                try {
                    config.doVerify();
                }
                catch (VerifyConfigProviderException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }

    private static class EnvVarsAdapter
    extends EnvVars {
        private static final long serialVersionUID = 1L;
        private final transient SimpleBuildWrapper.Context context;

        public EnvVarsAdapter(@Nonnull SimpleBuildWrapper.Context context) {
            this.context = context;
        }

        public String put(String key, String value) {
            this.context.env(key, value);
            return null;
        }

        public void override(String key, String value) {
            this.put(key, value);
        }
    }
}

