/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.configfiles.NPMConfig;
import jenkins.plugins.nodejs.configfiles.NPMRegistry;
import jenkins.plugins.nodejs.configfiles.RegistryHelper;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFileUtil;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;

final class NodeJSUtils {
    private NodeJSUtils() {
    }

    @Nullable
    public static NodeJSInstallation getNodeJS(@Nullable String name) {
        if (name != null) {
            for (NodeJSInstallation installation : NodeJSUtils.getInstallations()) {
                if (!name.equals(installation.getName())) continue;
                return installation;
            }
        }
        return null;
    }

    @Nonnull
    public static NodeJSInstallation[] getInstallations() {
        NodeJSInstallation.DescriptorImpl descriptor = (NodeJSInstallation.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(NodeJSInstallation.DescriptorImpl.class);
        if (descriptor == null) {
            throw new IllegalStateException("Impossible retrieve NodeJSInstallation descriptor");
        }
        return (NodeJSInstallation[])descriptor.getInstallations();
    }

    public static FilePath supplyConfig(String configId, AbstractBuild<?, ?> build, TaskListener listener, EnvVars env) throws AbortException {
        if (StringUtils.isNotBlank((String)configId)) {
            Config c = ConfigFiles.getByIdOrNull(build, (String)configId);
            if (c == null) {
                throw new AbortException("this NodeJS build is setup to use a config with id " + configId + " but can not be find");
            }
            NPMConfig config = c instanceof NPMConfig ? (NPMConfig)c : new NPMConfig(c.id, c.name, c.comment, c.content, c.getProviderId(), null);
            listener.getLogger().println("using user config with name " + config.name);
            String fileContent = config.content;
            List<NPMRegistry> registries = config.getRegistries();
            RegistryHelper helper = new RegistryHelper(registries);
            if (!registries.isEmpty()) {
                listener.getLogger().println("Adding all registry entries");
                Map<String, StandardUsernameCredentials> registry2Credentials = helper.resolveCredentials((Run<?, ?>)build);
                fileContent = helper.fillRegistry(fileContent, registry2Credentials);
            }
            try {
                if (StringUtils.isNotBlank((String)fileContent)) {
                    config.doVerify();
                    FilePath workDir = ManagedFileUtil.tempDir((FilePath)build.getWorkspace());
                    final FilePath f = workDir.createTextTempFile(".npmrc", "", Util.replaceMacro((String)fileContent, (Map)env), true);
                    listener.getLogger().printf("Created %s", f);
                    build.getEnvironments().add((Object)new Environment(){

                        public void buildEnvVars(Map<String, String> env) {
                            env.put("npm_config_userconfig", f.getRemote());
                        }
                    });
                    build.addAction((Action)new CleanTempFilesAction(f.getRemote()));
                    return f;
                }
            }
            catch (VerifyConfigProviderException e) {
                throw new AbortException("Invalid user config: " + e.getMessage());
            }
            catch (Exception e) {
                throw new IllegalStateException("the npmrc user config could not be supplied for the current build", e);
            }
        }
        return null;
    }
}

