/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.plugins.nested_view.Messages;
import hudson.views.ViewsTabBar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedView
extends View
implements ViewGroup,
StaplerProxy {
    private final CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList();
    private String defaultView;

    @DataBoundConstructor
    public NestedView(String name) {
        super(name);
    }

    public List<TopLevelItem> getItems() {
        return Collections.emptyList();
    }

    public boolean contains(TopLevelItem item) {
        return false;
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Hudson.getInstance().doCreateItem(req, rsp);
    }

    public synchronized void onJobRenamed(Item item, String oldName, String newName) {
        for (View v : this.views) {
            v.onJobRenamed(item, oldName, newName);
        }
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        this.defaultView = Util.fixEmpty((String)req.getParameter("defaultView"));
    }

    public boolean canDelete(View view) {
        return true;
    }

    public void deleteView(View view) throws IOException {
        this.views.remove(view);
    }

    @Exported
    public Collection<View> getViews() {
        ArrayList<View> copy = new ArrayList<View>(this.views);
        Collections.sort(copy, View.SORTER);
        return copy;
    }

    public View getView(String name) {
        for (View v : this.views) {
            if (!v.getViewName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public View getDefaultView() {
        return this.isDefault() ? null : this.getView(this.defaultView);
    }

    public void onViewRenamed(View view, String oldName, String newName) {
    }

    public void save() throws IOException {
        this.owner.save();
    }

    public void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.views.add(View.create((StaplerRequest)req, (StaplerResponse)rsp, (ViewGroup)this));
        this.save();
    }

    public static Result getWorstResult(View view) {
        Result result = Result.SUCCESS;
        if (view instanceof NestedView) {
            for (View v : ((NestedView)view).getViews()) {
                Result check = NestedView.getWorstResult(v);
                if (!check.isWorseThan(result)) continue;
                result = check;
            }
        } else {
            for (TopLevelItem item : view.getItems()) {
                Result check;
                if (!(item instanceof Job) || !(check = ((Job)item).getLastCompletedBuild().getResult()).isWorseThan(result)) continue;
                result = check;
            }
        }
        return result;
    }

    public static HealthReportContainer getViewHealth(View view) {
        HealthReportContainer hrc = new HealthReportContainer();
        NestedView.healthCounter(hrc, view);
        hrc.report = hrc.count > 0 ? new HealthReport(hrc.sum / hrc.count, Messages._ViewHealth(hrc.count)) : new HealthReport(100, Messages._NoJobs());
        return hrc;
    }

    private static void healthCounter(HealthReportContainer hrc, View view) {
        if (view instanceof NestedView) {
            for (View v : ((NestedView)view).getViews()) {
                NestedView.healthCounter(hrc, v);
            }
        } else {
            for (TopLevelItem item : view.getItems()) {
                if (!(item instanceof Job)) continue;
                hrc.sum += ((Job)item).getBuildHealth().getScore();
                hrc.count++;
            }
        }
    }

    public ViewsTabBar getViewsTabBar() {
        return Hudson.getInstance().getViewsTabBar();
    }

    public Object getTarget() {
        return "".equals(Stapler.getCurrentRequest().getRestOfPath()) ? new DefaultViewProxy() : this;
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }
    }

    public class DefaultViewProxy {
        public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            if (NestedView.this.getDefaultView() != null) {
                rsp.sendRedirect2("view/" + NestedView.this.defaultView);
            } else {
                req.getView((Object)NestedView.this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HealthReportContainer {
        private HealthReport report;
        private int sum = 0;
        private int count = 0;

        private HealthReportContainer() {
        }

        public HealthReport getBuildHealth() {
            return this.report;
        }

        public List<HealthReport> getBuildHealthReports() {
            return Collections.singletonList(this.report);
        }
    }
}

