/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view;

import com.google.common.collect.Lists;
import hudson.DescriptorExtensionList;
import hudson.model.Descriptor;
import hudson.util.DescribableList;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;

public class NestedViewColumns {
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;

    public void updateFromForm(StaplerRequest2 req, JSONObject formData, String key) throws IOException, Descriptor.FormException {
        this.columns.rebuildHetero(req, formData, NestedViewColumns.getPossibleColumns(), key);
    }

    public void setColumns(DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns) {
        this.columns = columns;
    }

    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return this.columns;
    }

    public boolean isShowStatusColumn() {
        return this.containsColumnWithDescriptor(StatusColumn.DescriptorImpl.class);
    }

    public boolean isShowWeatherColumn() {
        return this.containsColumnWithDescriptor(WeatherColumn.DescriptorImpl.class);
    }

    public static List<Descriptor<ListViewColumn>> getPossibleColumns() {
        return NestedViewColumns.extractOptionalColumns(NestedViewColumns.allViewColumns());
    }

    private boolean containsColumnWithDescriptor(Class<? extends ListViewColumnDescriptor> descriptorClass) {
        for (ListViewColumn column : this.columns) {
            if (column.getDescriptor().getClass() != descriptorClass) continue;
            return true;
        }
        return false;
    }

    private static DescriptorExtensionList<ListViewColumn, Descriptor<ListViewColumn>> allViewColumns() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IllegalStateException();
        }
        return j.getDescriptorList(ListViewColumn.class);
    }

    private static List<Descriptor<ListViewColumn>> extractOptionalColumns(DescriptorExtensionList<ListViewColumn, Descriptor<ListViewColumn>> extensionList) {
        return Lists.newArrayList((Object[])new Descriptor[]{(Descriptor)extensionList.get(WeatherColumn.DescriptorImpl.class), (Descriptor)extensionList.get(StatusColumn.DescriptorImpl.class)});
    }
}

