/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.nested_view.NestedViewGlobalConfig;
import hudson.plugins.nested_view.NestedViewsSearch;
import hudson.plugins.nested_view.search.BuildDetails;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class HistoryItem {
    private static List<HistoryItem> history;
    private final String query;
    private final int size;
    private final Date date;

    private static void save() {
        NestedViewGlobalConfig.getInstance().setHistoryContent(HistoryItem.saveToString());
        NestedViewGlobalConfig.getInstance().save();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="date is not cared")
    public HistoryItem(String query, int size, Date date) {
        this.query = query;
        this.size = size;
        this.date = date;
    }

    private static void saveToFile(File f) {
        try {
            Files.write(f.toPath(), HistoryItem.saveToString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception ex) {
            NestedViewsSearch.LOGGER.log(Level.SEVERE, "saving nested view search history failed", ex);
        }
    }

    private static String saveToString() {
        return history.stream().map(a -> a.toSave()).collect(Collectors.joining("\n"));
    }

    private static List<HistoryItem> loadFromFile(File f) {
        List<String> l = new ArrayList<String>(0);
        if (f.exists()) {
            try {
                l = Files.readAllLines(f.toPath());
            }
            catch (Exception ex) {
                NestedViewsSearch.LOGGER.log(Level.SEVERE, "loading nested view search history failed", ex);
            }
        }
        return HistoryItem.loadFromStrings(l);
    }

    private static List<HistoryItem> loadFromString(String l) {
        return HistoryItem.loadFromStrings(Arrays.asList(l.split("\n")));
    }

    private static void load() {
        history = HistoryItem.loadFromString(NestedViewGlobalConfig.getInstance().getHistoryContent());
    }

    private static List<HistoryItem> loadFromStrings(List<String> l) {
        ArrayList<HistoryItem> r = new ArrayList<HistoryItem>(NestedViewGlobalConfig.getInstance().getNestedViewHistoryCount());
        for (String s : l) {
            try {
                if (s == null || s.trim().isEmpty()) continue;
                r.add(new HistoryItem(s));
            }
            catch (Exception ex) {
                NestedViewsSearch.LOGGER.log(Level.SEVERE, "reading nested view search history " + s + " failed", ex);
            }
        }
        return Collections.synchronizedList(r);
    }

    public static List<HistoryItem> get() {
        HistoryItem.load();
        return Collections.unmodifiableList(history);
    }

    public static void add(HistoryItem his) {
        HistoryItem.load();
        history.removeAll(Collections.singleton(his));
        history.add(0, his);
        HistoryItem.shrink();
        HistoryItem.save();
    }

    private static void shrink() {
        HistoryItem.shrink(NestedViewGlobalConfig.getInstance().getNestedViewHistoryCount());
    }

    private static void shrink(int to) {
        int tot;
        int n = tot = to < 0 ? 0 : to;
        while (history.size() > tot) {
            history.remove(history.size() - 1);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryItem that = (HistoryItem)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String getQuery() {
        return this.query;
    }

    public String getUrl() {
        return BuildDetails.getJenkinsUrl() + "/search/?q=" + this.getQuery().replaceAll("#", "%23");
    }

    public int getSize() {
        return this.size;
    }

    public String getDate() {
        return new SimpleDateFormat("HH:mm:ss dd/MM").format(this.date);
    }

    public String toSave() {
        return this.size + " " + this.date.getTime() + " " + this.query;
    }

    public HistoryItem(String saved) {
        String[] sd = saved.split(" ");
        this.size = Integer.parseInt(sd[0]);
        this.date = new Date(Long.parseLong(sd[1]));
        this.query = saved.replace(this.size + " " + this.date.getTime() + " ", "");
    }
}

