/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.Logger;
import com.deepshiftlabs.nerrvana.Platform;
import com.deepshiftlabs.nerrvana.UserMessageLevel;
import com.deepshiftlabs.nerrvana.Utils;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class NerrvanaPluginSettings {
    public String httpurl;
    public String apikey;
    public String secretkey;
    public int nodes_count;
    public String test_run_name;
    public String test_run_descr;
    public String test_run_descr_file;
    public String executable_file;
    public boolean validation = false;
    public List<Platform> platforms;
    public String folder_with_tests;
    public String space_id;
    public String space_name;
    public String space_path;
    public String ftpsurl;
    public String ftpsuser;
    public String ftpspass;
    public int maxtime;
    public int poll;
    public final String executionResultsFilename = "results.xml";
    public boolean testExecutionResults = true;
    public UserMessageLevel messageThreshold = UserMessageLevel.ERROR;
    public boolean skipUpload = false;

    public static NerrvanaPluginSettings parse(Document doc) throws Exception {
        NodeList list = null;
        NerrvanaPluginSettings npc = new NerrvanaPluginSettings();
        npc.httpurl = Utils.uniqueTagValue("gateway", doc, true);
        npc.apikey = Utils.uniqueTagValue("apikey", doc, true);
        npc.secretkey = Utils.uniqueTagValue("secretkey", doc, true);
        String s = Utils.uniqueTagValue("nodes-count", doc, true);
        try {
            npc.nodes_count = Integer.parseInt(s);
            if (npc.nodes_count <= 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            Logger.infoln("\tSelenium nodes per platform value is incorrect: " + s + ". Reset to 1.\n");
            npc.nodes_count = 1;
        }
        s = Utils.uniqueTagValue("use-messages-to-set-build-status", doc, false);
        if (s != null && (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("0"))) {
            npc.testExecutionResults = false;
        }
        if ((s = Utils.uniqueTagValue("message-threshold", doc, false)) != null) {
            npc.messageThreshold = UserMessageLevel.parseThreshold(s);
        }
        npc.test_run_name = Utils.uniqueTagValue("test-run-name", doc, false);
        npc.test_run_descr = Utils.uniqueTagValue("test-run-descr", doc, false);
        npc.test_run_descr_file = Utils.uniqueTagValue("test-run-descr-file", doc, false);
        npc.executable_file = Utils.uniqueTagValue("executable-file", doc, true);
        npc.folder_with_tests = Utils.uniqueTagValue("folder-with-tests", doc, false);
        list = doc.getElementsByTagName("space");
        if (list.getLength() != 1) {
            throw new Exception("Nerrvana space incorrectly defined");
        }
        npc.space_id = Utils.getUniqueChildNodeValue(list.item(0), "id");
        npc.space_name = Utils.getUniqueChildNodeValue(list.item(0), "name");
        npc.space_path = Utils.getUniqueChildNodeValue(list.item(0), "ftp-path");
        npc.ftpsurl = Utils.uniqueTagValue("server", doc, true);
        npc.ftpsuser = Utils.uniqueTagValue("username", doc, true);
        npc.ftpspass = Utils.uniqueTagValue("password", doc, true);
        try {
            npc.maxtime = Integer.parseInt(Utils.uniqueTagValue("max-execution-time", doc, false));
        }
        catch (Exception e) {
            npc.maxtime = 3600;
        }
        try {
            npc.poll = Integer.parseInt(Utils.uniqueTagValue("poll-period", doc, false));
        }
        catch (Exception e) {
            npc.poll = 25;
        }
        list = doc.getElementsByTagName("platforms");
        if (list != null && list.getLength() > 0) {
            npc.platforms = Platform.getPlatformList(list.item(0));
        }
        if ((s = Utils.uniqueTagValue("skip-tests-sync", doc, false)) != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes"))) {
            npc.skipUpload = true;
        }
        return npc;
    }

    public boolean checkSettings() {
        boolean result = true;
        StringBuilder sb = new StringBuilder("\n---BEGIN PLUGIN SETTINGS---\n");
        sb.append("\tNerrvana HTTP address: " + this.httpurl).append("\n");
        if (this.httpurl == null || this.httpurl.length() == 0 || !this.httpurl.startsWith("http://") && !this.httpurl.startsWith("https://")) {
            sb.append("\tNerrvana web address doesn't look like valid HTTP/HTTPS URL. Fatal error.\n");
            result = false;
        }
        sb.append("\tNerrvana API key: " + this.apikey).append("\n");
        if (this.apikey == null || this.apikey.length() == 0) {
            sb.append("\tNerrvana API key not set or is invalid. Fatal error.\n");
            result = false;
        }
        sb.append("\tSecret key: " + this.secretkey).append("\n");
        if (this.secretkey == null || this.secretkey.length() == 0) {
            sb.append("\tSecret key doesn't look like valid Nerrvana secret key. Fatal error.\n");
            result = false;
        }
        sb.append("\tSpace ID: " + this.space_id).append("\n");
        if (this.space_id == null || this.space_id.length() == 0) {
            sb.append("\tNerrvana space ID is not valid. Fatal error.\n");
            result = false;
        }
        sb.append("\tSpace: " + this.space_name).append("\n");
        if (this.space_name == null || this.space_name.length() == 0) {
            sb.append("\tNerrvana space name is not valid. Fatal error.\n");
            result = false;
        }
        sb.append("\tSpace path[FTPS folder]: " + this.space_path).append("\n");
        if (this.space_path == null || this.space_path.length() == 0) {
            sb.append("\tNerrvana space folder is not valid. Fatal error.\n");
            result = false;
        }
        sb.append("\tSelenium nodes per platform: " + this.nodes_count).append("\n");
        sb.append("\tTest run name: " + this.test_run_name).append("\n");
        if (this.platforms == null || this.platforms.size() == 0) {
            sb.append("\tNerrvana platforms not defined. Fatal error.\n");
            result = false;
        } else {
            sb.append("\tNerrvana platforms:\n");
            Iterator<Platform> it = this.platforms.iterator();
            while (it.hasNext()) {
                sb.append("\t\t" + it.next().name).append("\n");
            }
        }
        sb.append("\tExecutable file: " + this.executable_file).append("\n");
        if (this.executable_file == null || this.executable_file.length() == 0) {
            sb.append("\tExecutable file not defined. Fatal error.\n");
            result = false;
        }
        if (this.ftpsurl == null || this.ftpsurl.length() == 0) {
            sb.append("\tNerrvana FTPS address: " + this.ftpsurl);
            sb.append("\tNerrvana FTPS address not defined. Fatal error.\n");
            result = false;
        } else {
            if (this.ftpsurl.startsWith("ftp://")) {
                this.ftpsurl = this.ftpsurl.substring("ftp://".length());
            } else if (this.ftpsurl.startsWith("ftps://")) {
                this.ftpsurl = this.ftpsurl.substring("ftps://".length());
            }
            sb.append("\tNerrvana FTPS address: " + this.ftpsurl).append("\n");
        }
        sb.append("\tNerrvana FTPS user: " + this.ftpsuser).append("\n");
        if (this.ftpsuser == null || this.ftpsuser.length() == 0) {
            sb.append("\tNerrvana FTPS username is missing. Fatal error.\n");
            result = false;
        }
        sb.append("\tNerrvana FTPS pass: " + this.ftpspass).append("\n");
        if (this.ftpspass == null || this.ftpspass.length() == 0) {
            sb.append("\tNerrvana FTPS password is missing. Fatal error.\n");
            result = false;
        }
        sb.append("\tWorkspace folder: " + this.folder_with_tests).append("\n");
        if (this.folder_with_tests == null || this.folder_with_tests.length() == 0) {
            sb.append("\tWorkspace folder not specified. Assuming workspace root.\n");
        }
        sb.append("\tMax execution time: " + this.maxtime).append("\n");
        sb.append("\tPoll period: " + this.poll).append("\n");
        sb.append("\tParse user messages mode[results analyzer]: " + (this.testExecutionResults ? "ON" : "OFF")).append("\n");
        if (this.testExecutionResults) {
            sb.append("\tUser message threshold: " + this.messageThreshold.name()).append("\n");
        }
        sb.append("-----END PLUGIN SETTINGS---");
        Logger.infoln(sb.toString());
        return result;
    }

    public long getMaxtimeMillis() {
        long x = this.maxtime;
        if (x < 60L) {
            Logger.infoln("Maximum execution time is too small[" + x + "]. Resetting to 60 seconds (1 minute)");
            x = 60L;
        } else if (x > 7200L) {
            Logger.infoln("Maximum execution time is too big[" + x + "]. Resetting to 7200 seconds (2 hours)");
            x = 7200L;
        }
        return x * 1000L;
    }

    public long getPollMillis() {
        long x = this.poll;
        if (x < 20L) {
            Logger.infoln("Poll period is too short[" + x + "]. Resetting to 20 seconds");
            x = 20L;
        } else if (x > 1800L) {
            Logger.infoln("Poll period is too long[" + x + "]. Resetting to 1800 seconds (30 minutes)");
            x = 1800L;
        }
        return x * 1000L;
    }
}

