/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import com.google.common.base.Charsets;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Run;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.RunList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import jenkins.model.Jenkins;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.neoload.integration.NeoBuildAction;
import org.jenkinsci.plugins.neoload.integration.NeoGlobalConfig;
import org.jenkinsci.plugins.neoload.integration.NeoResultsAction;
import org.jenkinsci.plugins.neoload.integration.supporting.CollabServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.LockManager;
import org.jenkinsci.plugins.neoload.integration.supporting.NTSServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoLoadPluginOptions;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadGraphsStatistics;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.SimpleBuildOption;
import org.jenkinsci.plugins.neoload.integration.supporting.XMLUtilities;
import org.kohsuke.stapler.Stapler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class PluginUtils
implements Serializable,
Converter {
    public static final LockManager GRAPH_LOCK = new LockManager();
    private static final BCodec BCODEC = new BCodec();
    private static final Logger LOGGER = Logger.getLogger(PluginUtils.class.getName());
    private static final long serialVersionUID = -3063042074729452263L;
    public static final String EMPTY_SERVER_MESSAGE = "Please configure Jenkins System Settings for NeoLoad to add a server.";

    private PluginUtils() {
    }

    public static String encode(String text) throws EncoderException {
        return BCODEC.encode(text, Charsets.UTF_8.name());
    }

    public static String decode(String text) throws DecoderException {
        return BCODEC.decode(text);
    }

    public static NeoLoadPluginOptions getPluginOptions(AbstractProject<?, ?> project) {
        NeoBuildAction nba = null;
        if (!(project instanceof Project)) {
            return null;
        }
        Project proj = (Project)project;
        List builders = proj.getBuilders();
        for (Builder b : builders) {
            if (!(b instanceof NeoBuildAction)) continue;
            nba = (NeoBuildAction)b;
            break;
        }
        return nba;
    }

    public static NeoLoadPluginOptions getPluginOptions(Job<?, ?> project) {
        return (NeoLoadPluginOptions)project.getProperty(SimpleBuildOption.class);
    }

    public static NeoBuildAction getNeoBuildAction(AbstractProject<?, ?> project) {
        if (!(project instanceof Project)) {
            return null;
        }
        for (Builder b : ((Project)project).getBuilders()) {
            if (!(b instanceof NeoBuildAction)) continue;
            return (NeoBuildAction)b;
        }
        return null;
    }

    public static NeoResultsAction getNeoResultAction(AbstractBuild<?, ?> build) {
        return (NeoResultsAction)build.getAction(NeoResultsAction.class);
    }

    public static NeoResultsAction getNeoResultAction(Run<?, ?> build) {
        return (NeoResultsAction)build.getAction(NeoResultsAction.class);
    }

    public static FormValidation validateWarnIfEmpty(String fieldValue, String displayName) {
        if (StringUtils.trimToNull((String)fieldValue) == null) {
            return FormValidation.warning((String)("Don't forget to include the " + displayName + "."));
        }
        return FormValidation.ok();
    }

    public static FormValidation formValidationErrorToWarning(FormValidation formValidation) {
        if (FormValidation.Kind.ERROR.equals((Object)formValidation.kind)) {
            return FormValidation.warning((String)StringEscapeUtils.unescapeHtml((String)formValidation.getMessage()));
        }
        return formValidation;
    }

    public static FormValidation validateURL(String url) {
        if (StringUtils.trimToNull((String)url) == null) {
            return FormValidation.warning((String)"Don't forget to include the URL.");
        }
        try {
            URI uri = new URI(url);
            if (uri.getScheme() == null || uri.getHost() == null) {
                return FormValidation.error((String)("Invalid URL: " + url));
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            return FormValidation.error((String)"URL could not be parsed.");
        }
    }

    public static List<String> removeAllEmpties(String ... originalStrings) {
        ArrayList<String> cleanedStrings = new ArrayList<String>(Arrays.asList(originalStrings));
        cleanedStrings.removeAll(Arrays.asList(null, "", Collections.singleton(null)));
        Iterator it = cleanedStrings.iterator();
        while (it.hasNext()) {
            String s2 = (String)it.next();
            if (StringUtils.trimToEmpty((String)s2).length() != 0) continue;
            it.remove();
        }
        return cleanedStrings;
    }

    public static FormValidation validateFileExists(String file, String[] extensions, boolean checkExtension, boolean checkInPath) {
        FormValidation emptyOrNullValidation = FormValidation.validateRequired((String)file);
        if (!FormValidation.Kind.OK.equals((Object)emptyOrNullValidation.kind)) {
            return emptyOrNullValidation;
        }
        if (checkExtension && !PluginUtils.checkExtention(file, extensions)) {
            return FormValidation.error((String)("Please specify a valid file extension " + Arrays.toString(extensions) + "."));
        }
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.ok((String)"Insufficient permission to perform legend validation.");
        }
        if (file.indexOf(File.separatorChar) >= 0) {
            File f = new File(file);
            if (f.exists()) {
                return FormValidation.FileValidator.NOOP.validate(f);
            }
            for (String extension : extensions) {
                File fexe = new File(file + extension);
                if (!fexe.exists()) continue;
                return FormValidation.FileValidator.NOOP.validate(fexe);
            }
        }
        if (Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
            return FormValidation.ok();
        }
        if (checkInPath) {
            String path = (String)EnvVars.masterEnvVars.get("PATH");
            String delimiter = null;
            if (path != null) {
                for (String _dir : Util.tokenize((String)path.replace("\\", "\\\\"), (String)File.pathSeparator)) {
                    File dir;
                    File f;
                    if (delimiter == null) {
                        delimiter = ", ";
                    }
                    if ((f = new File(dir = new File(_dir), file)).exists()) {
                        return FormValidation.FileValidator.NOOP.validate(f);
                    }
                    File fexe = new File(dir, file + ".exe");
                    if (!fexe.exists()) continue;
                    return FormValidation.FileValidator.NOOP.validate(fexe);
                }
            }
        }
        return FormValidation.ok((String)"There is no such file on local host. You can ignore this message if the job is executed on a remote slave.");
    }

    private static boolean checkExtention(String file, String[] extensions) {
        String fileNameLowerCase = file.toLowerCase();
        for (String extension : extensions) {
            if (!fileNameLowerCase.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getHTMLReportPaths(AbstractBuild<?, ?> build, String firstPath) {
        NeoBuildAction neoBuildAction;
        String htmlReportPath;
        ArrayList<String> paths = new ArrayList<String>();
        if (firstPath != null) {
            paths.add(firstPath);
        }
        if ((htmlReportPath = (neoBuildAction = PluginUtils.getNeoBuildAction(build.getProject())).getHTMLReportArtifactPath()) != null) {
            paths.add(htmlReportPath);
        }
        paths.add("neoload-report/report.html");
        return paths;
    }

    public static List<String> getHTMLReportPaths(Run<?, ?> build, String firstPath) {
        ArrayList<String> paths = new ArrayList<String>();
        if (firstPath != null) {
            paths.add(firstPath);
        }
        paths.add("neoload-report/report.html");
        return paths;
    }

    public static List<String> getXMLReportPaths(AbstractBuild<?, ?> build) {
        NeoBuildAction neoBuildAction;
        String xmlReportPath;
        ArrayList<String> paths = new ArrayList<String>();
        NeoResultsAction neoResultAction = PluginUtils.getNeoResultAction(build);
        if (neoResultAction != null && neoResultAction.getStoredXmlReportPath() != null) {
            paths.add(neoResultAction.getStoredXmlReportPath());
        }
        if ((xmlReportPath = (neoBuildAction = PluginUtils.getNeoBuildAction(build.getProject())).getXMLReportArtifactPath()) != null) {
            paths.add(xmlReportPath);
        }
        paths.add("neoload-report/report.xml");
        return paths;
    }

    public static List<String> getXMLReportPaths(Run<?, ?> build) {
        ArrayList<String> paths = new ArrayList<String>();
        NeoResultsAction neoResultAction = PluginUtils.getNeoResultAction(build);
        if (neoResultAction != null && neoResultAction.getStoredXmlReportPath() != null) {
            paths.add(neoResultAction.getStoredXmlReportPath());
        }
        paths.add("neoload-report/report.xml");
        return paths;
    }

    public static String removeWorkspaceOrRelativePoint(String report) {
        if (report == null) {
            return null;
        }
        if (report.startsWith(".") && !report.startsWith("..")) {
            return report.substring(1);
        }
        return report.replaceAll("%WORKSPACE%/|\\$\\{WORKSPACE}/", "");
    }

    public static Run.Artifact findArtifact(List<String> paths, AbstractBuild<?, ?> build) {
        if (build == null) {
            LOGGER.log(Level.SEVERE, "NeoResultsAction.findHtmlReportArtifact() build is null.");
            return null;
        }
        return PluginUtils.findArtifacts(paths, build.getArtifacts(), build.getNumber());
    }

    public static Run.Artifact findArtifact(List<String> paths, Run<?, ?> build) {
        if (build == null) {
            LOGGER.log(Level.SEVERE, "NeoResultsAction.findHtmlReportArtifact() build is null.");
            return null;
        }
        return PluginUtils.findArtifacts(paths, build.getArtifacts(), build.getNumber());
    }

    public static Run.Artifact findArtifacts(List<String> paths, List artifacts, int buildnumber) {
        for (String path : paths) {
            path = path.replaceAll("\\$\\{BUILD_NUMBER\\}", Integer.toString(buildnumber));
            while (path.startsWith(File.pathSeparator)) {
                path = path.substring(1);
            }
            for (Object object : artifacts) {
                Run.Artifact artifact = (Run.Artifact)object;
                if (!artifact.relativePath.endsWith(path)) continue;
                return artifact;
            }
        }
        return null;
    }

    public static Float getCustom(String path, Document doc) throws XPathExpressionException {
        if (path == null) {
            return null;
        }
        Node node = XMLUtilities.findFirstByExpression(path, doc);
        if (node != null) {
            return PluginUtils.extractNeoLoadNumber(node.getNodeValue());
        }
        return null;
    }

    private static Float extractNeoLoadNumber(String valArg) {
        String val = StringUtils.trimToEmpty((String)valArg);
        val = val.replaceAll(",", ".").replaceAll(" ", "");
        val = val.replaceAll(Pattern.quote("%"), "");
        if ("<0.01".equals(val = val.replaceAll(Pattern.quote("+"), ""))) {
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(val);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File getPicturesFolder(AbstractProject<?, ?> project) {
        return new File(project.getRootDir(), "neoload-trend");
    }

    public static File getPicturesFolder(Job<?, ?> project) {
        return new File(project.getRootDir(), "neoload-trend");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildGraph(File picturesFolder, NeoLoadPluginOptions npo, AbstractProject<?, ?> project) {
        if (GRAPH_LOCK.tryLock((Job)project)) {
            try {
                picturesFolder.mkdirs();
                if (picturesFolder.isDirectory()) {
                    for (File file : picturesFolder.listFiles()) {
                        file.delete();
                    }
                    NeoloadGraphsStatistics neoloadGraphsStatistics = new NeoloadGraphsStatistics(npo);
                    for (AbstractBuild build : PluginUtils.getLimitedBuilds(npo, project)) {
                        neoloadGraphsStatistics.addBuild(build);
                    }
                    try {
                        neoloadGraphsStatistics.writePng(picturesFolder);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Exception occurs during the picture writing ", e);
                    }
                }
            }
            finally {
                GRAPH_LOCK.unlock((Job)project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildGraph(File picturesFolder, NeoLoadPluginOptions npo, Job<?, ?> project) {
        if (GRAPH_LOCK.tryLock(project)) {
            try {
                picturesFolder.mkdirs();
                if (picturesFolder.isDirectory()) {
                    for (File file : picturesFolder.listFiles()) {
                        file.delete();
                    }
                    NeoloadGraphsStatistics neoloadGraphsStatistics = new NeoloadGraphsStatistics(npo);
                    for (Run build : PluginUtils.getLimitedBuilds(npo, project)) {
                        neoloadGraphsStatistics.addBuild(build);
                    }
                    try {
                        neoloadGraphsStatistics.writePng(picturesFolder);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Exception occurs during the picture writing ", e);
                    }
                }
            }
            finally {
                GRAPH_LOCK.unlock(project);
            }
        }
    }

    private static List<AbstractBuild> getLimitedBuilds(NeoLoadPluginOptions npo, AbstractProject project) {
        int maxTrends = npo.getMaxTrends();
        RunList builds = project.getBuilds();
        if (maxTrends > 0 && builds.size() > maxTrends) {
            return builds.subList(0, maxTrends);
        }
        return builds;
    }

    private static List<Run> getLimitedBuilds(NeoLoadPluginOptions npo, Job project) {
        int maxTrends = npo.getMaxTrends();
        RunList builds = project.getBuilds();
        if (maxTrends > 0 && builds.size() > maxTrends) {
            return builds.subList(0, maxTrends);
        }
        return builds;
    }

    public static void buildGraph(AbstractProject project) {
        try {
            NeoLoadPluginOptions npo = PluginUtils.getPluginOptions(project);
            File picturesFolder = PluginUtils.getPicturesFolder(project);
            PluginUtils.buildGraph(picturesFolder, npo, project);
        }
        catch (Throwable th) {
            LOGGER.log(Level.WARNING, "Exception occurs during the trend building", th);
        }
    }

    public static void buildGraph(Job project) {
        try {
            NeoLoadPluginOptions npo = PluginUtils.getPluginOptions(project);
            File picturesFolder = PluginUtils.getPicturesFolder(project);
            PluginUtils.buildGraph(picturesFolder, npo, project);
        }
        catch (Throwable th) {
            LOGGER.log(Level.WARNING, "Exception occurs during the trend building", th);
        }
    }

    public Object convert(Class type, Object value) {
        NeoGlobalConfig.DescriptorImpl globalConfigDescriptor = PluginUtils.getNeoGlobalConfig();
        if (globalConfigDescriptor == null) {
            LOGGER.log(Level.FINEST, "No NeoLoad server settings found. Please add servers before configuring jobs. (getLicenseServerOptions)");
            return null;
        }
        Collection allServerInfo = CollectionUtils.union(globalConfigDescriptor.getNtsInfo(), globalConfigDescriptor.getCollabInfo());
        for (ServerInfo si : allServerInfo) {
            if (!si.getUniqueID().equals(value)) continue;
            return si;
        }
        return null;
    }

    public static NeoGlobalConfig.DescriptorImpl getNeoGlobalConfig() {
        return (NeoGlobalConfig.DescriptorImpl)Jenkins.getInstance().getDescriptor(NeoGlobalConfig.class);
    }

    public static List<ServerInfo> getServerInfos(boolean collab) {
        NeoGlobalConfig.DescriptorImpl globalConfigDescriptor = PluginUtils.getNeoGlobalConfig();
        ArrayList<ServerInfo> serverInfoList = new ArrayList<ServerInfo>();
        if (globalConfigDescriptor != null) {
            serverInfoList.addAll(globalConfigDescriptor.getNtsInfo());
            if (collab) {
                serverInfoList.addAll(globalConfigDescriptor.getCollabInfo());
            }
        }
        return serverInfoList;
    }

    public static ListBoxModel getServerInfosListBox(boolean collab) {
        List<ServerInfo> serverInfos = PluginUtils.getServerInfos(collab);
        ListBoxModel listBoxModel = new ListBoxModel();
        if (serverInfos.isEmpty()) {
            listBoxModel.add((Object)new ListBoxModel.Option(EMPTY_SERVER_MESSAGE, null));
        } else {
            for (ServerInfo server : serverInfos) {
                listBoxModel.add((Object)new ListBoxModel.Option(server.getNonEmptyLabel(collab), server.getUniqueID()));
            }
        }
        return listBoxModel;
    }

    public static String forgeArtifactoryPath(NeoBuildAction neoBuildAction) {
        String xmlReport;
        ArrayList<String> paths = new ArrayList<String>();
        String htmlReport = neoBuildAction.getHtmlReport();
        if (StringUtils.isNotEmpty((String)htmlReport)) {
            paths.add(htmlReport);
            File file = new File(htmlReport);
            paths.add(file.getParent() + "/" + FilenameUtils.removeExtension((String)file.getName()) + "_files/**");
        }
        if (StringUtils.isNotEmpty((String)(xmlReport = neoBuildAction.getXmlReport()))) {
            paths.add(xmlReport);
            paths.add(xmlReport.replace(".xml", ".dtd"));
        }
        PluginUtils.addIfNotEmpty(paths, neoBuildAction.getPdfReport());
        PluginUtils.addIfNotEmpty(paths, neoBuildAction.getJunitReport());
        return StringUtils.join(paths, (String)",");
    }

    private static void addIfNotEmpty(List<String> paths, String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            paths.add(str);
        }
    }

    public static boolean isSAP(String licenseVUSAPCount) {
        return StringUtils.isNotEmpty((String)licenseVUSAPCount) && !licenseVUSAPCount.equals("0");
    }

    static {
        Stapler.CONVERT_UTILS.register((Converter)new PluginUtils(), ServerInfo.class);
        Stapler.CONVERT_UTILS.register((Converter)new PluginUtils(), CollabServerInfo.class);
        Stapler.CONVERT_UTILS.register((Converter)new PluginUtils(), NTSServerInfo.class);
    }
}

