/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadCurvesXPathStat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Size2D;
import org.w3c.dom.Document;

public class NeoloadGraphXPathStat {
    private static final int IMAGE_HEIGHT = 200;
    private static final int IMAGE_WIDTH = 500;
    private static final int LEGEND_HEIGHT = 20;
    private final String title;
    private final List<NeoloadCurvesXPathStat> curves;
    private final String yLabel;
    private final boolean legend;

    public NeoloadGraphXPathStat(String title, String yLabel, NeoloadCurvesXPathStat ... curves) {
        this.title = title;
        this.curves = Arrays.asList(curves);
        this.yLabel = yLabel;
        this.legend = false;
    }

    public NeoloadGraphXPathStat(String title, String yLabel, List<NeoloadCurvesXPathStat> curves) {
        this.title = title;
        this.curves = curves;
        this.yLabel = yLabel;
        this.legend = true;
    }

    public static TickUnitSource createStandardTickUnits() {
        TickUnits units = new TickUnits();
        DecimalFormat df5 = new DecimalFormat("0.000");
        DecimalFormat df6 = new DecimalFormat("0.00");
        DecimalFormat df7 = new DecimalFormat("0.0");
        DecimalFormat df8 = new DecimalFormat("#,##0");
        DecimalFormat df9 = new DecimalFormat("#,###,##0");
        DecimalFormat df10 = new DecimalFormat("#,###,###,##0");
        units.add((TickUnit)new NumberTickUnit(0.001, (NumberFormat)df5));
        units.add((TickUnit)new NumberTickUnit(0.01, (NumberFormat)df6));
        units.add((TickUnit)new NumberTickUnit(0.1, (NumberFormat)df7));
        units.add((TickUnit)new NumberTickUnit(1.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(10.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(100.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(10000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(100000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(1000000.0, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(1.0E7, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(1.0E8, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(1.0E9, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(1.0E10, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(1.0E11, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(0.025, (NumberFormat)df5));
        units.add((TickUnit)new NumberTickUnit(0.25, (NumberFormat)df6));
        units.add((TickUnit)new NumberTickUnit(2.5, (NumberFormat)df7));
        units.add((TickUnit)new NumberTickUnit(25.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(250.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2500.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(25000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(250000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(2500000.0, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(2.5E7, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(2.5E8, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(2.5E9, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(2.5E10, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(2.5E11, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(0.005, (NumberFormat)df5));
        units.add((TickUnit)new NumberTickUnit(0.05, (NumberFormat)df6));
        units.add((TickUnit)new NumberTickUnit(0.5, (NumberFormat)df7));
        units.add((TickUnit)new NumberTickUnit(5.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(50.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(500.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(50000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(500000.0, (NumberFormat)df8));
        units.add((TickUnit)new NumberTickUnit(5000000.0, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(5.0E7, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(5.0E8, (NumberFormat)df9));
        units.add((TickUnit)new NumberTickUnit(5.0E9, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(5.0E10, (NumberFormat)df10));
        units.add((TickUnit)new NumberTickUnit(5.0E11, (NumberFormat)df10));
        return units;
    }

    public String getTitle() {
        return this.title;
    }

    public List<NeoloadCurvesXPathStat> getCurves() {
        return this.curves;
    }

    public String getyLabel() {
        return this.yLabel;
    }

    public void addBuild(int buildNumber, Document document) {
        for (NeoloadCurvesXPathStat neoloadCurvesXPathStat : this.curves) {
            neoloadCurvesXPathStat.addBuild(buildNumber, document);
        }
    }

    private CategoryDataset getDataSet() {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (NeoloadCurvesXPathStat curve : this.curves) {
            for (Map.Entry<Integer, Float> entry : curve.getBuildToValue().entrySet()) {
                ds.addValue((Number)entry.getValue(), (Comparable)((Object)curve.getLegend()), (Comparable)((Object)("#" + entry.getKey())));
            }
        }
        return ds;
    }

    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)this.yLabel, (CategoryDataset)this.getDataSet(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        TextTitle textTitle = this.title != null && !this.title.trim().equals("") ? new TextTitle(this.title, new Font("Helvetica", 1, 16)) : new TextTitle(" ", new Font("Helvetica", 1, 16));
        chart.setTitle(textTitle);
        if (chart.getLegend() != null) {
            chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        }
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis axis = plot.getDomainAxis();
        axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NeoloadGraphXPathStat.createStandardTickUnits());
        int i = 0;
        for (NeoloadCurvesXPathStat curve : this.curves) {
            plot.getRenderer().setSeriesPaint(i, (Paint)curve.getColor());
        }
        plot.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    int numberOfBuilds() {
        int nbOfBuild = 0;
        for (NeoloadCurvesXPathStat curve : this.curves) {
            nbOfBuild = Math.max(curve.getBuildsNumber(), nbOfBuild);
        }
        return nbOfBuild;
    }

    int computeWidth() {
        return Math.max(500, this.numberOfBuilds() * 15);
    }

    public void writePng(File file) throws IOException {
        int width = this.computeWidth();
        JFreeChart chart = this.createChart();
        int height = this.computeHeight(chart, width);
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)width, (int)height);
    }

    private int computeHeight(JFreeChart chart, int width) {
        return this.computeLegendHeight(chart, width) + 200;
    }

    private int computeLegendHeight(JFreeChart chart, int imageWidth) {
        if (chart.getSubtitleCount() == 0) {
            return 0;
        }
        BufferedImage image = new BufferedImage(imageWidth, 200, 2);
        Graphics2D g2 = image.createGraphics();
        RectangleConstraint constraint = new RectangleConstraint((double)imageWidth, new Range(0.0, (double)imageWidth), LengthConstraintType.RANGE, 0.0, null, LengthConstraintType.NONE);
        int height = 0;
        for (int i = 0; i < chart.getSubtitleCount(); ++i) {
            Title subtitle = chart.getSubtitle(i);
            Size2D arrange = subtitle.arrange(g2, constraint);
            height = (int)((double)height + arrange.getHeight());
        }
        return height;
    }
}

