/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.steps;

import com.google.inject.Inject;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.neoload.integration.NeoBuildAction;
import org.jenkinsci.plugins.neoload.integration.steps.NeoloadRunStep;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class NeoloadRunStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient Run build;
    @StepContextParameter
    private transient FilePath ws;
    @StepContextParameter
    private transient Launcher launcher;
    @Inject
    private transient NeoloadRunStep step;

    protected Void run() throws Exception {
        this.listener.getLogger().println("Running NeoLoad with executable : " + this.step.getExecutable());
        ServerInfo projectServerFilled = this.step.getSharedProjectServer();
        if (this.step.getProjectType() == null) {
            if (this.step.getLocalProjectFile() != null && !"".equals(this.step.getLocalProjectFile())) {
                this.step.setProjectType("projectTypeLocal");
            } else if (projectServerFilled != null) {
                this.step.setProjectType("projectTypeShared");
            } else {
                this.listener.getLogger().println("No project has be defined (shared or local). The execution can not run");
            }
        }
        NeoBuildAction neoBuildAction = new NeoBuildAction(this.step);
        if (this.launcher == null) {
            this.launcher = this.ws.createLauncher(this.listener);
        }
        neoBuildAction.perform(this.build, this.ws, this.launcher, this.listener);
        return null;
    }
}

