/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration;

import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.neoload.integration.NeoResultsAction;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoLoadPluginOptions;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ProjectSpecificAction
implements ProminentProjectAction,
SimpleBuildStep.LastBuildAction {
    private final AbstractProject<?, ?> project;
    private final Run<?, ?> run;
    private final NeoLoadPluginOptions npo;
    private final File picturesFolder;

    public ProjectSpecificAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.npo = PluginUtils.getPluginOptions(project);
        this.picturesFolder = PluginUtils.getPicturesFolder(project);
        this.run = null;
    }

    public ProjectSpecificAction(Run<?, ?> run) {
        this.run = run;
        this.npo = PluginUtils.getPluginOptions(run.getParent());
        this.picturesFolder = PluginUtils.getPicturesFolder(run.getParent());
        this.project = null;
    }

    public String getIconFileName() {
        if (this.project != null) {
            return this.hasGraph() ? "/plugin/neoload-jenkins-plugin/images/refresh.png" : null;
        }
        return null;
    }

    public String getDisplayName() {
        if (this.project != null) {
            return this.hasGraph() ? "Refresh NeoLoad trends" : null;
        }
        return null;
    }

    private boolean hasGraph() {
        if (this.npo == null) {
            return false;
        }
        if (this.picturesFolder != null && this.picturesFolder.exists() && this.picturesFolder.isDirectory() && this.picturesFolder.list().length > 0) {
            return true;
        }
        List<GraphOptionsInfo> graphOptionsInfo = this.npo.getGraphOptionsInfo();
        return graphOptionsInfo != null && !graphOptionsInfo.isEmpty() || this.npo.isShowTrendAverageResponse() || this.npo.isShowTrendErrorRate();
    }

    public String getUrlName() {
        return "neoload";
    }

    public void scanBuildReport() {
        if (this.npo == null || !this.npo.isScanAllBuilds()) {
            return;
        }
        for (Run run : this.project.getBuilds()) {
            if (run.getAction(NeoResultsAction.class) != null || !(run instanceof AbstractBuild)) continue;
            run.addAction((Action)new NeoResultsAction((AbstractBuild)run, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChartsName() {
        this.scanBuildReport();
        if (this.project != null && PluginUtils.GRAPH_LOCK.tryLock((Job)this.project) || this.run != null && PluginUtils.GRAPH_LOCK.tryLock(this.run.getParent())) {
            try {
                Object[] files;
                ArrayList<String> chartName = new ArrayList<String>();
                if (this.picturesFolder.isDirectory() && (files = this.picturesFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.toString().toLowerCase().endsWith(".png");
                    }
                })) != null) {
                    Arrays.sort(files);
                    for (Object pictureFile : files) {
                        chartName.add("neoload/img/" + ((File)pictureFile).getName());
                    }
                }
                ArrayList<String> arrayList = chartName;
                return arrayList;
            }
            finally {
                if (this.project != null) {
                    PluginUtils.GRAPH_LOCK.unlock((Job)this.project);
                } else {
                    PluginUtils.GRAPH_LOCK.unlock(this.run.getParent());
                }
            }
        }
        return Lists.newArrayList((Object[])new String[]{Jenkins.getInstance().getRootUrl() + Jenkins.RESOURCE_PATH + "/images/spinner.gif"});
    }

    public void buildGraphs() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PluginUtils.buildGraph(ProjectSpecificAction.this.picturesFolder, ProjectSpecificAction.this.npo, ProjectSpecificAction.this.project);
            }
        }).start();
    }

    public List<GraphOptionsInfo> getGraphOptionsInfo() {
        return this.npo.getGraphOptionsInfo();
    }

    public boolean isNeoloadBuildJob() {
        return this.npo != null;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public void doChecklock(StaplerRequest req, StaplerResponse rsp) throws IOException {
        ServletOutputStream outputStream = rsp.getOutputStream();
        String resp = PluginUtils.GRAPH_LOCK.isLocked((Job)this.project) ? "locked" : "free";
        outputStream.println(resp);
        outputStream.close();
    }

    public Png getImg(String imageName) {
        return new Png(new File(this.picturesFolder, imageName));
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<ProjectSpecificAction> projectActions = new ArrayList<ProjectSpecificAction>();
        projectActions.add(this);
        return projectActions;
    }

    public static class Png {
        private final File file;

        Png(File file) {
            this.file = file;
        }

        public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
            rsp.setContentType("image/png");
            ServletOutputStream os = rsp.getOutputStream();
            IOUtils.copy((File)this.file, (OutputStream)os);
            os.close();
        }
    }
}

