/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.ChannelClosedException;
import hudson.tasks.BatchFile;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Messages;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class NeoloadRunLauncher
extends CommandInterpreter {
    private static final Logger LOGGER = Logger.getLogger(NeoloadRunLauncher.class.getName());
    private final MyInterpreter interpreter;

    public NeoloadRunLauncher(String command, Launcher launcher) {
        super(command);
        this.interpreter = launcher.isUnix() ? new ShellMine(command) : new BatchFileMine(command);
    }

    public String[] buildCommandLine(FilePath script) {
        return this.interpreter.buildCommandLine(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(Run<?, ?> build, FilePath ws, Launcher launcher, TaskListener listener) throws InterruptedException {
        LOGGER.log(Level.FINEST, "Executing command: " + this.command);
        FilePath script = null;
        int r = -1;
        try {
            try {
                script = this.createScriptFile(ws);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToProduceScript()));
                boolean bl = false;
                try {
                    if (script != null) {
                        script.delete();
                    }
                }
                catch (IOException e2) {
                    if (r == -1 && e2.getCause() instanceof ChannelClosedException) {
                        LOGGER.log(Level.FINE, "Script deletion failed", e2);
                    } else {
                        Util.displayIOException((IOException)e2, (TaskListener)listener);
                        e2.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
                }
                return bl;
            }
            try {
                EnvVars envVars = build.getEnvironment(listener);
                ws.mkdirs();
                r = this.join(launcher.launch().cmds(this.buildCommandLine(script)).envs((Map)envVars).stdout(listener).pwd(ws).start());
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_CommandFailed()));
            }
            catch (Throwable th) {
                th.printStackTrace(listener.fatalError(Messages.CommandInterpreter_CommandFailed()));
            }
            boolean bl = r == 0;
            return bl;
        }
        finally {
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                if (r == -1 && e.getCause() instanceof ChannelClosedException) {
                    LOGGER.log(Level.FINE, "Script deletion failed", e);
                } else {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
            }
        }
    }

    protected String getContents() {
        return this.interpreter.getContents();
    }

    protected String getFileExtension() {
        return this.interpreter.getFileExtension();
    }

    public static class ShellMine
    extends Shell
    implements MyInterpreter {
        public ShellMine(String command) {
            super(command);
        }

        @Override
        public String getContents() {
            return super.getContents();
        }

        @Override
        public String getFileExtension() {
            return super.getFileExtension();
        }

        @Extension
        public static class DescriptorImpl
        extends Shell.DescriptorImpl {
        }
    }

    public static class BatchFileMine
    extends BatchFile
    implements MyInterpreter {
        public BatchFileMine(String command) {
            super(command);
        }

        @Override
        public String getContents() {
            return super.getContents();
        }

        @Override
        public String getFileExtension() {
            return super.getFileExtension();
        }

        @Extension
        public static class DescriptorImpl
        extends BuildStepDescriptor<Builder> {
            public String getHelpFile() {
                return "/help/project-config/batch.html";
            }

            public String getDisplayName() {
                return Messages.BatchFile_DisplayName();
            }

            public Builder newInstance(StaplerRequest req, JSONObject data) {
                return new BatchFile(data.getString("command"));
            }

            public boolean isApplicable(Class<? extends AbstractProject> jobType) {
                return true;
            }
        }
    }

    static interface MyInterpreter {
        public String getContents();

        public String getFileExtension();

        public String[] buildCommandLine(FilePath var1);
    }
}

