/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import java.util.logging.Logger;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;

public class NeoResultsAction
implements Action {
    public static final String TAG_HTML_GENERATED_BY_NEOLOAD = "#HTML Report Generated by NeoLoad#";
    static final String COMMENT_APPLIED_STYLE = "<!-- NeoLoad Jenkins plugin applied style -->";
    static final String COMMENT_APPLIED_FOR_BUILD_PART1 = "<!-- PROCESSED DURING BUILD: ";
    static final String COMMENT_APPLIED_FOR_BUILD_PART2 = " -->";
    private static final String COMMENT_CSS_APPLIED_STYLE = "/* NeoLoad Jenkins plugin applied style */";
    private static final Logger LOGGER = Logger.getLogger(NeoResultsAction.class.getName());
    private final AbstractBuild<?, ?> build;
    private final Run<?, ?> run;
    private final String storedXmlReportPath;
    private final String storedHtmlReportPath;
    private Run.Artifact reportHTMLArtifactCache = null;

    @Deprecated
    NeoResultsAction(AbstractBuild<?, ?> target, String xmlReportPath, String htmlReportPath) {
        this.build = target;
        this.run = null;
        this.storedXmlReportPath = xmlReportPath;
        this.storedHtmlReportPath = htmlReportPath;
    }

    public NeoResultsAction(Run<?, ?> run, String xmlReportPath, String htmlReportPath) {
        this.run = run;
        this.build = null;
        this.storedXmlReportPath = xmlReportPath;
        this.storedHtmlReportPath = htmlReportPath;
    }

    private Run.Artifact findHtmlReportArtifact() {
        if (this.build != null) {
            return PluginUtils.findArtifact(PluginUtils.getHTMLReportPaths(this.build, this.getStoredHtmlReportPath()), this.build);
        }
        if (this.run != null) {
            return PluginUtils.findArtifact(PluginUtils.getHTMLReportPaths(this.run, this.getStoredHtmlReportPath()), this.run);
        }
        return null;
    }

    public Run<?, ?> getBuild() {
        if (this.build != null) {
            return this.build;
        }
        return this.run;
    }

    private Run.Artifact getReportArtifact() {
        if (this.reportHTMLArtifactCache == null) {
            this.reportHTMLArtifactCache = this.findHtmlReportArtifact();
        }
        return this.reportHTMLArtifactCache;
    }

    public String getDisplayName() {
        if (this.getReportArtifact() == null) {
            return null;
        }
        return "Performance Result";
    }

    public String getIconFileName() {
        if (this.getReportArtifact() == null) {
            return null;
        }
        return "/plugin/neoload-jenkins-plugin/images/logo48.png";
    }

    public String getUrlName() {
        if (this.getReportArtifact() == null) {
            return null;
        }
        return "neoload-report";
    }

    public String getHtmlReportFilePath() {
        if (this.getReportArtifact() == null) {
            return null;
        }
        return this.getReportArtifact().getHref();
    }

    public String getStoredXmlReportPath() {
        return this.storedXmlReportPath;
    }

    public String getStoredHtmlReportPath() {
        return this.storedHtmlReportPath;
    }
}

