/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NaginatorPublisher;
import com.chikli.hudson.plugin.naginator.NaginatorScheduleAction;
import com.chikli.hudson.plugin.naginator.NoChildStrategy;
import com.chikli.hudson.plugin.naginator.RegexpForMatrixStrategy;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public class NaginatorPublisherScheduleAction
extends NaginatorScheduleAction {
    private static final Logger LOGGER = Logger.getLogger(NaginatorPublisherScheduleAction.class.getName());
    private final String regexpForRerun;
    private final boolean rerunIfUnstable;
    private final boolean checkRegexp;
    private transient Boolean regexpForMatrixParent;
    private RegexpForMatrixStrategy regexpForMatrixStrategy;
    private final NoChildStrategy noChildStrategy;

    public NaginatorPublisherScheduleAction(NaginatorPublisher publisher) {
        super(publisher.getMaxSchedule(), publisher.getDelay(), publisher.isRerunMatrixPart());
        this.regexpForRerun = publisher.getRegexpForRerun();
        this.rerunIfUnstable = publisher.isRerunIfUnstable();
        this.checkRegexp = publisher.isCheckRegexp();
        this.regexpForMatrixStrategy = publisher.getRegexpForMatrixStrategy();
        this.noChildStrategy = publisher.getNoChildStrategy();
    }

    public Object readResolve() {
        if (this.regexpForMatrixStrategy == null) {
            if (this.regexpForMatrixParent != null) {
                this.regexpForMatrixStrategy = this.regexpForMatrixParent != false ? RegexpForMatrixStrategy.TestParent : RegexpForMatrixStrategy.TestChildrenRetriggerMatched;
                this.regexpForMatrixParent = null;
            } else {
                this.regexpForMatrixStrategy = RegexpForMatrixStrategy.getDefault();
            }
        }
        return this;
    }

    @CheckForNull
    public String getRegexpForRerun() {
        return this.regexpForRerun;
    }

    public boolean isRerunIfUnstable() {
        return this.rerunIfUnstable;
    }

    public boolean isCheckRegexp() {
        return this.checkRegexp;
    }

    @Deprecated
    public boolean isRegexpForMatrixParent() {
        return this.getRegexpForMatrixStrategy() == RegexpForMatrixStrategy.TestParent;
    }

    @Nonnull
    public RegexpForMatrixStrategy getRegexpForMatrixStrategy() {
        return this.regexpForMatrixStrategy;
    }

    @Override
    public boolean shouldSchedule(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener, int retryCount) {
        if (!this.checkCommonScheduleThreshold(run)) {
            return false;
        }
        if (this.isCheckRegexp() && (!(run instanceof MatrixBuild) || this.getRegexpForMatrixStrategy() == RegexpForMatrixStrategy.TestParent)) {
            LOGGER.log(Level.FINEST, "Got checkRegexp == true");
            if (!this.testRegexp(run, listener)) {
                return false;
            }
        } else if (this.isCheckRegexp() && run instanceof MatrixBuild && this.getRegexpForMatrixStrategy() == RegexpForMatrixStrategy.TestChildrenRetriggerAll && !this.testRegexpForFailedChildren((MatrixBuild)run, listener)) {
            return false;
        }
        return super.shouldSchedule(run, listener, retryCount);
    }

    private boolean testRegexpForFailedChildren(@Nonnull MatrixBuild run, @Nonnull TaskListener listener) {
        for (MatrixRun r : run.getExactRuns()) {
            if (!this.checkCommonScheduleThreshold((Run<?, ?>)r) || !this.testRegexp((Run<?, ?>)r, listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldScheduleForMatrixRun(@Nonnull MatrixRun run, @Nonnull TaskListener listener) {
        if (!this.checkCommonScheduleThreshold((Run<?, ?>)run)) {
            return false;
        }
        if (this.isCheckRegexp() && this.getRegexpForMatrixStrategy() == RegexpForMatrixStrategy.TestChildrenRetriggerMatched) {
            LOGGER.log(Level.FINEST, "Got isRerunMatrixPart == true");
            if (!this.testRegexp((Run<?, ?>)run, listener)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkCommonScheduleThreshold(@Nonnull Run<?, ?> run) {
        if (run.getResult() == Result.SUCCESS || run.getResult() == Result.ABORTED) {
            return false;
        }
        return this.isRerunIfUnstable() || run.getResult() != Result.UNSTABLE;
    }

    private boolean testRegexp(@Nonnull Run<?, ?> run, TaskListener listener) {
        String regexpForRerun = this.getRegexpForRerun();
        if (regexpForRerun != null && !regexpForRerun.equals("")) {
            LOGGER.log(Level.FINEST, "regexpForRerun - {0}", regexpForRerun);
            try {
                if (!this.parseLog(run.getLogFile(), run.getCharset(), regexpForRerun)) {
                    LOGGER.log(Level.FINEST, "regexp not in logfile");
                    return false;
                }
            }
            catch (IOException e) {
                e.printStackTrace(listener.error("error while parsing logs for naginator - forcing rebuild."));
            }
        }
        return true;
    }

    private long getRegexpTimeoutMs() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return 30000L;
        }
        NaginatorPublisher.DescriptorImpl d = (NaginatorPublisher.DescriptorImpl)j.getDescriptor(NaginatorPublisher.class);
        if (d == null) {
            return 30000L;
        }
        return d.getRegexpTimeoutMs();
    }

    private boolean parseLog(final File logFile, final Charset charset, final @Nonnull String regexp) throws IOException {
        long timeout = this.getRegexpTimeoutMs();
        FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return NaginatorPublisherScheduleAction.this.parseLogImpl(logFile, charset, regexp);
            }
        });
        Thread t = new Thread(task);
        t.start();
        try {
            return task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOGGER.log(Level.WARNING, String.format("Aborted regexp '%s' for too long execution time ( > %d ms).", regexp, timeout));
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, String.format("Aborted regexp '%s'", regexp), e);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, String.format("Aborted regexp '%s'", regexp), e);
        }
        if (t.isAlive()) {
            t.interrupt();
        }
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseLogImpl(File logFile, Charset charset, @Nonnull String regexp) throws IOException {
        Pattern pattern = Pattern.compile(regexp);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), charset));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(new InterruptibleCharSequence(line));
                if (!matcher.find()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    @Nonnull
    public NoChildStrategy getNoChildStrategy() {
        return this.noChildStrategy != null ? this.noChildStrategy : NoChildStrategy.getDefault();
    }

    private static class InterruptibleCharSequence
    implements CharSequence {
        private final CharSequence wrapped;

        public InterruptibleCharSequence(CharSequence wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int length() {
            return this.wrapped.length();
        }

        @Override
        public char charAt(int index) {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return this.wrapped.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.wrapped.subSequence(start, end);
        }
    }
}

