/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Run;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NaginatorCause
extends Cause {
    private final String summary;
    private final Integer sourceBuildNumber;
    private transient Job project;

    public NaginatorCause(AbstractBuild<?, ?> build) {
        this.summary = build.getDisplayName();
        this.sourceBuildNumber = build.getNumber();
    }

    public String getShortDescription() {
        return Messages.NaginatorCause_Description(this.summary);
    }

    public void onAddedTo(AbstractBuild build) {
        this.project = build.getParent();
    }

    public void onLoad(@Nonnull AbstractBuild<?, ?> build) {
        this.project = build.getParent();
    }

    public String getSummary() {
        return this.summary;
    }

    public Job getProject() {
        return this.project;
    }

    public String getJobUrl() {
        return this.project.getUrl();
    }

    public Integer getSourceBuildNumber() {
        return this.sourceBuildNumber;
    }

    @CheckForNull
    public Run<?, ?> getSourceBuild() {
        if (this.getSourceBuildNumber() == null) {
            return null;
        }
        return this.getProject().getBuildByNumber(this.getSourceBuildNumber().intValue());
    }
}

