/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.multiplescms;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.multiplescms.MultiSCMChangeLogSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MultiSCMChangeLogParser
extends ChangeLogParser {
    public static final String ROOT_XML_TAG = "multi-scm-log";
    public static final String SUB_LOG_TAG = "sub-log";
    private final Map<String, ChangeLogParser> scmLogParsers = new HashMap<String, ChangeLogParser>();
    private final Map<String, String> scmDisplayNames = new HashMap<String, String>();
    private final Map<String, RepositoryBrowser<?>> scmRepositoryBrowsers = new HashMap();

    public MultiSCMChangeLogParser(List<SCM> scms) {
        for (SCM scm : scms) {
            String key = scm.getKey();
            if (this.scmLogParsers.containsKey(key)) continue;
            this.scmLogParsers.put(key, scm.createChangeLogParser());
            String displayName = scm.getDescriptor().getDisplayName();
            if (key != displayName) {
                displayName = String.format("%s (%s)", displayName, key);
            }
            this.scmDisplayNames.put(key, displayName);
            this.scmRepositoryBrowsers.put(key, scm.getBrowser());
        }
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
        SAXParser parser;
        if (this.scmLogParsers == null) {
            return ChangeLogSet.createEmpty((AbstractBuild)build);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Could not create parser", e);
        }
        LogSplitter splitter = new LogSplitter(build, changelogFile.getPath() + ".temp2");
        parser.parse(changelogFile, (DefaultHandler)splitter);
        return splitter.getChangeLogSets();
    }

    private class LogSplitter
    extends DefaultHandler {
        private final MultiSCMChangeLogSet changeLogs;
        private final AbstractBuild build;
        private final File tempFile;
        private String scmClass;
        private StringBuffer buffer;

        public LogSplitter(AbstractBuild build, String tempFilePath) {
            this.changeLogs = new MultiSCMChangeLogSet(build);
            this.tempFile = new File(tempFilePath);
            this.build = build;
        }

        @Override
        public void characters(char[] data, int startIndex, int length) throws SAXException {
            if (this.buffer != null) {
                while (length > 0 && Character.isWhitespace(data[startIndex])) {
                    ++startIndex;
                    --length;
                }
                for (int i = 0; i < length; ++i) {
                    this.buffer.append(data[startIndex + i]);
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (qName.compareTo(MultiSCMChangeLogParser.SUB_LOG_TAG) == 0) {
                this.scmClass = attrs.getValue("scm");
                this.buffer = new StringBuffer();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.compareTo(MultiSCMChangeLogParser.SUB_LOG_TAG) == 0) {
                try {
                    OutputStreamWriter outputStream = new OutputStreamWriter(new FileOutputStream(this.tempFile));
                    String data = StringEscapeUtils.unescapeXml((String)this.buffer.toString());
                    outputStream.write(data);
                    outputStream.close();
                    this.buffer = null;
                    ChangeLogParser parser = (ChangeLogParser)MultiSCMChangeLogParser.this.scmLogParsers.get(this.scmClass);
                    RepositoryBrowser browser = null;
                    if (MultiSCMChangeLogParser.this.scmRepositoryBrowsers != null) {
                        browser = (RepositoryBrowser)MultiSCMChangeLogParser.this.scmRepositoryBrowsers.get(this.scmClass);
                    }
                    if (parser != null) {
                        ChangeLogSet cls = browser != null ? parser.parse((Run)this.build, browser, this.tempFile) : parser.parse(this.build, this.tempFile);
                        this.changeLogs.add(this.scmClass, (String)MultiSCMChangeLogParser.this.scmDisplayNames.get(this.scmClass), (ChangeLogSet<? extends ChangeLogSet.Entry>)cls);
                    }
                }
                catch (RuntimeException e) {
                    throw new SAXException("could not parse changelog file", e);
                }
                catch (FileNotFoundException e) {
                    throw new SAXException("could not create temp changelog file", e);
                }
                catch (IOException e) {
                    throw new SAXException("could not close temp changelog file", e);
                }
            }
        }

        public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeLogSets() {
            return this.changeLogs;
        }
    }
}

