/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mongodb;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.mongodb.Messages;
import org.jenkinsci.plugins.mongodb.MongoBuildWrapper;
import org.jenkinsci.plugins.mongodb.MongoDBInstaller;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBInstallation
extends ToolInstallation
implements EnvironmentSpecific<MongoDBInstallation>,
NodeSpecific<MongoDBInstallation> {
    private String parameters;
    private int startTimeout;

    @DataBoundConstructor
    public MongoDBInstallation(String name, String home, List<? extends ToolProperty<?>> properties, String parameters, int startTimeout) {
        super(name, home, properties);
        this.parameters = parameters;
        this.startTimeout = startTimeout;
    }

    public MongoDBInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new MongoDBInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList(), this.parameters, this.startTimeout);
    }

    public MongoDBInstallation forEnvironment(EnvVars environment) {
        return new MongoDBInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList(), this.parameters, this.startTimeout);
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public int getStartTimeout() {
        return this.startTimeout;
    }

    public void setStartTimeout(int startTimeout) {
        this.startTimeout = startTimeout;
    }

    public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File executable;
                File homeDir = new File(MongoDBInstallation.this.getHome());
                if (!homeDir.exists() || !homeDir.isDirectory()) {
                    throw new FileNotFoundException(String.format("No such directory. [%s]", homeDir));
                }
                File r = new File(homeDir, MongoDBInstallation.this.getExeFile());
                File file = executable = r.exists() ? r : MongoDBInstallation.this.findExecutable(homeDir);
                if (executable == null) {
                    throw new FileNotFoundException(String.format("[%s] is not MongoDB home directory.", homeDir));
                }
                return executable.getPath();
            }
        });
    }

    protected File findExecutable(File parent) {
        for (File child : parent.listFiles()) {
            File r;
            if (child.isFile() && (parent.getName() + "/" + child.getName()).equals(this.getExeFile())) {
                return child;
            }
            if (!child.isDirectory() || (r = this.findExecutable(child)) == null) continue;
            return this.findExecutable(child);
        }
        return null;
    }

    protected String getExeFile() {
        return Functions.isWindows() ? "bin/mongod.exe" : "bin/mongod";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<MongoDBInstallation> {
        public String getDisplayName() {
            return "MongoDB";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new MongoDBInstaller(null));
        }

        public MongoDBInstallation[] getInstallations() {
            return ((MongoBuildWrapper.DescriptorImpl)Hudson.getInstance().getDescriptorByType(MongoBuildWrapper.DescriptorImpl.class)).getInstallations();
        }

        public void setInstallations(MongoDBInstallation ... installations) {
            ((MongoBuildWrapper.DescriptorImpl)Hudson.getInstance().getDescriptorByType(MongoBuildWrapper.DescriptorImpl.class)).setInstallations(installations);
        }

        public static FormValidation doCheckName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public static FormValidation doCheckStartTimeout(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            try {
                int timeout = Integer.parseInt(value);
                return timeout >= 0 ? FormValidation.ok() : FormValidation.error((String)Messages.MongoDB_InvalidStartTimeout());
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.MongoDB_InvalidStartTimeout());
            }
        }

        public static FormValidation doCheckHome(@QueryParameter File value) {
            if (StringUtils.isEmpty((String)value.getPath())) {
                return FormValidation.ok();
            }
            if (!value.isDirectory()) {
                return FormValidation.error((String)Messages.MongoDB_NotDirectory());
            }
            File mongod = new File(value, "bin/mongod");
            if (!mongod.exists()) {
                return FormValidation.error((String)Messages.MongoDB_NotMongoDBDirectory(value));
            }
            return FormValidation.ok();
        }
    }
}

