/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mongodb;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.mongodb.Messages;
import org.jenkinsci.plugins.mongodb.MongoDBInstallation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MongoBuildWrapper
extends BuildWrapper {
    private String mongodbName;
    private String dbpath;
    private String port;
    private String parameters;
    private int startTimeout;

    public MongoBuildWrapper() {
    }

    @DataBoundConstructor
    public MongoBuildWrapper(String mongodbName, String dbpath, String port, String parameters, int startTimeout) {
        this.mongodbName = mongodbName;
        this.dbpath = dbpath;
        this.port = port;
        this.startTimeout = startTimeout;
        this.parameters = parameters;
    }

    public MongoDBInstallation getMongoDB() {
        for (MongoDBInstallation i : ((DescriptorImpl)this.getDescriptor()).getInstallations()) {
            if (this.mongodbName == null || !i.getName().equals(this.mongodbName)) continue;
            return i;
        }
        return null;
    }

    public String getMongodbName() {
        return this.mongodbName;
    }

    public String getDbpath() {
        return this.dbpath;
    }

    public String getPort() {
        return this.port;
    }

    public void setMongodbName(String mongodbName) {
        this.mongodbName = mongodbName;
    }

    public void setDbpath(String dbpath) {
        this.dbpath = dbpath;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public int getStartTimeout() {
        return this.startTimeout;
    }

    public void setStartTimeout(int startTimeout) {
        this.startTimeout = startTimeout;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        MongoDBInstallation mongo = this.getMongoDB().forNode(Computer.currentComputer().getNode(), (TaskListener)listener).forEnvironment(env);
        ArgumentListBuilder args = new ArgumentListBuilder().add(mongo.getExecutable(launcher));
        String globalParameters = mongo.getParameters();
        int globalStartTimeout = mongo.getStartTimeout();
        FilePath dbpathFile = this.setupCmd(launcher, args, build.getWorkspace(), false, globalParameters);
        dbpathFile.deleteRecursive();
        dbpathFile.mkdirs();
        return this.launch(launcher, args, listener, globalStartTimeout);
    }

    protected BuildWrapper.Environment launch(Launcher launcher, ArgumentListBuilder args, BuildListener listener, int globalStartTimeout) throws IOException, InterruptedException {
        Launcher.ProcStarter procStarter = launcher.launch().cmds(args);
        MongoBuildWrapper.log(listener, "Executing mongodb start command: " + procStarter.cmds());
        final Proc proc = procStarter.start();
        try {
            Boolean startResult;
            int effectiveTimeout = globalStartTimeout;
            if (this.startTimeout > 0) {
                effectiveTimeout = this.startTimeout;
            }
            if (!(startResult = (Boolean)launcher.getChannel().call((Callable)new WaitForStartCommand(listener, this.port, effectiveTimeout))).booleanValue()) {
                MongoBuildWrapper.log(listener, "ERROR: Filed to start mongodb");
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
            return null;
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (proc.isAlive()) {
                    MongoBuildWrapper.log(listener, "Killing mongodb process...");
                    proc.kill();
                } else {
                    MongoBuildWrapper.log(listener, "Will not kill mongodb process as it is already dead.");
                }
                return super.tearDown(build, listener);
            }
        };
    }

    protected FilePath setupCmd(Launcher launcher, ArgumentListBuilder args, FilePath workspace, boolean fork, String globalParameters) throws IOException, InterruptedException {
        FilePath dbpathFile;
        if (fork) {
            args.add("--fork");
        }
        args.add("--logpath").add(workspace.child("mongodb.log").getRemote());
        if (StringUtils.isEmpty((String)this.dbpath)) {
            dbpathFile = workspace.child("data").child("db");
        } else {
            dbpathFile = new FilePath(launcher.getChannel(), this.dbpath);
            boolean isAbsolute = (Boolean)dbpathFile.act((FilePath.FileCallable)new IsAbsoluteCheck());
            if (!isAbsolute) {
                dbpathFile = workspace.child(this.dbpath);
            }
        }
        args.add("--dbpath").add(dbpathFile.getRemote());
        if (StringUtils.isNotEmpty((String)this.port)) {
            args.add(new String[]{"--port", this.port});
        }
        String effectiveParameters = globalParameters;
        if (StringUtils.isNotEmpty((String)this.parameters)) {
            effectiveParameters = this.parameters;
        }
        if (StringUtils.isNotEmpty((String)effectiveParameters)) {
            for (String parameter : effectiveParameters.split("--")) {
                if (parameter.trim().indexOf(" ") != -1) {
                    String parameterName = parameter.trim().substring(0, parameter.trim().indexOf(" ")).trim();
                    String parameterValue = parameter.trim().substring(parameter.trim().indexOf(" ")).trim();
                    if (!StringUtils.isNotEmpty((String)parameterName)) continue;
                    args.add(new String[]{"--" + parameterName, parameterValue});
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)parameter.trim())) continue;
                args.add("--" + parameter.trim());
            }
        }
        return dbpathFile;
    }

    private static void log(BuildListener listener, String log) {
        listener.getLogger().println(String.format("[MongoDB] %s", log));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsAbsoluteCheck
    implements FilePath.FileCallable<Boolean> {
        private IsAbsoluteCheck() {
        }

        public Boolean invoke(File f, VirtualChannel channel) {
            return f.isAbsolute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private volatile MongoDBInstallation[] installations = new MongoDBInstallation[0];

        public DescriptorImpl() {
            super(MongoBuildWrapper.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "MongoDB";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (BuildWrapper)req.bindJSON(this.clazz, formData);
        }

        public MongoDBInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(MongoDBInstallation[] installations) {
            this.installations = installations;
            this.save();
        }

        public static FormValidation doCheckStartTimeout(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            try {
                int timeout = Integer.parseInt(value);
                return timeout >= 0 ? FormValidation.ok() : FormValidation.error((String)Messages.MongoDB_InvalidStartTimeout());
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.MongoDB_InvalidStartTimeout());
            }
        }

        public static FormValidation doCheckPort(@QueryParameter String value) {
            return DescriptorImpl.isPortNumber(value) ? FormValidation.ok() : FormValidation.error((String)Messages.MongoDB_InvalidPortNumber());
        }

        public static FormValidation doCheckDbpath(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            File file = new File(value);
            if (!file.isDirectory()) {
                return FormValidation.error((String)Messages.MongoDB_NotDirectory());
            }
            if (file.list().length > 0) {
                return FormValidation.warning((String)Messages.MongoDB_NotEmptyDirectory());
            }
            return FormValidation.ok();
        }

        protected static boolean isPortNumber(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return true;
            }
            if (StringUtils.isNumeric((String)value)) {
                int num = Integer.parseInt(value);
                return num >= 0 && num <= 65535;
            }
            return false;
        }

        public ListBoxModel doFillMongodbNameItems() {
            ListBoxModel m = new ListBoxModel();
            for (MongoDBInstallation inst : this.installations) {
                m.add(inst.getName());
            }
            return m;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WaitForStartCommand
    implements Callable<Boolean, Exception> {
        private BuildListener listener;
        private String port;
        private int startTimeout;
        private long waitStart;

        public WaitForStartCommand(BuildListener listener, String port, int startTimeout) {
            this.listener = listener;
            this.port = StringUtils.defaultIfEmpty((String)port, (String)"27017");
            this.startTimeout = startTimeout == 0 ? 15000 : startTimeout;
        }

        public Boolean call() throws Exception {
            this.waitStart = System.currentTimeMillis();
            return this.waitForStart();
        }

        protected boolean waitForStart() throws Exception {
            MongoBuildWrapper.log(this.listener, "Starting...");
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)new URL("http://localhost:" + this.port).openConnection();
                if (conn.getResponseCode() == 200) {
                    MongoBuildWrapper.log(this.listener, "MongoDB running at:" + new URL("http://localhost:" + this.port).toString());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (MalformedURLException e) {
                throw e;
            }
            catch (ConnectException e) {
                try {
                    if ((long)this.startTimeout >= System.currentTimeMillis() - this.waitStart) {
                        Thread.sleep(1000L);
                        boolean bl = this.waitForStart();
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException e1) {
                    throw e;
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
    }
}

