/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.jenkins;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VariableReplacer {
    private static final Logger log = Logger.getLogger(VariableReplacer.class.getName());
    protected Map<String, String> vars = null;

    public VariableReplacer(Map<String, String> ... vars) {
        if (vars != null) {
            if (vars.length == 1) {
                this.vars = vars[0];
            } else {
                this.vars = new HashMap<String, String>();
                for (Map<String, String> v : vars) {
                    this.vars.putAll(v);
                }
            }
        }
    }

    public String replace(String src) {
        if (this.vars == null || src == null || src.length() == 0) {
            return src;
        }
        String result = src;
        for (String key : this.vars.keySet()) {
            String value = this.vars.get(key);
            String tag = "\\$\\{" + key + "\\}";
            result = result.replaceAll(tag, value);
        }
        if (log.isLoggable(Level.FINE) && !result.equals(src)) {
            log.fine("'" + src + "' replaced as '" + result + "'");
        }
        return result;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }
}

