/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.jenkins;

import fi.meliora.testlab.ext.jenkins.CORSFilter;
import fi.meliora.testlab.ext.jenkins.Sender;
import fi.meliora.testlab.ext.jenkins.VariableReplacer;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class TestlabNotifier
extends Notifier {
    private static final Logger log = Logger.getLogger(TestlabNotifier.class.getName());
    public static final String DEFAULT_COMMENT_TEMPLATE = "Jenkins build: ${BUILD_FULL_DISPLAY_NAME} ${BUILD_RESULT}, ${BUILD_URL} - ${BUILD_STATUS}";
    private String projectKey;
    private String testRunTitle;
    private String comment;
    private String milestone;
    private String testTargetTitle;
    private String testEnvironmentTitle;
    private String tags;
    private String parameters;
    private IssuesSettings issuesSettings;
    private boolean mergeAsSingleIssue;
    private String assignToUser;
    private boolean reopenExisting;
    private AdvancedSettings advancedSettings;
    private String companyId;
    private String apiKey;
    private String testCaseMappingField;
    private Usingonpremise usingonpremise;
    private PublishTap publishTap;
    private boolean tapTestsAsSteps;
    private boolean tapFileNameInIdentifier;
    private boolean tapTestNumberInIdentifier;
    private String tapMappingPrefix;
    public ImportTestCases importTestCases;
    private String importTestCasesRootCategory;
    private PublishRobot publishRobot;
    private String robotOutput;
    private boolean robotCatenateParentKeywords;

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getTestRunTitle() {
        return this.testRunTitle;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public String getTestTargetTitle() {
        return this.testTargetTitle;
    }

    public String getTestEnvironmentTitle() {
        return this.testEnvironmentTitle;
    }

    public String getTags() {
        return this.tags;
    }

    public String getParameters() {
        return this.parameters;
    }

    public IssuesSettings getIssuesSettings() {
        return this.issuesSettings;
    }

    public boolean isMergeAsSingleIssue() {
        return this.mergeAsSingleIssue;
    }

    public String getAssignToUser() {
        return this.assignToUser;
    }

    public boolean isReopenExisting() {
        return this.reopenExisting;
    }

    public AdvancedSettings getAdvancedSettings() {
        return this.advancedSettings;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getTestCaseMappingField() {
        return this.testCaseMappingField;
    }

    public Usingonpremise getUsingonpremise() {
        return this.usingonpremise;
    }

    public PublishTap getPublishTap() {
        return this.publishTap;
    }

    public boolean isTapTestsAsSteps() {
        return this.tapTestsAsSteps;
    }

    public boolean isTapFileNameInIdentifier() {
        return this.tapFileNameInIdentifier;
    }

    public boolean isTapTestNumberInIdentifier() {
        return this.tapTestNumberInIdentifier;
    }

    public String getTapMappingPrefix() {
        return this.tapMappingPrefix;
    }

    public ImportTestCases getImportTestCases() {
        return this.importTestCases;
    }

    public String getImportTestCasesRootCategory() {
        return this.importTestCasesRootCategory;
    }

    public PublishRobot getPublishRobot() {
        return this.publishRobot;
    }

    public String getRobotOutput() {
        return this.robotOutput;
    }

    public boolean isRobotCatenateParentKeywords() {
        return this.robotCatenateParentKeywords;
    }

    @DataBoundConstructor
    public TestlabNotifier(String projectKey, String testRunTitle, String comment, String milestone, String testTargetTitle, String testEnvironmentTitle, String tags, String parameters, IssuesSettings issuesSettings, AdvancedSettings advancedSettings, PublishRobot publishRobot, PublishTap publishTap, ImportTestCases importTestCases) {
        this.projectKey = projectKey;
        this.testRunTitle = testRunTitle;
        this.comment = comment;
        this.milestone = milestone;
        this.testTargetTitle = testTargetTitle;
        this.testEnvironmentTitle = testEnvironmentTitle;
        this.tags = tags;
        this.parameters = parameters;
        this.issuesSettings = issuesSettings;
        if (issuesSettings != null) {
            this.mergeAsSingleIssue = issuesSettings.isMergeAsSingleIssue();
            this.assignToUser = issuesSettings.getAssignToUser();
            this.reopenExisting = issuesSettings.isReopenExisting();
        }
        this.advancedSettings = advancedSettings;
        if (advancedSettings != null) {
            this.companyId = advancedSettings.getCompanyId();
            this.apiKey = advancedSettings.getApiKey();
            this.testCaseMappingField = advancedSettings.getTestCaseMappingField();
            this.usingonpremise = advancedSettings.getUsingonpremise();
        }
        this.publishRobot = publishRobot;
        if (publishRobot != null) {
            this.robotOutput = publishRobot.getRobotOutput();
            this.robotCatenateParentKeywords = publishRobot.isRobotCatenateParentKeywords();
        }
        this.publishTap = publishTap;
        if (publishTap != null) {
            this.tapFileNameInIdentifier = publishTap.isTapFileNameInIdentifier();
            this.tapTestNumberInIdentifier = publishTap.isTapTestNumberInIdentifier();
            this.tapTestsAsSteps = publishTap.isTapTestsAsSteps();
            this.tapMappingPrefix = publishTap.getTapMappingPrefix();
        }
        this.importTestCases = importTestCases;
        if (importTestCases != null) {
            this.importTestCasesRootCategory = importTestCases.getImportTestCasesRootCategory();
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Publishing test results to Testlab project: " + this.projectKey);
        DescriptorImpl d = this.getDescriptor();
        log.fine("perform(): " + (Object)((Object)this) + ", descriptor: " + (Object)((Object)d));
        String runApiKey = TestlabNotifier.isBlank(this.apiKey) ? d.getApiKey() : this.apiKey;
        String runTestCaseMappingField = TestlabNotifier.isBlank(this.testCaseMappingField) ? d.getTestCaseMappingField() : this.testCaseMappingField;
        Usingonpremise uop = this.advancedSettings != null && this.advancedSettings.getUsingonpremise() != null ? this.advancedSettings.getUsingonpremise() : d.getUsingonpremise();
        String runCompanyId = null;
        String runOnpremiseurl = null;
        boolean runUsingonpremise = false;
        if (uop != null && !TestlabNotifier.isBlank(uop.getOnpremiseurl())) {
            runCompanyId = null;
            runUsingonpremise = true;
            runOnpremiseurl = uop.getOnpremiseurl();
            log.fine("using on-premise with url: " + runOnpremiseurl);
        } else {
            runCompanyId = !TestlabNotifier.isBlank(this.companyId) ? this.companyId : d.getCompanyId();
            log.fine("using hosted with company id: " + runCompanyId);
        }
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        HashMap<String, String> additionalKeys = new HashMap<String, String>();
        additionalKeys.put("BUILD_FULL_DISPLAY_NAME", build.getFullDisplayName());
        Run.Summary summary = build.getBuildStatusSummary();
        additionalKeys.put("BUILD_STATUS", summary.message != null ? summary.message : "[No build status available]");
        Result result = build.getResult();
        additionalKeys.put("BUILD_RESULT", result != null ? result.toString() : "[No build result available]");
        VariableReplacer vr = new VariableReplacer(new Map[]{envVars, additionalKeys});
        if (log.isLoggable(Level.FINE)) {
            log.fine("Environment variables:");
            for (String key : vr.getVars().keySet()) {
                log.fine(" " + key + "=" + vr.getVars().get(key));
            }
        }
        String runProjectKey = vr.replace(this.projectKey);
        String runMilestone = vr.replace(this.milestone);
        String runTestRunTitle = vr.replace(this.testRunTitle);
        String runComment = vr.replace(TestlabNotifier.isBlank(this.comment) ? DEFAULT_COMMENT_TEMPLATE : this.comment);
        String runTestTargetTitle = vr.replace(this.testTargetTitle);
        String runTestEnvironmentTitle = vr.replace(this.testEnvironmentTitle);
        String runTags = vr.replace(this.tags);
        String runAssignToUser = vr.replace(this.assignToUser);
        runTestCaseMappingField = vr.replace(runTestCaseMappingField);
        String runParameterVariables = vr.replace(this.parameters);
        HashMap<String, String> runParameters = null;
        if (runParameterVariables != null && runParameterVariables.trim().length() > 0) {
            String[] pars = runParameterVariables.split(",");
            Map<String, String> vars = vr.getVars();
            for (String par : pars) {
                String value = vars.get(par = par.trim());
                if (value == null) {
                    value = vars.get(par.toUpperCase());
                }
                if (value == null) continue;
                if (runParameters == null) {
                    runParameters = new HashMap<String, String>();
                }
                runParameters.put(par, value);
            }
        }
        String runTapMappingPrefix = vr.replace(this.tapMappingPrefix);
        FilePath workspace = build.getWorkspace();
        String abortError = null;
        if (workspace == null) {
            abortError = "The provided build has no workspace.";
        }
        if (!runUsingonpremise && TestlabNotifier.isBlank(runCompanyId)) {
            abortError = "Could not publish results to Testlab: Company ID is not set. Configure it for your job or globally in Jenkins' configuration.";
        }
        if (runUsingonpremise && TestlabNotifier.isBlank(runOnpremiseurl)) {
            abortError = "Could not publish results to Testlab: Testlab URL for on-premise Testlab is not set. Configure it for your job or globally in Jenkins' configuration.";
        }
        if (TestlabNotifier.isBlank(runApiKey)) {
            abortError = "Could not publish results to Testlab: Api Key is not set. Configure it for your job or globally in Jenkins' configuration.";
        }
        if (TestlabNotifier.isBlank(runTestCaseMappingField)) {
            abortError = "Could not publish results to Testlab: Test case mapping field is not set. Configure it for your job or globally in Jenkins' configuration or, if the value contains variable tags make sure they have values.";
        }
        if (TestlabNotifier.isBlank(runProjectKey)) {
            abortError = "Could not publish results to Testlab: Project key is not set. Configure it for your job or, if the value contains variable tags make sure they have values.";
        }
        if (TestlabNotifier.isBlank(runTestRunTitle)) {
            abortError = "Could not publish results to Testlab: Test run title is not set. Configure it for your job or, if the value contains variable tags make sure they have values.";
        }
        if (abortError != null) {
            listener.error(abortError);
            throw new AbortException(abortError);
        }
        Sender.sendResults(workspace, runCompanyId, runUsingonpremise, runOnpremiseurl, runApiKey, runProjectKey, runMilestone, runTestRunTitle, runComment, runTestTargetTitle, runTestEnvironmentTitle, runTags, runParameters, this.issuesSettings != null, this.mergeAsSingleIssue, this.reopenExisting, !TestlabNotifier.isBlank(runAssignToUser) ? runAssignToUser : null, this.publishTap != null, this.tapTestsAsSteps, this.tapFileNameInIdentifier, this.tapTestNumberInIdentifier, runTapMappingPrefix, this.importTestCases != null, this.importTestCasesRootCategory, runTestCaseMappingField, this.publishRobot != null, this.robotOutput, this.robotCatenateParentKeywords, build);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public String toString() {
        return "TestlabNotifier{projectKey='" + this.projectKey + '\'' + ", testRunTitle='" + this.testRunTitle + '\'' + ", comment='" + this.comment + '\'' + ", milestone='" + this.milestone + '\'' + ", testTargetTitle='" + this.testTargetTitle + '\'' + ", testEnvironmentTitle='" + this.testEnvironmentTitle + '\'' + ", tags='" + this.tags + '\'' + ", parameters='" + this.parameters + '\'' + ", issuesSettings=" + this.issuesSettings + ", mergeAsSingleIssue=" + this.mergeAsSingleIssue + ", assignToUser='" + this.assignToUser + '\'' + ", reopenExisting=" + this.reopenExisting + ", advancedSettings=" + this.advancedSettings + ", companyId='" + this.companyId + '\'' + ", apiKey='hidden', testCaseMappingField='" + this.testCaseMappingField + '\'' + ", usingonpremise=" + this.usingonpremise + ", publishTap=" + this.publishTap + ", importTestCases=" + this.importTestCases + ", publishRobot=" + this.publishRobot + '}';
    }

    public static final class ImportTestCases {
        private String importTestCasesRootCategory;

        public String getImportTestCasesRootCategory() {
            return this.importTestCasesRootCategory;
        }

        @DataBoundConstructor
        public ImportTestCases(String importTestCasesRootCategory) {
            this.importTestCasesRootCategory = importTestCasesRootCategory;
        }

        public String toString() {
            return "ImportTestCases{importTestCasesRootCategory='" + this.importTestCasesRootCategory + '\'' + '}';
        }
    }

    public static final class PublishRobot {
        private String robotOutput;
        private boolean robotCatenateParentKeywords;

        public String getRobotOutput() {
            return this.robotOutput;
        }

        public boolean isRobotCatenateParentKeywords() {
            return this.robotCatenateParentKeywords;
        }

        @DataBoundConstructor
        public PublishRobot(String robotOutput, boolean robotCatenateParentKeywords) {
            this.robotOutput = robotOutput;
            this.robotCatenateParentKeywords = robotCatenateParentKeywords;
        }

        public String toString() {
            return "PublishRobot{robotOutput='" + this.robotOutput + '\'' + ", robotCatenateParentKeywords=" + this.robotCatenateParentKeywords + '}';
        }
    }

    public static final class PublishTap {
        private boolean tapTestsAsSteps;
        private boolean tapFileNameInIdentifier;
        private boolean tapTestNumberInIdentifier;
        private String tapMappingPrefix;

        public boolean isTapFileNameInIdentifier() {
            return this.tapFileNameInIdentifier;
        }

        public boolean isTapTestNumberInIdentifier() {
            return this.tapTestNumberInIdentifier;
        }

        public boolean isTapTestsAsSteps() {
            return this.tapTestsAsSteps;
        }

        public String getTapMappingPrefix() {
            return this.tapMappingPrefix;
        }

        @DataBoundConstructor
        public PublishTap(boolean tapFileNameInIdentifier, boolean tapTestNumberInIdentifier, boolean tapTestsAsSteps, String tapMappingPrefix) {
            this.tapFileNameInIdentifier = tapFileNameInIdentifier;
            this.tapTestNumberInIdentifier = tapTestNumberInIdentifier;
            this.tapTestsAsSteps = tapTestsAsSteps;
            this.tapMappingPrefix = tapMappingPrefix;
        }

        public String toString() {
            return "PublishTap{tapFileNameInIdentifier=" + this.tapFileNameInIdentifier + ", tapTestsAsSteps=" + this.tapTestsAsSteps + ", tapTestNumberInIdentifier=" + this.tapTestNumberInIdentifier + ", tapMappingPrefix=" + this.tapMappingPrefix + '}';
        }
    }

    public static final class Cors {
        private String origin;

        public String getOrigin() {
            return this.origin;
        }

        @DataBoundConstructor
        public Cors(String origin) {
            this.origin = origin;
        }

        public String toString() {
            return "Cors{origin='" + this.origin + '\'' + '}';
        }
    }

    public static final class IssuesSettings {
        private boolean mergeAsSingleIssue;
        private String assignToUser;
        private boolean reopenExisting;

        public boolean isMergeAsSingleIssue() {
            return this.mergeAsSingleIssue;
        }

        public String getAssignToUser() {
            return this.assignToUser;
        }

        public boolean isReopenExisting() {
            return this.reopenExisting;
        }

        @DataBoundConstructor
        public IssuesSettings(boolean mergeAsSingleIssue, String assignToUser, boolean reopenExisting) {
            this.mergeAsSingleIssue = mergeAsSingleIssue;
            this.assignToUser = assignToUser;
            this.reopenExisting = reopenExisting;
        }

        public String toString() {
            return "IssuesSettings{mergeAsSingleIssue=" + this.mergeAsSingleIssue + ", assignToUser='" + this.assignToUser + '\'' + ", reopenExisting=" + this.reopenExisting + '}';
        }
    }

    public static final class Usingonpremise {
        private String onpremiseurl;

        public String getOnpremiseurl() {
            return this.onpremiseurl;
        }

        @DataBoundConstructor
        public Usingonpremise(String onpremiseurl) {
            this.onpremiseurl = onpremiseurl;
        }

        public String toString() {
            return "Usingonpremise{onpremiseurl='" + this.onpremiseurl + '\'' + '}';
        }
    }

    public static final class AdvancedSettings {
        private String companyId;
        private String apiKey;
        private String testCaseMappingField;
        private Usingonpremise usingonpremise;

        public String getCompanyId() {
            return this.companyId;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getTestCaseMappingField() {
            return this.testCaseMappingField;
        }

        public Usingonpremise getUsingonpremise() {
            return this.usingonpremise;
        }

        @DataBoundConstructor
        public AdvancedSettings(String companyId, String apiKey, String testCaseMappingField, Usingonpremise usingonpremise) {
            this.companyId = companyId;
            this.apiKey = apiKey;
            this.testCaseMappingField = testCaseMappingField;
            this.usingonpremise = usingonpremise;
        }

        public String toString() {
            return "AdvancedSettings{companyId='" + this.companyId + '\'' + ", apiKey='hidden', testCaseMappingField='" + this.testCaseMappingField + '\'' + ", usingonpremise=" + this.usingonpremise + '}';
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String companyId;
        private String apiKey;
        private String testCaseMappingField;
        private Usingonpremise usingonpremise;
        private Cors cors;
        private CORSFilter CORSFilter;

        public DescriptorImpl() {
            this.load();
            log.fine("load: " + this.companyId + ", api key hidden, " + this.testCaseMappingField + ", " + this.usingonpremise + ", " + this.usingonpremise + ", " + this.cors);
            try {
                this.CORSFilter = new CORSFilter();
                PluginServletFilter.addFilter((Filter)this.CORSFilter);
                log.info("CORSFilter injected.");
            }
            catch (ServletException se) {
                log.warning("Could not inject CORSFilter.");
                se.printStackTrace();
            }
            this.configureCORS();
        }

        public String getDisplayName() {
            return "Publish test results to Testlab";
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.companyId = json.getString("companyId");
            this.apiKey = json.getString("apiKey");
            this.testCaseMappingField = json.getString("testCaseMappingField");
            JSONObject uop = json.getJSONObject("usingonpremise");
            this.usingonpremise = uop != null && !uop.isNullObject() && !uop.isEmpty() ? new Usingonpremise(uop.getString("onpremiseurl")) : null;
            JSONObject c = json.getJSONObject("cors");
            this.cors = c != null && !c.isNullObject() && !c.isEmpty() ? new Cors(c.getString("origin")) : null;
            log.fine("configure: " + this.companyId + ", api key hidden, " + this.testCaseMappingField + ", " + this.usingonpremise + ", " + this.cors);
            this.save();
            this.configureCORS();
            return true;
        }

        protected void configureCORS() {
            this.CORSFilter.setEnabled(this.cors != null && !TestlabNotifier.isBlank(this.cors.getOrigin()));
            if (this.cors != null && this.cors.getOrigin() != null) {
                String[] spl = this.cors.getOrigin().split(",");
                ArrayList<String> origins = new ArrayList<String>();
                for (String o : spl) {
                    origins.add(o.trim());
                }
                this.CORSFilter.setOrigins(origins);
            }
        }

        public String getCompanyId() {
            return this.companyId;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getTestCaseMappingField() {
            return this.testCaseMappingField;
        }

        public Usingonpremise getUsingonpremise() {
            return this.usingonpremise;
        }

        public Cors getCors() {
            return this.cors;
        }

        public String getDefaultCommentTemplate() {
            return TestlabNotifier.DEFAULT_COMMENT_TEMPLATE;
        }

        public String toString() {
            return "DescriptorImpl{companyId='" + this.companyId + '\'' + ", apiKey='hidden', testCaseMappingField='" + this.testCaseMappingField + '\'' + ", usingonpremise=" + this.usingonpremise + ", cors=" + this.cors + '}';
        }
    }
}

