/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.jenkins;

import fi.meliora.testlab.ext.crest.CrestEndpointFactory;
import fi.meliora.testlab.ext.crest.TestResultResource;
import fi.meliora.testlab.ext.jenkins.TestlabNotifier;
import fi.meliora.testlab.ext.rest.model.AddTestResultResponse;
import fi.meliora.testlab.ext.rest.model.KeyValuePair;
import fi.meliora.testlab.ext.rest.model.TestCaseResult;
import fi.meliora.testlab.ext.rest.model.TestCaseResultStep;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tap4j.plugin.TapTestResultAction;
import org.tap4j.plugin.model.TapStreamResult;
import org.tap4j.plugin.model.TapTestResultResult;

public class Sender {
    private static final Logger log = Logger.getLogger(Sender.class.getName());

    public static void sendResults(FilePath workspace, String companyId, boolean usingonpremise, String onpremiseurl, String apiKey, String projectKey, String milestone, String testRunTitle, String comment, String testTargetTitle, String testEnvironmentTitle, String tags, Map<String, String> parameters, boolean addIssues, boolean mergeAsSingleIssue, boolean reopenExisting, String assignToUser, boolean publishTap, boolean tapTestsAsSteps, boolean tapFileNameInIdentifier, boolean tapTestNumberInIdentifier, String tapMappingPrefix, boolean importTestCases, String importTestCasesRootCategory, String testCaseMappingField, boolean publishRobot, String robotOutput, boolean robotCatenateParentKeywords, AbstractBuild<?, ?> build) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Running Sender - " + companyId + ", " + usingonpremise + ", " + onpremiseurl + ", api key hidden, " + projectKey + ", " + milestone + ", " + testRunTitle + ", " + comment + ", " + testTargetTitle + ", " + testEnvironmentTitle + ", " + tags + ", [" + parameters + "], " + addIssues + ", " + mergeAsSingleIssue + ", " + reopenExisting + ", " + assignToUser + ", " + publishTap + ", " + tapTestsAsSteps + ", " + tapFileNameInIdentifier + ", " + tapTestNumberInIdentifier + ", " + tapMappingPrefix + ", " + importTestCases + ", " + importTestCasesRootCategory + ", " + testCaseMappingField + ", " + publishRobot + ", " + robotOutput + ", " + robotCatenateParentKeywords);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("tap-plugin installed ? : " + (Sender.hasTAPSupport() ? "Yes, we have TAP support." : "No, no TAP support available."));
        }
        boolean hasTAPSupport = Sender.hasTAPSupport();
        ArrayList<Action> ras = new ArrayList<Action>();
        for (Action a : build.getAllActions()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Action: " + a);
            }
            if (hasTAPSupport && a instanceof TapTestResultAction) {
                ras.add(a);
                continue;
            }
            if (!(a instanceof AbstractTestResultAction)) continue;
            ras.add(a);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Have results: " + ras);
        }
        String robotXml = null;
        if (publishRobot) {
            try {
                robotXml = (String)workspace.act((FilePath.FileCallable)new RobotOutputCallable(robotOutput));
                log.fine("Found robot output xml: " + robotXml);
            }
            catch (Exception e) {
                log.severe("Could not parse Robot Framework's output.xml: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        if (ras.size() == 0 && publishRobot && robotXml == null) {
            log.warning("We have no results to publish. Please make sure your job is configured to publish some test results to make them available to this plugin.");
        } else {
            String user = "Jenkins job: " + build.getProject().getDisplayName();
            fi.meliora.testlab.ext.rest.model.TestResult data = new fi.meliora.testlab.ext.rest.model.TestResult();
            data.setStatus(3);
            data.setProjectKey(projectKey);
            data.setTestRunTitle(testRunTitle);
            data.setMilestoneIdentifier(milestone);
            data.setMilestoneTitle(milestone);
            data.setAddIssues(addIssues);
            data.setMergeAsSingleIssue(mergeAsSingleIssue);
            data.setReopenExistingIssues(reopenExisting);
            data.setAssignIssuesToUser(assignToUser);
            data.setTestCaseMappingField(testCaseMappingField);
            data.setUser(user);
            data.setComment(comment);
            data.setImportTestCases(importTestCases);
            data.setImportTestCasesRootCategory(importTestCasesRootCategory);
            if (parameters != null && parameters.size() > 0) {
                ArrayList<KeyValuePair> parameterValues = new ArrayList<KeyValuePair>();
                for (String string : parameters.keySet()) {
                    KeyValuePair keyValuePair = new KeyValuePair();
                    keyValuePair.setKey(string);
                    keyValuePair.setValue(parameters.get(string));
                    parameterValues.add(keyValuePair);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Sending test case parameter " + string + " with value " + keyValuePair.getValue());
                }
                data.setParameters(parameterValues);
            }
            if (!TestlabNotifier.isBlank(testTargetTitle)) {
                data.setTestTargetTitle(testTargetTitle);
            }
            if (!TestlabNotifier.isBlank(testEnvironmentTitle)) {
                data.setTestEnvironmentTitle(testEnvironmentTitle);
            }
            if (!TestlabNotifier.isBlank(tags)) {
                data.setTags(tags);
            }
            boolean hadResults = false;
            ArrayList<TestCaseResult> results = new ArrayList<TestCaseResult>();
            for (Object e : ras) {
                Object resultObject = null;
                if (e instanceof TapTestResultAction) {
                    try {
                        Method m = e.getClass().getMethod("getResult", new Class[0]);
                        resultObject = m.invoke(e, new Object[0]);
                    }
                    catch (Exception e2) {
                        log.fine("Could not resolve TapTestResultAction result: " + e2.getMessage());
                    }
                } else if (e instanceof AbstractTestResultAction) {
                    resultObject = ((AbstractTestResultAction)e).getResult();
                }
                if (resultObject == null) continue;
                if (resultObject instanceof List) {
                    List childReports = (List)resultObject;
                    for (Object childReport : childReports) {
                        if (!(childReport instanceof AggregatedTestResultAction.ChildReport)) continue;
                        Object childResultObject = ((AggregatedTestResultAction.ChildReport)childReport).result;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Have child results: " + childResultObject);
                        }
                        Sender.parseResult(build, childResultObject, results, user, publishTap, tapTestsAsSteps, tapFileNameInIdentifier, tapTestNumberInIdentifier, tapMappingPrefix);
                    }
                    continue;
                }
                Sender.parseResult(build, resultObject, results, user, publishTap, tapTestsAsSteps, tapFileNameInIdentifier, tapTestNumberInIdentifier, tapMappingPrefix);
            }
            if (results.size() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Sending " + results.size() + " test results to Testlab.");
                }
                data.setResults(results);
                hadResults = true;
            }
            if (publishRobot && robotXml != null) {
                data.setRobotCatenateParentKeywords(robotCatenateParentKeywords);
                data.setXmlFormat("robot");
                data.setXml(robotXml);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Including robot framework test results to be sent to Testlab.");
                }
                hadResults = true;
            }
            if (hadResults) {
                String string = usingonpremise ? onpremiseurl : null;
                AddTestResultResponse addTestResultResponse = CrestEndpointFactory.getInstance().getTestlabEndpoint(companyId, string, apiKey, TestResultResource.class).addTestResult(data);
                if (log.isLoggable(Level.INFO)) {
                    log.info("Posted results successfully to testlab test run: " + addTestResultResponse.getTestRunId());
                }
            } else if (log.isLoggable(Level.INFO)) {
                log.info("No test results resolved to send to Testlab. Skipping.");
            }
        }
    }

    protected static void parseResult(AbstractBuild<?, ?> build, Object resultObject, List<TestCaseResult> results, String user, boolean publishTap, boolean tapTestsAsSteps, boolean tapFileNameInIdentifier, boolean tapTestNumberInIdentifier, String tapMappingPrefix) {
        block27: {
            if (!(resultObject instanceof hudson.tasks.test.TestResult)) break block27;
            hudson.tasks.test.TestResult result = (hudson.tasks.test.TestResult)resultObject;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Result object: " + result + ", " + result.getClass().getName());
            }
            if (result instanceof TestResult) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Detected junit compatible result object.");
                }
                TestResult junitResult = (TestResult)result;
                for (SuiteResult sr : junitResult.getSuites()) {
                    for (CaseResult cr : sr.getCases()) {
                        String id = cr.getClassName() + "." + cr.getName();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Status for " + id + " is " + cr.getStatus());
                        }
                        int res = cr.isPassed() ? 1 : (cr.isSkipped() ? 3 : 2);
                        String msg = cr.getErrorDetails();
                        String stacktrace = cr.getErrorStackTrace();
                        results.add(Sender.getTestCaseResult(build, id, res, msg, stacktrace, user, cr.getDuration()));
                    }
                }
            } else if (Sender.hasTAPSupport() && publishTap && result instanceof TapStreamResult) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Detected tap-plugin result object.");
                }
                TapStreamResult tsr = (TapStreamResult)result;
                for (hudson.tasks.test.TestResult tr : tsr.getChildren()) {
                    TapTestResultResult r = (TapTestResultResult)tr;
                    try {
                        String testCaseResultComment;
                        String id;
                        String fileName;
                        int slash;
                        log.fine("TAP RESULT: " + r);
                        String tapTest = r.getTitle();
                        if (!tapTestNumberInIdentifier && tapTest.contains(" - ")) {
                            tapTest = tapTest.substring(tapTest.indexOf(" - ") + 3);
                        }
                        if ((slash = (fileName = URLDecoder.decode(r.getSafeName(), "UTF-8")).lastIndexOf(47)) > -1) {
                            fileName = fileName.substring(slash + 1);
                        }
                        fileName = fileName.substring(0, fileName.lastIndexOf(45));
                        int testResult = "Yes".equals(r.getSkip()) ? 3 : ("OK".equals(r.getStatus()) ? 1 : 2);
                        log.fine(" TAP test result: " + testResult);
                        if (!tapTestsAsSteps) {
                            id = tapFileNameInIdentifier ? fileName.replaceAll("\\.", "_") + "." + tapTest : tapTest;
                            if (!StringUtils.isBlank((String)tapMappingPrefix)) {
                                id = tapMappingPrefix + id;
                            }
                            log.fine(" TAP identifier parsed: " + id);
                            results.add(Sender.getTestCaseResult(build, id, testResult, r.toString(), r.getErrorStackTrace(), user, r.getDuration()));
                            continue;
                        }
                        id = fileName.replaceAll("\\.", "_");
                        if (!StringUtils.isBlank((String)tapMappingPrefix)) {
                            id = tapMappingPrefix + id;
                        }
                        log.fine(" TAP identifier parsed: " + id);
                        TestCaseResult testCaseResult = null;
                        for (TestCaseResult tcr : results) {
                            if (!id.equals(tcr.getMappingId())) continue;
                            testCaseResult = tcr;
                            break;
                        }
                        if (testCaseResult == null) {
                            testCaseResult = Sender.getTestCaseResult(build, id, testResult, "", "", user, r.getDuration());
                            results.add(testCaseResult);
                        }
                        TestCaseResultStep testCaseResultStep = new TestCaseResultStep();
                        testCaseResultStep.setResult(testResult);
                        testCaseResultStep.setDescription(tapTest);
                        testCaseResultStep.setComment(r.toString());
                        List<TestCaseResultStep> steps = testCaseResult.getSteps();
                        if (steps == null) {
                            steps = new ArrayList<TestCaseResultStep>();
                            testCaseResult.setSteps(steps);
                        }
                        steps.add(testCaseResultStep);
                        if (testResult == 2) {
                            testCaseResult.setResult(2);
                        }
                        if ((testCaseResultComment = testCaseResult.getComment()).length() > 0) {
                            testCaseResultComment = testCaseResultComment + "\n";
                        }
                        testCaseResultComment = testCaseResultComment + testCaseResultStep.getComment();
                        testCaseResult.setComment(testCaseResultComment);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.warning("Could not parse TAP result row: " + r);
                    }
                }
            } else {
                String id;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Detected generic result object.");
                }
                for (hudson.tasks.test.TestResult tr : result.getPassedTests()) {
                    id = tr.getParent() != null ? tr.getParent().getName() + "." + tr.getName() : tr.getName();
                    results.add(Sender.getTestCaseResult(build, id, 1, tr.getErrorDetails(), tr.getErrorStackTrace(), user, tr.getDuration()));
                }
                for (hudson.tasks.test.TestResult tr : result.getFailedTests()) {
                    id = tr.getParent() != null ? tr.getParent().getName() + "." + tr.getName() : tr.getName();
                    results.add(Sender.getTestCaseResult(build, id, 2, tr.getErrorDetails(), tr.getErrorStackTrace(), user, tr.getDuration()));
                }
                for (hudson.tasks.test.TestResult tr : result.getSkippedTests()) {
                    id = tr.getParent() != null ? tr.getParent().getName() + "." + tr.getName() : tr.getName();
                    results.add(Sender.getTestCaseResult(build, id, 3, tr.getErrorDetails(), tr.getErrorStackTrace(), user, tr.getDuration()));
                }
            }
        }
    }

    protected static TestCaseResult getTestCaseResult(AbstractBuild<?, ?> build, String id, int result, String msg, String stacktrace, String user, float duration) {
        TestCaseResult r = new TestCaseResult();
        r.setMappingId(id);
        r.setResult(result);
        long started = build.getTimeInMillis();
        r.setStarted(started);
        r.setRun(started + (long)(duration * 1000.0f));
        r.setRunBy(user);
        if (msg != null || stacktrace != null) {
            StringBuilder comment = new StringBuilder();
            if (!TestlabNotifier.isBlank(msg)) {
                comment.append(msg);
            }
            if (!TestlabNotifier.isBlank(stacktrace)) {
                if (comment.length() > 0) {
                    comment.append("\n\n");
                }
                comment.append(stacktrace);
            }
            r.setComment(comment.toString());
        }
        return r;
    }

    public static boolean hasTAPSupport() {
        try {
            Class.forName("org.tap4j.plugin.model.TapStreamResult");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        System.getProperties().setProperty("org.codegist.common.log.class", "org.codegist.common.log.Slf4jLogger");
    }

    private static final class RobotOutputCallable
    extends MasterToSlaveFileCallable<String> {
        private String robotOutput;

        public RobotOutputCallable(String robotOutput) {
            this.robotOutput = robotOutput;
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            FileSet fs = Util.createFileSet((File)f, (String)this.robotOutput);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length > 0) {
                for (String file : files) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Matching robot output file found: " + ds.getBasedir().getAbsolutePath() + File.pathSeparator + file);
                }
                if (files.length > 1) {
                    throw new AbortException("Robot Output path " + this.robotOutput + " matches more than one file. Pattern must be more exact. Aborting.");
                }
                File outputXml = new File(ds.getBasedir(), files[0]);
                return Util.loadFile((File)outputXml, (Charset)Charset.forName("UTF-8"));
            }
            return null;
        }
    }
}

