/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.crest;

import fi.meliora.testlab.ext.crest.exception.NotFoundException;
import fi.meliora.testlab.ext.crest.exception.TestlabAPIException;
import java.io.InputStream;
import java.util.Scanner;
import javax.ws.rs.core.Response;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.RequestException;
import org.codegist.crest.io.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler
implements org.codegist.crest.handler.ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T handle(Request request, Exception e) throws Exception {
        RequestException re;
        Response testlabResponse;
        if (e instanceof RequestException && (testlabResponse = (re = (RequestException)e).getResponse()) != null) {
            int statusCode;
            String responseData = null;
            InputStream is = null;
            try {
                String charset;
                Scanner s;
                is = testlabResponse.asStream();
                if (is != null && (s = new Scanner(is, charset = testlabResponse.getCharset() != null ? testlabResponse.getCharset().name() : "UTF-8").useDelimiter("\\A")).hasNext()) {
                    responseData = s.next();
                }
                if (responseData != null && responseData.length() > 400) {
                    responseData = responseData.substring(0, 400) + "...";
                }
            }
            catch (Exception charset) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception charset) {}
                }
            }
            if (log.isErrorEnabled()) {
                log.error("Testlab REST call failed with response '{}', status code {}, exception: {}", new Object[]{responseData, testlabResponse.getStatusCode(), e});
            }
            if ((statusCode = testlabResponse.getStatusCode()) == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NotFoundException(responseData);
            }
            if (responseData != null && responseData.length() > 0) {
                throw new TestlabAPIException(responseData);
            }
        }
        if (log.isErrorEnabled()) {
            log.error("Testlab REST call exception: " + e.getMessage(), (Throwable)e);
        }
        if (e.getCause() != null && e.getCause() instanceof Exception) {
            throw (Exception)e.getCause();
        }
        throw e;
    }
}

