/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mattermost;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.JobProperty;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.mattermost.ActiveNotifier;
import jenkins.plugins.mattermost.CommitInfoChoice;
import jenkins.plugins.mattermost.MattermostService;
import jenkins.plugins.mattermost.StandardMattermostService;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.POST;

public class MattermostNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(MattermostNotifier.class.getName());
    private String endpoint;
    private String buildServerUrl;
    private String room;
    private String icon;
    private String sendAs;
    private boolean startNotification;
    private boolean notifySuccess;
    private boolean notifyAborted;
    private boolean notifyNotBuilt;
    private boolean notifyUnstable;
    private boolean notifyFailure;
    private boolean notifyBackToNormal;
    private boolean notifyRepeatedFailure;
    private boolean includeTestSummary;
    private transient boolean showCommitList;
    private CommitInfoChoice commitInfoChoice;
    private boolean includeCustomAttachmentMessage;
    private String customAttachmentMessage;
    private boolean includeCustomMessage;
    private String customMessage;

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRoom() {
        return this.room;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getBuildServerUrl() {
        if (this.buildServerUrl == null || this.buildServerUrl.equals("")) {
            JenkinsLocationConfiguration jenkinsConfig = JenkinsLocationConfiguration.get();
            return jenkinsConfig == null ? null : jenkinsConfig.getUrl();
        }
        return this.buildServerUrl;
    }

    public String getSendAs() {
        return this.sendAs;
    }

    public boolean getStartNotification() {
        return this.startNotification;
    }

    public boolean getNotifySuccess() {
        return this.notifySuccess;
    }

    public CommitInfoChoice getCommitInfoChoice() {
        return this.commitInfoChoice;
    }

    public boolean getNotifyAborted() {
        return this.notifyAborted;
    }

    public boolean getNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean getNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    public boolean getNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean getNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    public boolean getIncludeTestSummary() {
        return this.includeTestSummary;
    }

    public boolean getNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    public boolean getIncludeCustomAttachmentMessage() {
        return this.includeCustomAttachmentMessage;
    }

    public String getCustomAttachmentMessage() {
        return this.customAttachmentMessage;
    }

    public boolean getIncludeCustomMessage() {
        return this.includeCustomMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public void setEndpoint(@CheckForNull String endpoint) {
        this.endpoint = Util.fixNull((String)endpoint);
    }

    @DataBoundSetter
    public void setRoom(@CheckForNull String room) {
        this.room = Util.fixNull((String)room);
    }

    @DataBoundSetter
    public void setIcon(@CheckForNull String icon) {
        this.icon = Util.fixNull((String)icon);
    }

    @DataBoundSetter
    public void setBuildServerUrl(@CheckForNull String buildServerUrl) {
        this.buildServerUrl = Util.fixNull((String)buildServerUrl);
    }

    @DataBoundSetter
    public void setSendAs(@CheckForNull String sendAs) {
        this.sendAs = Util.fixNull((String)sendAs);
    }

    @DataBoundSetter
    public void setStartNotification(boolean startNotification) {
        this.startNotification = startNotification;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    @DataBoundSetter
    public void setCommitInfoChoice(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    @DataBoundSetter
    public void setIncludeTestSummary(boolean includeTestSummary) {
        this.includeTestSummary = includeTestSummary;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setIncludeCustomAttachmentMessage(boolean includeCustomAttachmentMessage) {
        this.includeCustomAttachmentMessage = includeCustomAttachmentMessage;
    }

    @DataBoundSetter
    public void setCustomAttachmentMessage(@CheckForNull String customAttachmentMessage) {
        this.customAttachmentMessage = Util.fixNull((String)customAttachmentMessage);
    }

    @DataBoundSetter
    public void setIncludeCustomMessage(boolean includeCustomMessage) {
        this.includeCustomMessage = includeCustomMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(@CheckForNull String customMessage) {
        this.customMessage = Util.fixNull((String)customMessage);
    }

    @DataBoundConstructor
    public MattermostNotifier(String endpoint, String room, String icon, String buildServerUrl, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, CommitInfoChoice commitInfoChoice, boolean includeCustomAttachmentMessage, String customAttachmentMessage, boolean includeCustomMessage, String customMessage) {
        this.endpoint = endpoint;
        this.buildServerUrl = buildServerUrl;
        this.room = room;
        this.icon = icon;
        this.sendAs = sendAs;
        this.startNotification = startNotification;
        this.notifyAborted = notifyAborted;
        this.notifyFailure = notifyFailure;
        this.notifyNotBuilt = notifyNotBuilt;
        this.notifySuccess = notifySuccess;
        this.notifyUnstable = notifyUnstable;
        this.notifyBackToNormal = notifyBackToNormal;
        this.notifyRepeatedFailure = notifyRepeatedFailure;
        this.includeTestSummary = includeTestSummary;
        this.commitInfoChoice = commitInfoChoice;
        this.includeCustomAttachmentMessage = includeCustomAttachmentMessage;
        this.customAttachmentMessage = includeCustomAttachmentMessage ? customAttachmentMessage : null;
        this.includeCustomMessage = includeCustomMessage;
        this.customMessage = includeCustomMessage ? customMessage : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public MattermostService newMattermostService(AbstractBuild r, BuildListener listener) {
        String icon;
        String room;
        String endpoint = this.endpoint;
        if (StringUtils.isEmpty((String)endpoint)) {
            endpoint = this.getDescriptor().getEndpoint();
        }
        if (StringUtils.isEmpty((String)(room = this.room))) {
            room = this.getDescriptor().getRoom();
        }
        if (StringUtils.isEmpty((String)(icon = this.icon))) {
            icon = this.getDescriptor().getIcon();
        }
        EnvVars env = null;
        try {
            env = r.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        endpoint = env.expand(endpoint);
        room = env.expand(room);
        icon = env.expand(icon);
        return new StandardMattermostService(endpoint, room, icon);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        if (this.startNotification) {
            Map map = build.getProject().getPublishersList().toMap();
            for (Publisher publisher : map.values()) {
                if (!(publisher instanceof MattermostNotifier)) continue;
                logger.info("Invoking Started...");
                new ActiveNotifier((MattermostNotifier)publisher, listener).started(build);
            }
        }
        return super.prebuild(build, listener);
    }

    @Extension
    public static final class Migrator
    extends ItemListener {
        public void onLoaded() {
            logger.info("Starting Settings Migration Process");
            for (AbstractProject p : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                MattermostJobProperty mattermostJobProperty = (MattermostJobProperty)p.getProperty(MattermostJobProperty.class);
                if (mattermostJobProperty == null) {
                    logger.fine(String.format("Configuration is already up to date for \"%s\", skipping migration", p.getName()));
                    continue;
                }
                MattermostNotifier mattermostNotifier = (MattermostNotifier)p.getPublishersList().get(MattermostNotifier.class);
                if (mattermostNotifier == null) {
                    logger.fine(String.format("Configuration does not have a notifier for \"%s\", not migrating settings", p.getName()));
                } else {
                    logger.info(String.format("Starting migration for \"%s\"", p.getName()));
                    if (StringUtils.isBlank((String)mattermostNotifier.endpoint)) {
                        mattermostNotifier.endpoint = mattermostJobProperty.getEndpoint();
                    }
                    if (StringUtils.isBlank((String)mattermostNotifier.icon)) {
                        mattermostNotifier.icon = mattermostJobProperty.getIcon();
                    }
                    if (StringUtils.isBlank((String)mattermostNotifier.room)) {
                        mattermostNotifier.room = mattermostJobProperty.getRoom();
                    }
                    mattermostNotifier.startNotification = mattermostJobProperty.getStartNotification();
                    mattermostNotifier.notifyAborted = mattermostJobProperty.getNotifyAborted();
                    mattermostNotifier.notifyFailure = mattermostJobProperty.getNotifyFailure();
                    mattermostNotifier.notifyNotBuilt = mattermostJobProperty.getNotifyNotBuilt();
                    mattermostNotifier.notifySuccess = mattermostJobProperty.getNotifySuccess();
                    mattermostNotifier.notifyUnstable = mattermostJobProperty.getNotifyUnstable();
                    mattermostNotifier.notifyBackToNormal = mattermostJobProperty.getNotifyBackToNormal();
                    mattermostNotifier.notifyRepeatedFailure = mattermostJobProperty.getNotifyRepeatedFailure();
                    mattermostNotifier.includeTestSummary = mattermostJobProperty.includeTestSummary();
                    mattermostNotifier.commitInfoChoice = mattermostJobProperty.getShowCommitList() ? CommitInfoChoice.AUTHORS_AND_TITLES : CommitInfoChoice.NONE;
                    mattermostNotifier.includeCustomAttachmentMessage = mattermostJobProperty.includeCustomAttachmentMessage();
                    mattermostNotifier.customAttachmentMessage = mattermostJobProperty.getCustomAttachmentMessage();
                    mattermostNotifier.includeCustomMessage = mattermostJobProperty.includeCustomMessage();
                    mattermostNotifier.customMessage = mattermostJobProperty.getCustomMessage();
                }
                try {
                    p.removeProperty(MattermostJobProperty.class);
                    p.save();
                    logger.info("Configuration updated successfully");
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    @Deprecated
    public static class MattermostJobProperty
    extends JobProperty<AbstractProject<?, ?>> {
        private String endpoint;
        private String room;
        private String icon;
        private boolean startNotification;
        private boolean notifySuccess;
        private boolean notifyAborted;
        private boolean notifyNotBuilt;
        private boolean notifyUnstable;
        private boolean notifyFailure;
        private boolean notifyBackToNormal;
        private boolean notifyRepeatedFailure;
        private boolean includeTestSummary;
        private boolean showCommitList;
        private boolean includeCustomAttachmentMessage;
        private String customAttachmentMessage;
        private String customMessage;
        private boolean includeCustomMessage;

        @DataBoundConstructor
        public MattermostJobProperty(String teamDomain, String room, String icon, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean showCommitList, boolean includeCustomAttachmentMessage, String customAttachmentMessage, boolean includeCustomMessage, String customMessage) {
            this.endpoint = teamDomain;
            this.room = room;
            this.icon = icon;
            this.startNotification = startNotification;
            this.notifyAborted = notifyAborted;
            this.notifyFailure = notifyFailure;
            this.notifyNotBuilt = notifyNotBuilt;
            this.notifySuccess = notifySuccess;
            this.notifyUnstable = notifyUnstable;
            this.notifyBackToNormal = notifyBackToNormal;
            this.notifyRepeatedFailure = notifyRepeatedFailure;
            this.includeTestSummary = includeTestSummary;
            this.showCommitList = showCommitList;
            this.includeCustomAttachmentMessage = includeCustomAttachmentMessage;
            this.customAttachmentMessage = customAttachmentMessage;
            this.includeCustomMessage = includeCustomMessage;
            this.customMessage = customMessage;
        }

        @Exported
        public String getEndpoint() {
            return this.endpoint;
        }

        @Exported
        public String getIcon() {
            return this.icon;
        }

        @Exported
        public String getRoom() {
            return this.room;
        }

        @Exported
        public boolean getStartNotification() {
            return this.startNotification;
        }

        @Exported
        public boolean getNotifySuccess() {
            return this.notifySuccess;
        }

        @Exported
        public boolean getShowCommitList() {
            return this.showCommitList;
        }

        public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
            return super.prebuild(build, listener);
        }

        @Exported
        public boolean getNotifyAborted() {
            return this.notifyAborted;
        }

        @Exported
        public boolean getNotifyFailure() {
            return this.notifyFailure;
        }

        @Exported
        public boolean getNotifyNotBuilt() {
            return this.notifyNotBuilt;
        }

        @Exported
        public boolean getNotifyUnstable() {
            return this.notifyUnstable;
        }

        @Exported
        public boolean getNotifyBackToNormal() {
            return this.notifyBackToNormal;
        }

        @Exported
        public boolean includeTestSummary() {
            return this.includeTestSummary;
        }

        @Exported
        public boolean getNotifyRepeatedFailure() {
            return this.notifyRepeatedFailure;
        }

        @Exported
        public boolean includeCustomAttachmentMessage() {
            return this.includeCustomAttachmentMessage;
        }

        @Exported
        public String getCustomAttachmentMessage() {
            return this.customAttachmentMessage;
        }

        @Exported
        public boolean includeCustomMessage() {
            return this.includeCustomMessage;
        }

        @Exported
        public String getCustomMessage() {
            return this.customMessage;
        }
    }

    @Extension
    @Symbol(value={"mattermostNotifier"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String endpoint;
        private String room;
        private String icon;
        private String buildServerUrl;
        private String sendAs;

        public DescriptorImpl() {
            this.load();
        }

        @DataBoundSetter
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        @DataBoundSetter
        public void setRoom(String room) {
            this.room = room;
        }

        public String getRoom() {
            return this.room;
        }

        @DataBoundSetter
        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getIcon() {
            return this.icon;
        }

        @DataBoundSetter
        public void setBuildServerUrl(String buildServerUrl) {
            this.buildServerUrl = buildServerUrl;
        }

        public String getBuildServerUrl() {
            if (this.buildServerUrl == null || this.buildServerUrl.equals("")) {
                JenkinsLocationConfiguration jenkinsConfig = JenkinsLocationConfiguration.get();
                return jenkinsConfig == null ? null : jenkinsConfig.getUrl();
            }
            return this.buildServerUrl;
        }

        public String getSendAs() {
            return this.sendAs;
        }

        public ListBoxModel doFillCommitInfoChoiceItems() {
            ListBoxModel model = new ListBoxModel();
            for (CommitInfoChoice choice : CommitInfoChoice.values()) {
                model.add(choice.getDisplayName(), choice.name());
            }
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        MattermostService getMattermostService(String endpoint, String room, String icon) {
            return new StandardMattermostService(endpoint, room, icon);
        }

        public String getDisplayName() {
            return "Mattermost Notifications";
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="endpoint") String endpoint, @QueryParameter(value="room") String room, @QueryParameter(value="icon") String icon, @QueryParameter(value="buildServerUrl") String buildServerUrl) throws Descriptor.FormException {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"Insufficient permission.");
            }
            try {
                String message;
                MattermostService testMattermostService;
                boolean success;
                String targetBuildServerUrl;
                String targetIcon;
                String targetRoom;
                String targetEndpoint = endpoint;
                if (StringUtils.isEmpty((String)targetEndpoint)) {
                    targetEndpoint = this.endpoint;
                }
                if (StringUtils.isEmpty((String)(targetRoom = room))) {
                    targetRoom = this.room;
                }
                if (StringUtils.isEmpty((String)(targetIcon = icon))) {
                    targetIcon = this.icon;
                }
                if (StringUtils.isEmpty((String)(targetBuildServerUrl = buildServerUrl))) {
                    targetBuildServerUrl = this.buildServerUrl;
                }
                return (success = (testMattermostService = this.getMattermostService(targetEndpoint, targetRoom, targetIcon)).publish(message = "Mattermost/Jenkins plugin: you're all set! (parameters: room='" + targetRoom + "', icon='" + targetIcon + "', buildServerUrl='" + targetBuildServerUrl + "')", "good")) ? FormValidation.ok((String)"Success") : FormValidation.error((String)"Failure");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }
    }
}

