/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mattermost;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.mattermost.ActiveNotifier;
import jenkins.plugins.mattermost.DisabledNotifier;
import jenkins.plugins.mattermost.FineGrainedNotifier;
import jenkins.plugins.mattermost.MattermostNotifier;

@Extension
public class MattermostListener
extends RunListener<AbstractBuild> {
    private static final Logger logger = Logger.getLogger(MattermostListener.class.getName());

    public MattermostListener() {
        super(AbstractBuild.class);
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        this.getNotifier(r.getProject(), listener).completed(r);
        super.onCompleted((Run)r, listener);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
    }

    public void onDeleted(AbstractBuild r) {
    }

    public void onFinalized(AbstractBuild r) {
    }

    FineGrainedNotifier getNotifier(AbstractProject project, TaskListener listener) {
        Map map = project.getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof MattermostNotifier)) continue;
            return new ActiveNotifier((MattermostNotifier)publisher, (BuildListener)listener);
        }
        return new DisabledNotifier();
    }
}

