/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.Node;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class MatrixRun
extends Build<MatrixConfiguration, MatrixRun> {
    public MatrixRun(MatrixConfiguration job) throws IOException {
        super((Project)job);
    }

    public MatrixRun(MatrixConfiguration job, Calendar timestamp) {
        super((Project)job, timestamp);
    }

    public MatrixRun(MatrixConfiguration project, File buildDir) throws IOException {
        super((Project)project, buildDir);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                Object parentObj;
                if (((Ancestor)ancs.get(i)).getObject() != this || !((parentObj = ((Ancestor)ancs.get(i - 1)).getObject()) instanceof MatrixBuild) && !(parentObj instanceof MatrixConfiguration)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + '/';
            }
        }
        return super.getDisplayName();
    }

    public MatrixBuild getParentBuild() {
        return (MatrixBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public AbstractBuild<?, ?> getRootBuild() {
        return this.getParentBuild();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MatrixBuild)) continue;
                return this.getParent().getCombination().toCompactString(this.getParent().getParent().getAxes());
            }
        }
        return super.getDisplayName();
    }

    public Map<String, String> getBuildVariables() {
        Map r = super.getBuildVariables();
        AxisList axes = this.getParent().getParent().getAxes();
        for (Map.Entry e : this.getParent().getCombination().entrySet()) {
            Axis a = axes.find((String)e.getKey());
            if (a != null) {
                a.addBuildVariable((String)e.getValue(), r);
                continue;
            }
            r.put(e.getKey(), e.getValue());
        }
        return r;
    }

    public String getWhyKeepLog() {
        MatrixBuild pb = this.getParentBuild();
        if (pb != null && pb.getWhyKeepLog() != null) {
            return Messages.MatrixRun_KeptBecauseOfParent((Object)pb);
        }
        return super.getWhyKeepLog();
    }

    public MatrixConfiguration getParent() {
        return (MatrixConfiguration)super.getParent();
    }

    public void run() {
        this.execute((Run.RunExecution)new MatrixRunExecution());
    }

    private class MatrixRunExecution
    extends Build.BuildExecution {
        private MatrixRunExecution() {
            super((Build)MatrixRun.this);
        }

        protected WorkspaceList.Lease getParentWorkspaceLease(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            MatrixProject mp = MatrixRun.this.getParent().getParent();
            String customWorkspace = mp.getCustomWorkspace();
            if (customWorkspace != null) {
                FilePath nodeRoot = n.getRootPath();
                if (nodeRoot == null) {
                    throw new IOException("Cannot retrieve the node's root. Most probably it's offline");
                }
                return WorkspaceList.Lease.createDummyLease((FilePath)nodeRoot.child(MatrixRun.this.getEnvironment((TaskListener)this.listener).expand(customWorkspace)));
            }
            FilePath workspace = n.getWorkspaceFor((TopLevelItem)mp);
            if (workspace == null) {
                throw new IOException("Cannot retrieve the node's workspace for " + (Object)((Object)mp) + ". Most probably the node is offline");
            }
            return wsl.allocate(workspace, (Object)MatrixRun.this.getParentBuild());
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            MatrixProject mp = MatrixRun.this.getParent().getParent();
            WorkspaceList.Lease baseLease = this.getParentWorkspaceLease(n, wsl);
            FilePath baseDir = baseLease.path;
            EnvVars env = MatrixRun.this.getEnvironment((TaskListener)this.listener);
            env.put("COMBINATION", MatrixRun.this.getParent().getCombination().toString('/', '/'));
            env.put("SHORT_COMBINATION", MatrixRun.this.getParent().getDigestName());
            env.put("PARENT_WORKSPACE", baseDir.getRemote());
            env.putAll(MatrixRun.this.getBuildVariables());
            String childWs = mp.getChildCustomWorkspace();
            return WorkspaceList.Lease.createLinkedDummyLease((FilePath)baseDir.child(env.expand(childWs)), (WorkspaceList.Lease)baseLease);
        }
    }
}

