/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.AbortException;
import hudson.Functions;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.Layouter;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.matrix.Messages;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.test.TestResultAggregator;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MatrixBuild
extends AbstractBuild<MatrixProject, MatrixBuild> {
    private AxisList axes;
    private Integer baseBuild;

    public MatrixBuild(MatrixProject job) throws IOException {
        super((AbstractProject)job);
    }

    public MatrixBuild(MatrixProject job, Calendar timestamp) {
        super((AbstractProject)job, timestamp);
    }

    public MatrixBuild(MatrixProject project, File buildDir) throws IOException {
        super((AbstractProject)project, buildDir);
    }

    public Object readResolve() {
        if (this.axes == null) {
            this.axes = ((MatrixProject)this.getParent()).getAxes();
        }
        return this;
    }

    public void delete() throws IOException {
        super.delete();
        for (MatrixRun run : this.getExactRuns()) {
            run.delete();
        }
    }

    @RequirePOST
    @Deprecated
    public void doDoDeleteAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.doDoDelete(req, rsp);
    }

    public Layouter<RunPtr> getLayouter() {
        return this.axes == null ? null : new Layouter<RunPtr>(this.axes){

            @Override
            protected RunPtr getT(Combination c) {
                return new RunPtr(c);
            }
        };
    }

    public void setBaseBuild(MatrixBuild baseBuild) {
        this.baseBuild = baseBuild == null || baseBuild == this.getPreviousBuild() ? null : Integer.valueOf(baseBuild.getNumber());
    }

    public MatrixBuild getBaseBuild() {
        return this.baseBuild == null ? (MatrixBuild)this.getPreviousBuild() : (MatrixBuild)((MatrixProject)this.getParent()).getBuildByNumber(this.baseBuild);
    }

    public MatrixRun getRun(Combination c) {
        MatrixConfiguration config = ((MatrixProject)this.getParent()).getItem(c);
        if (config == null) {
            return null;
        }
        return this.getRunForConfiguration(config);
    }

    public MatrixRun getExactRun(Combination c) {
        MatrixConfiguration config = ((MatrixProject)this.getParent()).getItem(c);
        if (config == null) {
            return null;
        }
        return (MatrixRun)config.getBuildByNumber(this.getNumber());
    }

    @Exported
    public List<MatrixRun> getRuns() {
        ArrayList<MatrixRun> r = new ArrayList<MatrixRun>();
        for (MatrixConfiguration c : ((MatrixProject)this.getParent()).getItems()) {
            MatrixRun b = this.getRunForConfiguration(c);
            if (b == null) continue;
            r.add(b);
        }
        return r;
    }

    private MatrixRun getRunForConfiguration(MatrixConfiguration c) {
        for (MatrixBuild b = this; b != null; b = b.getBaseBuild()) {
            MatrixRun r = (MatrixRun)c.getBuildByNumber(b.getNumber());
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public List<MatrixRun> getExactRuns() {
        ArrayList<MatrixRun> r = new ArrayList<MatrixRun>();
        for (MatrixConfiguration c : ((MatrixProject)this.getParent()).getItems()) {
            MatrixRun b = (MatrixRun)c.getBuildByNumber(this.getNumber());
            if (b == null) continue;
            r.add(b);
        }
        return r;
    }

    public String getWhyKeepLog() {
        MatrixBuild b = (MatrixBuild)this.getNextBuild();
        if (this.isLinkedBy(b)) {
            return Messages.MatrixBuild_depends_on_this(b.getDisplayName());
        }
        return super.getWhyKeepLog();
    }

    public boolean isLinkedBy(MatrixBuild b) {
        if (null == b) {
            return false;
        }
        for (MatrixConfiguration c : ((MatrixProject)b.getParent()).getActiveConfigurations()) {
            MatrixRun r = (MatrixRun)c.getNearestOldBuild(b.getNumber());
            if (r == null || r.getNumber() != this.getNumber()) continue;
            return true;
        }
        return false;
    }

    public boolean isPartial() {
        for (MatrixConfiguration c : ((MatrixProject)this.getParent()).getActiveConfigurations()) {
            MatrixRun b = (MatrixRun)c.getNearestOldBuild(this.getNumber());
            if (b == null || b.getNumber() == this.getNumber()) continue;
            return true;
        }
        return false;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        try {
            MatrixRun item = this.getRun(Combination.fromString(token));
            if (item != null) {
                if (item.getNumber() == this.getNumber()) {
                    return item;
                }
                String url = Functions.joinPath((String[])new String[]{item.getUrl(), req.getRestOfPath()});
                String qs = req.getQueryString();
                if (qs != null) {
                    url = url + '?' + qs;
                }
                throw HttpResponses.redirectViaContextPath((String)url);
            }
        }
        catch (IllegalArgumentException _) {
            // empty catch block
        }
        return super.getDynamic(token, req, rsp);
    }

    public void run() {
        this.execute((Run.RunExecution)new MatrixBuildExecution());
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = super.getDownstreamRelationship(that);
        for (MatrixRun run : this.getRuns()) {
            rs.add(run.getDownstreamRelationship(that));
        }
        return rs;
    }

    public class MatrixBuildExecution
    extends AbstractBuild.AbstractBuildExecution {
        private final List<MatrixAggregator> aggregators;
        private Set<MatrixConfiguration> activeConfigurations;

        public MatrixBuildExecution() {
            super((AbstractBuild)MatrixBuild.this);
            this.aggregators = new ArrayList<MatrixAggregator>();
        }

        public Set<MatrixConfiguration> getActiveConfigurations() {
            return this.activeConfigurations;
        }

        public List<MatrixAggregator> getAggregators() {
            return this.aggregators;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Result doRun(BuildListener listener) throws Exception {
            MatrixProject p = (MatrixProject)this.getProject();
            PrintStream logger = listener.getLogger();
            this.activeConfigurations = p.rebuildConfigurations(this);
            this.listUpAggregators(p.getPublishers().values());
            this.listUpAggregators(p.getProperties().values());
            this.listUpAggregators(p.getBuildWrappers().values());
            MatrixBuild.this.axes = p.getAxes();
            try {
                Result result = p.getExecutionStrategy().run(this);
                return result;
            }
            catch (InterruptedException e) {
                logger.println("Aborted");
                Executor x = Executor.currentExecutor();
                if (x == null) {
                    throw new IOException("The build has been aborted, but its executor is not available");
                }
                x.recordCauseOfInterruption((Run)MatrixBuild.this, (TaskListener)listener);
                Result q = x.abortResult();
                return q;
            }
            catch (AbortException e) {
                logger.println(e.getMessage());
                Result result = Result.FAILURE;
                return result;
            }
            finally {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    logger.println("Jenkins instance is not ready. Cannot interrupt configurations");
                } else {
                    Queue q;
                    Queue i$ = q = jenkins.getQueue();
                    synchronized (i$) {
                        int n = MatrixBuild.this.getNumber();
                        for (MatrixConfiguration c : this.activeConfigurations) {
                            Executor exe;
                            for (Queue.Item i : q.getItems((Queue.Task)c)) {
                                MatrixConfiguration.ParentBuildAction a = (MatrixConfiguration.ParentBuildAction)i.getAction(MatrixConfiguration.ParentBuildAction.class);
                                if (a == null || a.parent != this.getBuild()) continue;
                                q.cancel(i);
                                logger.println(Messages.MatrixBuild_Cancelled(ModelHyperlinkNote.encodeTo((Item)c)));
                            }
                            MatrixRun b = (MatrixRun)c.getBuildByNumber(n);
                            if (b == null || !b.isBuilding() || (exe = b.getExecutor()) == null) continue;
                            logger.println(Messages.MatrixBuild_Interrupting(ModelHyperlinkNote.encodeTo((Run)b)));
                            exe.interrupt();
                        }
                    }
                }
            }
        }

        private void listUpAggregators(Collection<?> values) {
            for (Object v : values) {
                if (v instanceof MatrixAggregatable) {
                    MatrixAggregatable ma = (MatrixAggregatable)v;
                    MatrixAggregator a = ma.createAggregator(MatrixBuild.this, this.launcher, this.listener);
                    if (a == null) continue;
                    this.aggregators.add(a);
                    continue;
                }
                if (!(v instanceof JUnitResultArchiver)) continue;
                this.aggregators.add(new TestResultAggregator(MatrixBuild.this, this.launcher, this.listener));
            }
        }

        public void post2(BuildListener listener) throws Exception {
            for (MatrixAggregator a : this.aggregators) {
                a.endBuild();
            }
        }
    }

    public final class RunPtr {
        public final Combination combination;

        private RunPtr(Combination c) {
            this.combination = c;
        }

        public MatrixRun getRun() {
            return MatrixBuild.this.getRun(this.combination);
        }

        public String getNearestRunUrl() {
            MatrixRun r = this.getRun();
            if (r == null) {
                return null;
            }
            if (MatrixBuild.this.getNumber() == r.getNumber()) {
                return this.getShortUrl() + '/';
            }
            return Stapler.getCurrentRequest().getContextPath() + '/' + r.getUrl();
        }

        public String getShortUrl() {
            return Util.rawEncode((String)this.combination.toString());
        }

        @CheckForNull
        public String getTooltip() {
            MatrixRun r = this.getRun();
            if (r != null) {
                return r.getIconColor().getDescription();
            }
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return null;
            }
            Queue.Item item = jenkins.getQueue().getItem((Queue.Task)((MatrixProject)MatrixBuild.this.getParent()).getItem(this.combination));
            if (item != null) {
                return item.getWhy();
            }
            return null;
        }
    }
}

