/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.Job;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LinkedLogRotator
extends LogRotator {
    private static final Logger LOGGER = Logger.getLogger(LinkedLogRotator.class.getName());

    LinkedLogRotator(int artifactDaysToKeep, int artifactNumToKeep) {
        super(-1, -1, artifactDaysToKeep, artifactNumToKeep);
    }

    LinkedLogRotator() {
        super(-1, -1, -1, -1);
    }

    public void perform(Job _job) throws IOException, InterruptedException {
        super.perform(_job);
        if (!(_job instanceof MatrixConfiguration)) {
            LOGGER.log(Level.SEVERE, "Log rotator got a job with a wrong type. {0} of {1}", new Object[]{_job.getFullName(), _job.getClass()});
        }
        MatrixConfiguration job = (MatrixConfiguration)_job;
        for (MatrixRun r : job.getBuilds()) {
            if (job.getParent().getBuildByNumber(r.getNumber()) != null) continue;
            LOGGER.log(Level.FINE, "Deleting {0}", r.getFullDisplayName());
            r.delete();
        }
        if (!job.isActiveConfiguration() && job.getLastBuild() == null) {
            LOGGER.log(Level.FINE, "Deleting {0} because the configuration is inactive and there''s no builds", job.getFullDisplayName());
            job.delete();
        }
    }
}

