/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.EnvVars;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.LabelAxis;
import hudson.matrix.LabelExpAxis;
import hudson.matrix.LinkedLogRotator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.matrix.Messages;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.SCMedItem;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.LogRotator;
import hudson.tasks.Publisher;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.BuildDiscarder;
import jenkins.model.Jenkins;
import jenkins.scm.SCMCheckoutStrategy;
import org.kohsuke.stapler.HttpResponse;

public class MatrixConfiguration
extends Project<MatrixConfiguration, MatrixRun>
implements SCMedItem,
Queue.NonBlockingTask {
    private static final Logger LOGGER = Logger.getLogger(MatrixConfiguration.class.getName());
    private transient Combination combination;
    private transient String digestName;
    public static boolean useShortWorkspaceName = Boolean.getBoolean(MatrixConfiguration.class.getName() + ".useShortWorkspaceName");

    public MatrixConfiguration(MatrixProject parent, Combination c) {
        super((ItemGroup)parent, c.toString());
        this.setCombination(c);
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, this.combination.toString());
    }

    public EnvVars getEnvironment(Node node, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = super.getEnvironment(node, listener);
        AxisList axes = this.getParent().getAxes();
        for (Map.Entry e : this.getCombination().entrySet()) {
            Axis a = axes.find((String)e.getKey());
            if (a != null) {
                a.addBuildVariable((String)e.getValue(), (Map<String, String>)env);
                continue;
            }
            env.put((String)e.getKey(), (String)e.getValue());
        }
        return env;
    }

    public final boolean isDisabled() {
        return this.getParent().isDisabled();
    }

    public final void makeDisabled(boolean b) throws IOException {
        super.makeDisabled(this.getParent().isDisabled());
    }

    public final boolean supportsMakeDisabled() {
        return false;
    }

    public final HttpResponse doDisable() throws IOException, ServletException {
        return HttpResponses.errorWithoutStack((int)405, (String)Messages.MatrixConfiguration_DisableNotAllowed());
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    public boolean isConcurrentBuild() {
        return this.getParent().isConcurrentBuild();
    }

    public void setConcurrentBuild(boolean b) throws IOException {
        throw new UnsupportedOperationException("The setting can be only changed at MatrixProject");
    }

    public void delete() throws IOException, InterruptedException {
        if (this.getParent().getActiveConfigurations().contains((Object)this)) {
            return;
        }
        super.delete();
    }

    void setCombination(Combination c) {
        this.combination = c;
        this.digestName = c.digest().substring(0, 8);
    }

    public int getNextBuildNumber() {
        MatrixBuild lcb = (MatrixBuild)this.getParent().getLastCompletedBuild();
        if (lcb == null) {
            return 0;
        }
        int n = lcb.getNumber() + 1;
        MatrixRun lb = (MatrixRun)this.getLastBuild();
        if (lb != null) {
            n = Math.max(n, lb.getNumber() + 1);
        }
        return n;
    }

    public int assignBuildNumber() throws IOException {
        int nb = this.getNextBuildNumber();
        MatrixRun r = (MatrixRun)this.getLastBuild();
        if (r != null && r.getNumber() >= nb) {
            throw new IllegalStateException("Build #" + nb + " is already completed");
        }
        return nb;
    }

    public String getDisplayName() {
        return this.combination.toCompactString(this.getParent().getAxes());
    }

    public MatrixProject getParent() {
        return (MatrixProject)super.getParent();
    }

    public Combination getCombination() {
        return this.combination;
    }

    public int getQuietPeriod() {
        return 0;
    }

    public int getScmCheckoutRetryCount() {
        return this.getParent().getScmCheckoutRetryCount();
    }

    public SCMCheckoutStrategy getScmCheckoutStrategy() {
        return this.getParent().getScmCheckoutStrategy();
    }

    public boolean isConfigurable() {
        return false;
    }

    protected Class<MatrixRun> getBuildClass() {
        return MatrixRun.class;
    }

    protected MatrixRun newBuild() throws IOException {
        List actions = Executor.currentExecutor().getCurrentWorkUnit().context.actions;
        ParentBuildAction a = null;
        for (Action _a : actions) {
            if (!(_a instanceof ParentBuildAction)) continue;
            a = (ParentBuildAction)_a;
            break;
        }
        if (a == null) {
            LOGGER.log(Level.WARNING, "JENKINS-26582: ignoring apparent attempt to trigger {0} without its parent", this.getFullName());
            return null;
        }
        MatrixBuild lb = a.parent;
        if (lb == null) {
            lb = (MatrixBuild)this.getParent().getLastBuild();
            if (lb == null) {
                LOGGER.log(Level.WARNING, "cannot start a build of {0} since its parent has no builds at all", this.getFullName());
                return null;
            }
            LOGGER.log(Level.WARNING, "guessing that the correct build of {0} is #{1}", new Object[]{this.getFullName(), lb.getNumber()});
        }
        MatrixRun lastBuild = new MatrixRun(this, lb.getTimestamp());
        lastBuild.number = lb.getNumber();
        this._getRuns().put((Run)lastBuild);
        return lastBuild;
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
    }

    public MatrixConfiguration asProject() {
        return this;
    }

    public Label getAssignedLabel() {
        String exprSlave = Util.join(this.combination.values(this.getParent().getAxes().subList(LabelAxis.class)), (String)"&&");
        String exprLabel = Util.join(this.combination.values(this.getParent().getAxes().subList(LabelExpAxis.class)), (String)"&&");
        String expr = !exprSlave.equals("") && !exprLabel.equals("") ? exprSlave + "&&" + exprLabel : (exprSlave.equals("") ? exprLabel : exprSlave);
        return Jenkins.getInstance().getLabel(Util.fixEmpty((String)expr));
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)Messages.MatrixConfiguration_Pronoun());
    }

    public JDK getJDK() {
        return Jenkins.getInstance().getJDK((String)this.combination.get("jdk"));
    }

    public List<Builder> getBuilders() {
        return this.getParent().getBuilders();
    }

    public Map<Descriptor<Publisher>, Publisher> getPublishers() {
        return this.getParent().getPublishers();
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersList() {
        return this.getParent().getBuildersList();
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.getParent().getPublishersList();
    }

    public Map<Descriptor<BuildWrapper>, BuildWrapper> getBuildWrappers() {
        return this.getParent().getBuildWrappers();
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.getParent().getBuildWrappersList();
    }

    public Publisher getPublisher(Descriptor<Publisher> descriptor) {
        return this.getParent().getPublisher(descriptor);
    }

    public BuildDiscarder getBuildDiscarder() {
        BuildDiscarder bd = this.getParent().getBuildDiscarder();
        if (bd instanceof LogRotator) {
            LogRotator lr = (LogRotator)bd;
            return new LinkedLogRotator(lr.getArtifactDaysToKeep(), lr.getArtifactNumToKeep());
        }
        return new LinkedLogRotator();
    }

    public SCM getScm() {
        return this.getParent().getScm();
    }

    String getDigestName() {
        return this.digestName;
    }

    public void setJDK(JDK jdk) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setBuildDiscarder(BuildDiscarder logRotator) {
        throw new UnsupportedOperationException();
    }

    public boolean isActiveConfiguration() {
        return this.getParent().getActiveConfigurations().contains((Object)this);
    }

    public boolean scheduleBuild(ParametersAction parameters) {
        return this.scheduleBuild(parameters, (Cause)new Cause.LegacyCodeCause());
    }

    public boolean scheduleBuild(ParametersAction parameters, Cause c) {
        return this.scheduleBuild(Collections.singletonList(parameters), c);
    }

    public boolean scheduleBuild(List<? extends Action> actions, Cause c) {
        ArrayList<Object> allActions = new ArrayList<Object>();
        if (actions != null) {
            allActions.addAll(actions);
        }
        allActions.add((Object)new ParentBuildAction());
        allActions.add(new CauseAction(c));
        return Jenkins.getInstance().getQueue().schedule2((Queue.Task)this, this.getQuietPeriod(), allActions).isAccepted();
    }

    public static class ParentBuildAction
    extends InvisibleAction
    implements Queue.QueueAction {
        public transient MatrixBuild parent = (MatrixBuild)Executor.currentExecutor().getCurrentExecutable();

        public boolean shouldSchedule(List<Action> actions) {
            return true;
        }
    }
}

