/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.Messages;
import hudson.model.labels.LabelAtom;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class LabelAxis
extends Axis {
    @DataBoundConstructor
    public LabelAxis(String name, List<String> values) {
        super(name, values);
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public String getValueString() {
        return Util.join(this.getValues(), (String)"/");
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Messages.LabelAxis_DisplayName();
        }

        @Override
        public boolean isInstantiable() {
            Jenkins h = Jenkins.getInstance();
            return !h.getNodes().isEmpty() || !h.clouds.isEmpty();
        }

        private String jsstr(String body, Object ... args) {
            return '\"' + Functions.jsStringEscape((String)String.format(body, args)) + '\"';
        }

        public String buildLabelCheckBox(LabelAtom la, LabelAxis instance) {
            return this.jsstr("<input type='checkbox' name='values' json='%s' ", Functions.htmlAttributeEscape((String)la.getName())) + String.format("+has(%s)+", this.jsstr(la.getName(), new Object[0])) + this.jsstr("/><label class='attach-previous'>%s (%s)</label>", la.getName(), la.getDescription());
        }
    }
}

