/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import java.util.Map;

class FilterScript {
    private final Script script;
    private static final Script EMPTY = new Script(){

        public Object run() {
            return true;
        }
    };
    static final FilterScript ACCEPT_ALL = new FilterScript(EMPTY){

        public boolean apply(MatrixBuild.MatrixBuildExecution context, Combination combination) {
            return true;
        }
    };
    static final FilterScript REJECT_ALL = new FilterScript(EMPTY){

        public boolean apply(MatrixBuild.MatrixBuildExecution context, Combination combination) {
            return false;
        }
    };

    FilterScript(Script script) {
        this.script = script;
    }

    boolean evaluate(Binding context) {
        this.script.setBinding(context);
        return Boolean.TRUE.equals(this.script.run());
    }

    private long toModuloIndex(AxisList axis, Combination c) {
        long r = 0L;
        for (Axis a : axis) {
            r += (long)a.indexOf(c.get(a));
            r *= 31L;
        }
        return r;
    }

    public boolean apply(MatrixBuild.MatrixBuildExecution context, Combination combination) {
        return this.apply(((MatrixProject)context.getProject()).getAxes(), combination, this.getConfiguredBinding(context));
    }

    boolean apply(AxisList axes, Combination c, Binding binding) {
        for (Map.Entry e : c.entrySet()) {
            binding.setVariable((String)e.getKey(), e.getValue());
        }
        binding.setVariable("index", (Object)this.toModuloIndex(axes, c));
        binding.setVariable("uniqueId", (Object)c.toIndex(axes));
        return this.evaluate(binding);
    }

    private Binding getConfiguredBinding(MatrixBuild.MatrixBuildExecution execution) {
        Binding binding = new Binding();
        ParametersAction parameters = (ParametersAction)((MatrixBuild)execution.getBuild()).getAction(ParametersAction.class);
        if (parameters == null) {
            return binding;
        }
        for (ParameterValue pv : parameters) {
            if (pv == null) continue;
            String name = pv.getName();
            String value = (String)pv.createVariableResolver(null).resolve(name);
            binding.setVariable(name, (Object)value);
        }
        return binding;
    }

    public static FilterScript parse(String expression) {
        return FilterScript.parse(expression, ACCEPT_ALL);
    }

    public static FilterScript parse(String expression, FilterScript defaultScript) {
        if (Util.fixEmptyAndTrim((String)expression) == null) {
            return defaultScript;
        }
        GroovyShell shell = new GroovyShell(FilterScript.class.getClassLoader());
        return new FilterScript(shell.parse("use(" + Combination.BooleanCategory.class.getName().replace('$', '.') + ") {" + expression + "}"));
    }
}

