/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.Extension;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;

class FilterScript {
    private final Script script;
    static final FilterScript ACCEPT_ALL = new FilterScript(null){

        @Override
        public boolean apply(AxisList axes, Combination combination, Binding binding) {
            return true;
        }
    };
    static final FilterScript REJECT_ALL = new FilterScript(null){

        @Override
        public boolean apply(AxisList axes, Combination combination, Binding binding) {
            return false;
        }
    };

    FilterScript(Script script) {
        this.script = script;
    }

    private boolean evaluate(Binding context) {
        this.script.setBinding(context);
        try {
            return Boolean.TRUE.equals(GroovySandbox.run((Script)this.script, (Whitelist)Whitelist.all()));
        }
        catch (RejectedAccessException x) {
            throw ScriptApproval.get().accessRejected(x, ApprovalContext.create());
        }
    }

    private long toModuloIndex(AxisList axis, Combination c) {
        long r = 0L;
        for (Axis a : axis) {
            r += (long)a.indexOf(c.get(a));
            r *= 31L;
        }
        return r;
    }

    public final boolean apply(MatrixBuild.MatrixBuildExecution context, Combination combination) {
        return this.apply(((MatrixProject)context.getProject()).getAxes(), combination, this.getConfiguredBinding(context));
    }

    boolean apply(AxisList axes, Combination c, Binding binding) {
        for (Map.Entry e : c.entrySet()) {
            binding.setVariable((String)e.getKey(), e.getValue());
        }
        binding.setVariable("index", (Object)this.toModuloIndex(axes, c));
        binding.setVariable("uniqueId", (Object)c.toIndex(axes));
        return this.evaluate(binding);
    }

    private Binding getConfiguredBinding(MatrixBuild.MatrixBuildExecution execution) {
        Binding binding = new Binding();
        ParametersAction parameters = (ParametersAction)((MatrixBuild)execution.getBuild()).getAction(ParametersAction.class);
        if (parameters == null) {
            return binding;
        }
        for (ParameterValue pv : parameters) {
            if (pv == null) continue;
            String name = pv.getName();
            String value = (String)pv.createVariableResolver((AbstractBuild)execution.getBuild()).resolve(name);
            binding.setVariable(name, (Object)value);
        }
        return binding;
    }

    public static FilterScript parse(String expression) {
        return FilterScript.parse(expression, ACCEPT_ALL);
    }

    public static FilterScript parse(String expression, FilterScript defaultScript) {
        if (Util.fixEmptyAndTrim((String)expression) == null) {
            return defaultScript;
        }
        GroovyShell shell = new GroovyShell(GroovySandbox.createSecureClassLoader((ClassLoader)FilterScript.class.getClassLoader()), new Binding(), GroovySandbox.createSecureCompilerConfiguration());
        return new FilterScript(shell.parse(expression));
    }

    @Extension
    public static class ImpliesWhitelist
    extends ProxyWhitelist {
        public ImpliesWhitelist() throws IOException {
            super(new Whitelist[]{new StaticWhitelist(new String[]{"staticMethod org.codehaus.groovy.runtime.DefaultGroovyMethods implies java.lang.Boolean java.lang.Boolean"})});
        }
    }
}

