/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.DefaultMatrixExecutionStrategyImpl;
import hudson.matrix.LabelAxis;
import hudson.matrix.Layouter;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixConfigurationSorter;
import hudson.matrix.MatrixConfigurationSorterDescriptor;
import hudson.matrix.MatrixExecutionStrategy;
import hudson.matrix.MatrixExecutionStrategyDescriptor;
import hudson.matrix.MatrixRun;
import hudson.matrix.Messages;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.SCMedItem;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.triggers.Trigger;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.scm.SCMCheckoutStrategyDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.TokenList;
import org.kohsuke.stapler.export.Exported;

public class MatrixProject
extends AbstractProject<MatrixProject, MatrixBuild>
implements TopLevelItem,
SCMedItem,
ItemGroup<MatrixConfiguration>,
Saveable,
Queue.FlyweightTask,
BuildableItemWithBuildWrappers {
    private volatile AxisList axes = new AxisList();
    private volatile String combinationFilter;
    private DescribableList<Builder, Descriptor<Builder>> builders = new DescribableList((Saveable)this);
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    private transient Map<Combination, MatrixConfiguration> configurations = new CopyOnWriteMap.Tree();
    private transient Set<MatrixConfiguration> activeConfigurations = new LinkedHashSet<MatrixConfiguration>();
    @Deprecated
    private transient Boolean runSequentially;
    @Deprecated
    private transient String touchStoneCombinationFilter;
    @Deprecated
    private transient Result touchStoneResultCondition;
    @Deprecated
    private transient MatrixConfigurationSorter sorter;
    private MatrixExecutionStrategy executionStrategy;
    private String childCustomWorkspace;
    private transient Lock buildLock = new ReentrantLock();
    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(MatrixProject.class.getName());

    public MatrixProject(String name) {
        this((ItemGroup)Jenkins.getInstance(), name);
    }

    public MatrixProject(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected Object readResolve() {
        this.buildLock = new ReentrantLock();
        return this;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)Messages.MatrixProject_Pronoun());
    }

    public String getChildCustomWorkspace() {
        String ws = this.childCustomWorkspace;
        if (ws == null) {
            ws = MatrixConfiguration.useShortWorkspaceName ? "${SHORT_COMBINATION}" : "${COMBINATION}";
        }
        return ws;
    }

    public boolean hasChildCustomWorkspace() {
        return this.childCustomWorkspace != null;
    }

    public void setChildCustomWorkspace(String childCustomWorkspace) throws IOException {
        this.childCustomWorkspace = Util.fixEmptyAndTrim((String)childCustomWorkspace);
        this.save();
    }

    public Set<Label> getRelevantLabels() {
        HashSet<Label> r = new HashSet<Label>();
        for (MatrixConfiguration c : this.getActiveConfigurations()) {
            r.add(c.getAssignedLabel());
        }
        return r;
    }

    @Deprecated
    public MatrixConfigurationSorter getSorter() {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            return dm.getSorter();
        }
        return null;
    }

    @Deprecated
    public void setSorter(MatrixConfigurationSorter sorter) throws IOException {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            dm.setSorter(sorter);
            this.save();
        }
    }

    public AxisList getAxes() {
        return this.axes;
    }

    public void setAxes(AxisList axes) throws IOException {
        this.axes = new AxisList(axes);
        this.rebuildConfigurations(null);
        this.save();
    }

    public MatrixExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public void setExecutionStrategy(MatrixExecutionStrategy executionStrategy) throws IOException {
        if (executionStrategy == null) {
            throw new IllegalArgumentException();
        }
        this.executionStrategy = executionStrategy;
        this.save();
    }

    @Deprecated
    public boolean isRunSequentially() {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            return dm.isRunSequentially();
        }
        return false;
    }

    @Deprecated
    public void setRunSequentially(boolean runSequentially) throws IOException {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            dm.setRunSequentially(runSequentially);
            this.save();
        }
    }

    public void setCombinationFilter(String combinationFilter) throws IOException {
        this.combinationFilter = combinationFilter;
        this.rebuildConfigurations(null);
        this.save();
    }

    public String getCombinationFilter() {
        return this.combinationFilter;
    }

    @Deprecated
    public String getTouchStoneCombinationFilter() {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            return dm.getTouchStoneCombinationFilter();
        }
        return null;
    }

    @Deprecated
    public void setTouchStoneCombinationFilter(String touchStoneCombinationFilter) throws IOException {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            dm.setTouchStoneCombinationFilter(touchStoneCombinationFilter);
            this.save();
        }
    }

    @Deprecated
    public Result getTouchStoneResultCondition() {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            return dm.getTouchStoneResultCondition();
        }
        return null;
    }

    @Deprecated
    public void setTouchStoneResultCondition(Result touchStoneResultCondition) throws IOException {
        MatrixExecutionStrategy e = this.executionStrategy;
        if (e instanceof DefaultMatrixExecutionStrategyImpl) {
            DefaultMatrixExecutionStrategyImpl dm = (DefaultMatrixExecutionStrategyImpl)e;
            dm.setTouchStoneResultCondition(touchStoneResultCondition);
            this.save();
        }
    }

    protected List<Action> createTransientActions() {
        List r = super.createTransientActions();
        for (BuildStep step : this.builders) {
            r.addAll(step.getProjectActions((AbstractProject)this));
        }
        for (BuildStep step : this.publishers) {
            r.addAll(step.getProjectActions((AbstractProject)this));
        }
        for (BuildStep step : this.buildWrappers) {
            r.addAll(step.getProjectActions((AbstractProject)this));
        }
        for (Trigger trigger : this.triggers()) {
            r.addAll(trigger.getProjectActions());
        }
        return r;
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
        if (this.getActiveConfigurations() != null) {
            for (MatrixConfiguration configuration : this.getActiveConfigurations()) {
                configuration.updateTransientActions();
            }
        }
    }

    @Deprecated
    public List<Axis> getUserAxes() {
        ArrayList<Axis> r = new ArrayList<Axis>();
        for (Axis a : this.axes) {
            if (a.isSystem()) continue;
            r.add(a);
        }
        return r;
    }

    public Layouter<MatrixConfiguration> getLayouter() {
        return new Layouter<MatrixConfiguration>(this.axes){

            @Override
            protected MatrixConfiguration getT(Combination c) {
                return MatrixProject.this.getItem(c);
            }
        };
    }

    public void onCreatedFromScratch() {
        this.executionStrategy = new DefaultMatrixExecutionStrategyImpl();
        super.onCreatedFromScratch();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.builders.setOwner((Saveable)this);
        this.publishers.setOwner((Saveable)this);
        this.buildWrappers.setOwner((Saveable)this);
        if (this.executionStrategy == null) {
            this.executionStrategy = new DefaultMatrixExecutionStrategyImpl(this.runSequentially != null ? this.runSequentially : false, this.touchStoneCombinationFilter, this.touchStoneResultCondition, this.sorter);
        }
        this.rebuildConfigurations(null);
    }

    public void logRotate() throws IOException, InterruptedException {
        super.logRotate();
        for (MatrixConfiguration config : this.configurations.values()) {
            if (config.isActiveConfiguration()) continue;
            config.logRotate();
        }
    }

    private void loadConfigurations(File dir, CopyOnWriteMap.Tree<Combination, MatrixConfiguration> result, Map<String, String> combination) {
        File[] axisDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory() && child.getName().startsWith("axis-");
            }
        });
        if (axisDirs == null) {
            return;
        }
        for (File subdir : axisDirs) {
            String axis = subdir.getName().substring(5);
            File[] valuesDir = subdir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File child) {
                    return child.isDirectory();
                }
            });
            if (valuesDir == null) continue;
            for (File v : valuesDir) {
                HashMap<String, String> c = new HashMap<String, String>(combination);
                c.put(axis, TokenList.decode((String)v.getName()));
                try {
                    XmlFile config = Items.getConfigFile((File)v);
                    if (config.exists()) {
                        Combination comb = new Combination((Map<String, String>)c);
                        MatrixConfiguration item = null;
                        if (this.configurations != null) {
                            item = this.configurations.get(comb);
                        }
                        if (item == null) {
                            item = (MatrixConfiguration)((Object)config.read());
                            item.setCombination(comb);
                            item.onLoad(this, v.getName());
                        }
                        result.put((Object)item.getCombination(), (Object)item);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to load matrix configuration " + v, e);
                }
                this.loadConfigurations(v, result, c);
            }
        }
    }

    Set<MatrixConfiguration> rebuildConfigurations(MatrixBuild.MatrixBuildExecution context) throws IOException {
        Iterable activeCombinations;
        File[] oldDirs = this.getConfigurationsDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory() && !child.getName().startsWith("axis-");
            }
        });
        if (oldDirs != null) {
            for (File dir : oldDirs) {
                try {
                    Combination c = Combination.fromString(dir.getName());
                    File target = this.getRootDirFor(c);
                    if (dir.renameTo(target)) continue;
                    LOGGER.log(Level.WARNING, "Cannot rename directory {0} to {1}", new Object[]{dir, target});
                }
                catch (IllegalArgumentException c) {
                    // empty catch block
                }
            }
        }
        CopyOnWriteMap.Tree configurations = new CopyOnWriteMap.Tree();
        this.loadConfigurations(this.getConfigurationsDir(), (CopyOnWriteMap.Tree<Combination, MatrixConfiguration>)configurations, Collections.<String, String>emptyMap());
        this.configurations = configurations;
        if (context != null) {
            ArrayList axesList = Lists.newArrayList();
            for (Axis axis : this.axes) {
                axesList.add(Sets.newLinkedHashSet(axis.rebuild(context)));
            }
            activeCombinations = Iterables.transform((Iterable)Sets.cartesianProduct((List)axesList), (Function)new Function<List<String>, Combination>(){

                public Combination apply(@Nullable List<String> strings) {
                    assert (strings != null);
                    return new Combination(MatrixProject.this.axes, strings);
                }
            });
        } else {
            activeCombinations = this.axes.list();
        }
        LinkedHashSet<MatrixConfiguration> active = new LinkedHashSet<MatrixConfiguration>();
        boolean isDynamicFilter = this.isDynamicFilter(this.getCombinationFilter());
        for (Combination c : activeCombinations) {
            if (!isDynamicFilter && !c.evalGroovyExpression(this.axes, this.getCombinationFilter())) continue;
            LOGGER.fine("Adding configuration: " + c);
            MatrixConfiguration config = (MatrixConfiguration)((Object)configurations.get((Object)c));
            if (config == null) {
                config = new MatrixConfiguration(this, c);
                config.onCreatedFromScratch();
                config.save();
                configurations.put((Object)config.getCombination(), (Object)config);
            }
            active.add(config);
        }
        this.activeConfigurations = active;
        return active;
    }

    RunConfiguration getRunConfiguration(MatrixBuild.MatrixBuildExecution context) throws IOException {
        RunConfiguration runConfig = new RunConfiguration();
        try {
            this.buildLock.lock();
            runConfig.config = this.rebuildConfigurations(context);
            runConfig.axisList = (AxisList)Jenkins.XSTREAM.fromXML(Jenkins.XSTREAM.toXML((Object)this.axes));
        }
        finally {
            this.buildLock.unlock();
        }
        return runConfig;
    }

    private boolean isDynamicFilter(String filter) {
        if (!this.isParameterized() || filter == null) {
            return false;
        }
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)this.getProperty(ParametersDefinitionProperty.class);
        for (ParameterDefinition definition : paramDefProp.getParameterDefinitions()) {
            String name = definition.getName();
            Matcher matcher = Pattern.compile("\\b" + name + "\\b").matcher(filter);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private File getConfigurationsDir() {
        return new File(this.getRootDir(), "configurations");
    }

    @Exported
    public Collection<MatrixConfiguration> getActiveConfigurations() {
        return this.activeConfigurations;
    }

    public Collection<MatrixConfiguration> getItems() {
        return this.configurations.values();
    }

    public Collection<? extends Job> getAllJobs() {
        HashSet<MatrixConfiguration> jobs = new HashSet<MatrixConfiguration>(this.getItems());
        jobs.add((MatrixConfiguration)((Object)this));
        return jobs;
    }

    public String getUrlChildPrefix() {
        return ".";
    }

    public MatrixConfiguration getItem(String name) {
        try {
            return this.getItem(Combination.fromString(name));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public MatrixConfiguration getItem(Combination c) {
        if (this.configurations == null) {
            return null;
        }
        return this.configurations.get(c);
    }

    @Nonnull
    public File getRootDirFor(@Nonnull MatrixConfiguration child) {
        return this.getRootDirFor(child.getCombination());
    }

    public void onRenamed(MatrixConfiguration item, String oldName, String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void onDeleted(MatrixConfiguration item) throws IOException {
        if (this.activeConfigurations.contains((Object)item)) {
            LOGGER.warning("Trying to delete active configuration " + item.getDisplayName() + " of job " + this.getDisplayName() + ". Active configurations should not be deleted.");
        } else {
            this.configurations.remove(item.getCombination());
        }
    }

    @Nonnull
    public File getRootDirFor(@Nonnull Combination combination) {
        File f = this.getConfigurationsDir();
        for (Map.Entry e : combination.entrySet()) {
            f = new File(f, "axis-" + (String)e.getKey() + '/' + Util.rawEncode((String)((String)e.getValue())));
        }
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            LOGGER.log(Level.WARNING, "Cannot create directory {0} for the combination {1}", new Object[]{f, combination});
        }
        return f;
    }

    @Deprecated
    public JDK getJDK() {
        return super.getJDK();
    }

    @Nonnull
    public Set<JDK> getJDKs() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return Collections.emptySet();
        }
        Axis a = this.axes.find("jdk");
        if (a == null) {
            return Collections.emptySet();
        }
        HashSet<JDK> r = new HashSet<JDK>();
        for (String j : a) {
            JDK jdk = jenkins.getJDK(j);
            if (jdk == null) continue;
            r.add(jdk);
        }
        return r;
    }

    @Nonnull
    public Set<Label> getLabels() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return Collections.emptySet();
        }
        HashSet<Label> r = new HashSet<Label>();
        for (Combination c : this.axes.subList(LabelAxis.class).list()) {
            r.add(jenkins.getLabel(Util.join(c.values(), (String)"&&")));
        }
        return r;
    }

    public List<Builder> getBuilders() {
        return this.builders.toList();
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersList() {
        return this.builders;
    }

    public Map<Descriptor<Publisher>, Publisher> getPublishers() {
        return this.publishers.toMap();
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.publishers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.buildWrappers;
    }

    public Map<Descriptor<BuildWrapper>, BuildWrapper> getBuildWrappers() {
        return this.buildWrappers.toMap();
    }

    public Publisher getPublisher(Descriptor<Publisher> descriptor) {
        for (Publisher p : this.publishers) {
            if (p.getDescriptor() != descriptor) continue;
            return p;
        }
        return null;
    }

    protected Class<MatrixBuild> getBuildClass() {
        return MatrixBuild.class;
    }

    public boolean isFingerprintConfigured() {
        return false;
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        super.buildDependencyGraph(graph);
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        this.builders.buildDependencyGraph((AbstractProject)this, graph);
        this.buildWrappers.buildDependencyGraph((AbstractProject)this, graph);
    }

    public MatrixProject asProject() {
        return this;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        try {
            MatrixConfiguration item = this.getItem(token);
            if (item != null) {
                return item;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return super.getDynamic(token, req, rsp);
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.combinationFilter = req.getParameter("hasCombinationFilter") != null ? Util.nullify((String)req.getParameter("combinationFilter")) : null;
        if (json.optBoolean("hasChildCustomWorkspace", json.has("childCustomWorkspace"))) {
            this.setChildCustomWorkspace(Util.fixEmptyAndTrim((String)json.optString("childCustomWorkspace")));
        } else {
            this.setChildCustomWorkspace(null);
        }
        List<MatrixExecutionStrategyDescriptor> esd = this.getDescriptor().getExecutionStrategyDescriptors();
        this.executionStrategy = esd.size() > 1 ? (MatrixExecutionStrategy)((Object)req.bindJSON(MatrixExecutionStrategy.class, json.getJSONObject("executionStrategy"))) : (MatrixExecutionStrategy)((Object)req.bindJSON(esd.get((int)0).clazz, json.getJSONObject("executionStrategy")));
        DescribableList newAxes = new DescribableList((Saveable)this);
        newAxes.rebuildHetero(req, json, Axis.all(), "axis");
        this.checkAxes((Iterable<Axis>)newAxes);
        this.axes = new AxisList(newAxes.toList());
        this.buildWrappers.rebuild(req, json, BuildWrappers.getFor((AbstractProject)this));
        this.builders.rebuildHetero(req, json, (Collection)Builder.all(), "builder");
        this.publishers.rebuildHetero(req, json, (Collection)Publisher.all(), "publisher");
        this.rebuildConfigurations(null);
    }

    public AggregatedTestResultAction getAggregatedTestResultAction() {
        MatrixBuild b = (MatrixBuild)this.getLastCompletedBuild();
        return b != null ? (AggregatedTestResultAction)b.getAction(AggregatedTestResultAction.class) : null;
    }

    private void checkAxes(Iterable<Axis> newAxes) throws Descriptor.FormException {
        HashSet<String> axisNames = new HashSet<String>();
        for (Axis a : newAxes) {
            AxisDescriptor desc = a.getDescriptor();
            FormValidation fv = desc.doCheckName(a.getName());
            if (fv.kind != FormValidation.Kind.OK) {
                String msg = Messages.MatrixProject_InvalidAxisName(a.getName(), fv.getMessage());
                throw new Descriptor.FormException(msg, (Throwable)fv, "axis.name");
            }
            for (String value : a.getValues()) {
                fv = desc.checkValue(value);
                if (fv.kind == FormValidation.Kind.OK) continue;
                String msg = Messages.MatrixProject_InvalidAxisValue(value, fv.getMessage());
                throw new Descriptor.FormException(msg, (Throwable)fv, "axis.value");
            }
            if (axisNames.contains(a.getName())) {
                throw new Descriptor.FormException(Messages.MatrixProject_DuplicateAxisName(), "axis.name");
            }
            axisNames.add(a.getName());
        }
    }

    public HttpResponse doDoWipeOutWorkspace() throws IOException, ServletException, InterruptedException {
        HttpResponse rsp = super.doDoWipeOutWorkspace();
        for (MatrixConfiguration c : this.configurations.values()) {
            c.doDoWipeOutWorkspace();
        }
        return rsp;
    }

    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (MatrixConfiguration c : this.getActiveConfigurations()) {
            menu.add((Job)c);
        }
        return menu;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Initializer(before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void alias() {
        Items.XSTREAM.alias("matrix-project", MatrixProject.class);
        Items.XSTREAM.alias("axis", Axis.class);
        Items.XSTREAM.alias("matrix-config", MatrixConfiguration.class);
        Run.XSTREAM.alias("matrix-build", MatrixBuild.class);
        Run.XSTREAM.alias("matrix-run", MatrixRun.class);
    }

    public static final class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor {
        public String getDisplayName() {
            return Messages.MatrixProject_DisplayName();
        }

        public String getCategoryId() {
            return "standalone-projects";
        }

        public String getDescription() {
            return Messages.MatrixProject_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/matrix-project/images/:size/matrixproject.png";
        }

        public MatrixProject newInstance(ItemGroup parent, String name) {
            return new MatrixProject(parent, name);
        }

        public List<AxisDescriptor> getAxisDescriptors() {
            ArrayList<AxisDescriptor> r = new ArrayList<AxisDescriptor>();
            for (AxisDescriptor d : Axis.all()) {
                if (!d.isInstantiable()) continue;
                r.add(d);
            }
            return r;
        }

        @Deprecated
        public List<MatrixConfigurationSorterDescriptor> getSorterDescriptors() {
            return MatrixConfigurationSorterDescriptor.all();
        }

        public List<MatrixExecutionStrategyDescriptor> getExecutionStrategyDescriptors() {
            return MatrixExecutionStrategyDescriptor.all();
        }

        public List<SCMCheckoutStrategyDescriptor> getMatrixRunCheckoutStrategyDescriptors() {
            return SCMCheckoutStrategyDescriptor.all();
        }
    }

    static class RunConfiguration {
        public Set<MatrixConfiguration> config;
        public AxisList axisList;

        RunConfiguration() {
        }
    }
}

