/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import groovy.lang.Binding;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.FilterScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Combination
extends TreeMap<String, String>
implements Comparable<Combination> {
    public Combination(AxisList axisList, List<String> values) {
        for (int i = 0; i < axisList.size(); ++i) {
            super.put(((Axis)axisList.get(i)).getName(), values.get(i));
        }
    }

    public Combination(AxisList axisList, String ... values) {
        this(axisList, Arrays.asList(values));
    }

    public Combination(Map<String, String> keyValuePairs) {
        for (Map.Entry<String, String> e : keyValuePairs.entrySet()) {
            super.put(e.getKey(), e.getValue());
        }
    }

    public String get(Axis a) {
        return (String)this.get(a.getName());
    }

    public int toIndex(AxisList axis) {
        int r = 0;
        for (Axis a : axis) {
            r *= a.size();
            r += a.indexOf(this.get(a));
        }
        return r;
    }

    public boolean evalGroovyExpression(AxisList axes, String expression) {
        return this.evalGroovyExpression(axes, expression, new Binding());
    }

    public boolean evalGroovyExpression(AxisList axes, String expression, Binding binding) {
        return FilterScript.parse(expression).apply(axes, this, binding);
    }

    @Override
    public int compareTo(Combination that) {
        int d = this.size() - that.size();
        if (d != 0) {
            return d;
        }
        Iterator itr = this.entrySet().iterator();
        Iterator jtr = that.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry i = itr.next();
            Map.Entry j = jtr.next();
            d = ((String)i.getKey()).compareTo((String)j.getKey());
            if (d != 0) {
                return d;
            }
            d = ((String)i.getValue()).compareTo((String)j.getValue());
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public String toString(Collection<Axis> subset) {
        if (this.size() == 1 && subset.size() == 1) {
            return (String)this.values().iterator().next();
        }
        StringBuilder buf = new StringBuilder();
        for (Axis a : subset) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(a.getName()).append('=').append(this.get(a));
        }
        if (buf.length() == 0) {
            buf.append("default");
        }
        return buf.toString();
    }

    public List<String> values(Collection<? extends Axis> axes) {
        ArrayList<String> r = new ArrayList<String>(axes.size());
        for (Axis axis : axes) {
            r.add(this.get(axis));
        }
        return r;
    }

    public String toString(char sep1, char sep2) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry e : this.entrySet()) {
            if (buf.length() > 0) {
                buf.append(sep1);
            }
            buf.append((String)e.getKey()).append(sep2).append((String)e.getValue());
        }
        if (buf.length() == 0) {
            buf.append("default");
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(',', '=');
    }

    public String digest() {
        return Util.getDigestOf((String)this.toString());
    }

    public static Combination fromString(String id) {
        if (id.equals("default")) {
            return new Combination(Collections.<String, String>emptyMap());
        }
        HashMap<String, String> m = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(id, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                throw new IllegalArgumentException("Can't parse " + id);
            }
            m.put(token.substring(0, idx), token.substring(idx + 1));
        }
        return new Combination((Map<String, String>)m);
    }

    public String toCompactString(AxisList axes) {
        HashSet<String> nonUniqueAxes = new HashSet<String>();
        HashMap<String, Axis> axisByValue = new HashMap<String, Axis>();
        for (Axis a : axes) {
            for (String v : a.getValues()) {
                Axis old = axisByValue.put(v, a);
                if (old == null) continue;
                nonUniqueAxes.add(old.getName());
                nonUniqueAxes.add(a.getName());
            }
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry e : this.entrySet()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            if (nonUniqueAxes.contains(e.getKey())) {
                buf.append((String)e.getKey()).append('=');
            }
            buf.append((String)e.getValue());
        }
        if (buf.length() == 0) {
            buf.append("default");
        }
        return buf.toString();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public static final class BooleanCategory {
        public static Boolean implies(Boolean lhs, Boolean rhs) {
            return lhs == false || rhs != false;
        }
    }
}

