/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.integrations.casc;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.integrations.casc.DefinitionEntry;
import org.jenkinsci.plugins.matrixauth.integrations.casc.PermissionDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class MatrixAuthorizationStrategyConfigurator<T extends AuthorizationContainer>
extends BaseConfigurator<T> {
    private static final Logger LOGGER = Logger.getLogger(MatrixAuthorizationStrategyConfigurator.class.getName());

    @NonNull
    public Class<?> getImplementedAPI() {
        return AuthorizationStrategy.class;
    }

    @NonNull
    public Set<Attribute<T, ?>> describe() {
        return new HashSet(Arrays.asList(new MultivaluedAttribute("entries", DefinitionEntry.class).getter(MatrixAuthorizationStrategyConfigurator::getEntries).setter(MatrixAuthorizationStrategyConfigurator::setEntries), new MultivaluedAttribute("permissions", String.class).getter(unused -> null).setter(MatrixAuthorizationStrategyConfigurator::setLegacyPermissions), new MultivaluedAttribute("grantedPermissions", String.class).getter(unused -> null).setter(MatrixAuthorizationStrategyConfigurator::setPermissionsDeprecated)));
    }

    public static Collection<DefinitionEntry> getEntries(AuthorizationContainer container) {
        Map<Permission, Set<PermissionEntry>> entries = container.getGrantedPermissionEntries();
        HashMap intermediate = entries.entrySet().stream().map(entry -> Map.entry(PermissionDefinition.forPermission((Permission)entry.getKey()), (Set)entry.getValue())).flatMap(entry -> ((Set)entry.getValue()).stream().map(p -> new PermissionAssignment((PermissionDefinition)entry.getKey(), (PermissionEntry)p))).collect(HashMap::new, (c, e) -> c.computeIfAbsent(e.getEntry(), f -> new ArrayList()).add(e.getPermission()), (c1, c2) -> {});
        List<DefinitionEntry> result = intermediate.entrySet().stream().map(entry -> new DefinitionEntry(((PermissionEntry)entry.getKey()).getType(), new DefinitionEntry.Child(((PermissionEntry)entry.getKey()).getSid(), (List)entry.getValue()))).sorted(Comparator.comparing(DefinitionEntry::permissionEntry)).collect(Collectors.toList());
        return result;
    }

    public static void setEntries(AuthorizationContainer container, Collection<DefinitionEntry> entries) {
        entries.forEach(e -> e.child().getPermissions().stream().map(PermissionDefinition::getPermission).forEach(p -> container.add((Permission)p, e.permissionEntry())));
    }

    public static Collection<String> getLegacyPermissions(AuthorizationContainer container) {
        return container.getGrantedPermissionEntries().entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(v -> v.getType().toPrefix() + ((Permission)e.getKey()).group.getId() + "/" + ((Permission)e.getKey()).name + ":" + v.getSid())).sorted().collect(Collectors.toList());
    }

    public static void setLegacyPermissions(AuthorizationContainer container, Collection<String> permissions) {
        LOGGER.log(Level.WARNING, "Loading deprecated attribute 'permissions' for instance of '" + container.getClass().getName() + "'. Use 'entries' instead.");
        permissions.forEach(container::add);
    }

    public static void setPermissionsDeprecated(AuthorizationContainer container, Collection<String> permissions) {
        LOGGER.log(Level.WARNING, "Loading deprecated attribute 'grantedPermissions' for instance of '" + container.getClass().getName() + "'. Use 'permissions' instead.");
        MatrixAuthorizationStrategyConfigurator.setLegacyPermissions(container, permissions);
    }

    private static class PermissionAssignment {
        private final PermissionDefinition permission;
        private final PermissionEntry entry;

        private PermissionAssignment(PermissionDefinition permission, PermissionEntry entry) {
            this.permission = permission;
            this.entry = entry;
        }

        public PermissionDefinition getPermission() {
            return this.permission;
        }

        public PermissionEntry getEntry() {
            return this.entry;
        }
    }
}

