/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.properties;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.properties.FolderContributor;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.listeners.ItemListener;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.AbstractAuthorizationPropertyConverter;
import org.jenkinsci.plugins.matrixauth.AuthorizationProperty;
import org.jenkinsci.plugins.matrixauth.AuthorizationPropertyDescriptor;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritParentStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.GET;

public class AuthorizationMatrixProperty
extends AbstractFolderProperty<AbstractFolder<?>>
implements AuthorizationProperty {
    private final transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<PermissionEntry>> grantedPermissions = new HashMap<Permission, Set<PermissionEntry>>();
    private final Set<String> groupSids = Collections.synchronizedSet(new HashSet());
    @Deprecated
    private transient Boolean blocksInheritance;
    private InheritanceStrategy inheritanceStrategy = new InheritParentStrategy();
    private static final Logger LOGGER = Logger.getLogger(AuthorizationMatrixProperty.class.getName());

    protected AuthorizationMatrixProperty() {
    }

    @Deprecated
    public AuthorizationMatrixProperty(Map<Permission, ? extends Set<String>> grantedPermissions) {
        for (Map.Entry<Permission, ? extends Set<String>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), e.getValue().stream().map(sid -> new PermissionEntry(AuthorizationType.EITHER, (String)sid)).collect(Collectors.toSet()));
        }
    }

    @DataBoundConstructor
    @Restricted(value={DoNotUse.class})
    public AuthorizationMatrixProperty(List<AuthorizationProperty.DslEntry> entries) {
        this.setEntries(entries);
    }

    @Override
    public Set<String> getGroups() {
        return this.groupSids;
    }

    @Override
    public void recordGroup(String sid) {
        this.groupSids.add(sid);
    }

    @Override
    public Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries() {
        return this.grantedPermissions;
    }

    @Override
    public Permission getEditingPermission() {
        return Item.CONFIGURE;
    }

    protected void setOwner(@NonNull AbstractFolder<?> owner) {
        super.setOwner(owner);
        FolderContributor.record(owner);
    }

    @Override
    @Restricted(value={DoNotUse.class})
    public List<AuthorizationProperty.DslEntry> getEntries() {
        return AuthorizationProperty.super.getEntries();
    }

    public SidACL getACL() {
        return this.acl;
    }

    @Override
    @DataBoundSetter
    public void setInheritanceStrategy(InheritanceStrategy inheritanceStrategy) {
        this.inheritanceStrategy = inheritanceStrategy;
    }

    @Override
    public InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Because that is the way this SPI works")
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixProperty.this.hasPermission(this.toString(sid), p, sid instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }

    @Extension(optional=true)
    @Restricted(value={NoExternalUse.class})
    public static class ItemListenerImpl
    extends ItemListener {
        public void onCreated(Item item) {
            AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
            if (authorizationStrategy instanceof ProjectMatrixAuthorizationStrategy) {
                ProjectMatrixAuthorizationStrategy strategy = (ProjectMatrixAuthorizationStrategy)authorizationStrategy;
                if (item instanceof AbstractFolder) {
                    User current;
                    String sid;
                    boolean propIsNew;
                    AbstractFolder folder = (AbstractFolder)item;
                    AuthorizationMatrixProperty prop = (AuthorizationMatrixProperty)folder.getProperties().get(AuthorizationMatrixProperty.class);
                    boolean bl = propIsNew = prop == null;
                    if (propIsNew) {
                        prop = new AuthorizationMatrixProperty();
                    }
                    String string = sid = (current = User.current()) == null ? "anonymous" : current.getId();
                    if (!strategy.getACL((AbstractItem)folder).hasPermission2(Jenkins.getAuthentication2(), Item.READ)) {
                        prop.add(Item.READ, PermissionEntry.user(sid));
                    }
                    if (!strategy.getACL((AbstractItem)folder).hasPermission2(Jenkins.getAuthentication2(), Item.CONFIGURE)) {
                        prop.add(Item.CONFIGURE, PermissionEntry.user(sid));
                    }
                    if (prop.getGrantedPermissionEntries().size() > 0) {
                        try {
                            if (propIsNew) {
                                folder.addProperty((AbstractFolderProperty)prop);
                            } else {
                                folder.save();
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, "Failed to grant creator permissions on folder " + item.getFullName(), ex);
                        }
                    }
                }
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    public static final class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AuthorizationMatrixProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixProperty.class;
        }

        @Override
        public AuthorizationMatrixProperty create() {
            return new AuthorizationMatrixProperty();
        }
    }

    @Extension(optional=true)
    @Symbol(value={"authorizationMatrix"})
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor
    implements AuthorizationPropertyDescriptor<AuthorizationMatrixProperty> {
        @Override
        public AuthorizationMatrixProperty create() {
            return new AuthorizationMatrixProperty();
        }

        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.ITEM_GROUP;
        }

        public AuthorizationMatrixProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (AuthorizationMatrixProperty)this.createNewInstance(req, formData, true);
        }

        public boolean isApplicable(Class<? extends AbstractFolder> folder) {
            return this.isApplicable();
        }

        @GET
        public FormValidation doCheckName(@AncestorInPath AbstractFolder<?> folder, @QueryParameter String value) {
            return this.doCheckName_(value, (AccessControlled)folder, Item.CONFIGURE);
        }
    }
}

