/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;

public class NonInheritingStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public NonInheritingStrategy() {
    }

    @Override
    protected boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission, ACL child, @CheckForNull ACL parent, ACL root) {
        if (a.equals(ACL.SYSTEM2)) {
            return true;
        }
        if (NonInheritingStrategy.isUltimatelyImpliedByAdminister(permission) && root.hasPermission2(a, Jenkins.ADMINISTER)) {
            return true;
        }
        if (NonInheritingStrategy.isParentReadPermissionRequired() && parent != null && (Item.READ.equals((Object)permission) || Item.DISCOVER.equals((Object)permission))) {
            return parent.hasPermission2(a, permission) && child.hasPermission2(a, permission);
        }
        return child.hasPermission2(a, permission);
    }

    private static boolean isUltimatelyImpliedByAdminister(Permission permission) {
        while (permission.impliedBy != null) {
            permission = permission.impliedBy;
        }
        return permission == Jenkins.ADMINISTER;
    }

    @Symbol(value={"nonInheriting"})
    @Extension(ordinal=-100.0)
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.NonInheritingStrategy_DisplayName();
        }
    }
}

