/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.integrations.casc;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class MatrixAuthorizationStrategyConfigurator<T extends AuthorizationContainer>
extends BaseConfigurator<T> {
    private static final Logger LOGGER = Logger.getLogger(MatrixAuthorizationStrategyConfigurator.class.getName());

    @NonNull
    public Class<?> getImplementedAPI() {
        return AuthorizationStrategy.class;
    }

    @NonNull
    public Set<Attribute<T, ?>> describe() {
        return new HashSet(Arrays.asList(new MultivaluedAttribute("permissions", String.class).getter(MatrixAuthorizationStrategyConfigurator::getPermissions).setter(MatrixAuthorizationStrategyConfigurator::setPermissions), new MultivaluedAttribute("grantedPermissions", String.class).getter(unused -> null).setter(MatrixAuthorizationStrategyConfigurator::setPermissionsDeprecated)));
    }

    public static Collection<String> getPermissions(AuthorizationContainer container) {
        return container.getGrantedPermissionEntries().entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(v -> v.getType().toPrefix() + ((Permission)e.getKey()).group.getId() + "/" + ((Permission)e.getKey()).name + ":" + v.getSid())).sorted().collect(Collectors.toList());
    }

    public static void setPermissions(AuthorizationContainer container, Collection<String> permissions) {
        permissions.forEach(container::add);
    }

    public static void setPermissionsDeprecated(AuthorizationContainer container, Collection<String> permissions) {
        LOGGER.log(Level.WARNING, "Loading deprecated attribute 'grantedPermissions' for instance of '" + container.getClass().getName() + "'. Use 'permissions' instead.");
        MatrixAuthorizationStrategyConfigurator.setPermissions(container, permissions);
    }
}

