/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import hudson.Functions;
import hudson.Util;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Restricted(value={NoExternalUse.class})
class ValidationUtil {
    private static final VersionNumber jenkinsVersion = Jenkins.getVersion();

    private ValidationUtil() {
    }

    static String formatNonExistentUserGroupValidationResponse(String user, String tooltip) {
        return ValidationUtil.formatUserGroupValidationResponse(null, "<span style='text-decoration: line-through;'>" + tooltip + ": " + user + "</span>", tooltip);
    }

    static String formatUserGroupValidationResponse(String img, String label, String tooltip) {
        if (img == null) {
            return String.format("<span title='%s'>%s</span>", tooltip, label);
        }
        if (jenkinsVersion.isOlderThan(new VersionNumber("2.308"))) {
            return String.format("<span title='%s'><img src='%s%s/images/16x16/%s.png' style='margin-right:0.2em'>%s</span>", tooltip, Stapler.getCurrentRequest().getContextPath(), Jenkins.RESOURCE_PATH, img, label);
        }
        return String.format("<span title='%s'><img src='%s%s/images/svgs/%s.svg' width='16' style='margin-right:0.2em'>%s</span>", tooltip, Stapler.getCurrentRequest().getContextPath(), Jenkins.RESOURCE_PATH, img, label);
    }

    static FormValidation validateGroup(String groupName, SecurityRealm sr, boolean ambiguous) {
        String escapedSid = Functions.escape((String)groupName);
        try {
            sr.loadGroupByGroupname2(groupName, false);
            if (ambiguous) {
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("user", escapedSid, "Group found; but permissions would also be granted to a user of this name"));
            }
            return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("user", escapedSid, "Group"));
        }
        catch (UserMayOrMayNotExistException2 e) {
            if (ambiguous) {
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("user", escapedSid, "Permissions would also be granted to a user or group of this name"));
            }
            return FormValidation.ok((String)groupName);
        }
        catch (UsernameNotFoundException e) {
        }
        catch (AuthenticationException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the group name " + groupName));
        }
        return null;
    }

    static FormValidation validateUser(String userName, SecurityRealm sr, boolean ambiguous) {
        String escapedSid = Functions.escape((String)userName);
        try {
            sr.loadUserByUsername2(userName);
            User u = User.getById((String)userName, (boolean)true);
            if (userName.equals(u.getFullName())) {
                if (ambiguous) {
                    return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", escapedSid, "User found; but permissions would also be granted to a group of this name"));
                }
                return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", escapedSid, "User"));
            }
            if (ambiguous) {
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + escapedSid + " found, but permissions would also be granted to a group of this name"));
            }
            return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + escapedSid));
        }
        catch (UserMayOrMayNotExistException2 e) {
            if (ambiguous) {
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", escapedSid, "Permissions would also be granted to a user or group of this name"));
            }
            return FormValidation.ok((String)userName);
        }
        catch (UsernameNotFoundException e) {
        }
        catch (AuthenticationException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the user name " + userName));
        }
        return null;
    }
}

