/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainerDescriptor;
import org.jenkinsci.plugins.matrixauth.AuthorizationProperty;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public interface AuthorizationPropertyDescriptor<T extends AuthorizationProperty>
extends AuthorizationContainerDescriptor {
    public static final Logger LOGGER = Logger.getLogger(AuthorizationPropertyDescriptor.class.getName());

    public T create();

    default public T createNewInstance(StaplerRequest req, JSONObject formData, boolean hasOptionalWrap) throws Descriptor.FormException {
        if (hasOptionalWrap && (formData = formData.getJSONObject("useProjectSecurity")).isNullObject()) {
            return null;
        }
        T property = this.create();
        JSONObject data = formData.getJSONObject("data");
        property.setInheritanceStrategy((InheritanceStrategy)((Object)req.bindJSON(InheritanceStrategy.class, formData.getJSONObject("inheritanceStrategy"))));
        for (Map.Entry r : data.entrySet()) {
            String permissionEntryString = (String)r.getKey();
            PermissionEntry entry = PermissionEntry.fromString(permissionEntryString);
            if (entry == null) {
                LOGGER.log(Level.FINE, () -> "Failed to parse PermissionEntry from string: " + permissionEntryString);
                continue;
            }
            if (!(r.getValue() instanceof JSONObject)) {
                throw new Descriptor.FormException("not an object: " + formData, "data");
            }
            JSONObject value = (JSONObject)r.getValue();
            for (Map.Entry e : value.entrySet()) {
                if (!(e.getValue() instanceof Boolean)) {
                    throw new Descriptor.FormException("not an boolean: " + formData, "data");
                }
                if (!((Boolean)e.getValue()).booleanValue()) continue;
                Permission p = Permission.fromId((String)((String)e.getKey()));
                if (p == null) {
                    LOGGER.log(Level.FINE, "Silently skip unknown permission \"{0}\" for sid:\"{1}\", type: {2}", new Object[]{e.getKey(), entry.getSid(), entry.getType()});
                    continue;
                }
                property.add(p, entry);
            }
        }
        return property;
    }

    default public boolean isApplicable() {
        return Jenkins.get().getAuthorizationStrategy() instanceof ProjectMatrixAuthorizationStrategy;
    }
}

